<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_HSidebar {
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize() {
        // Add map for vc
        if ( class_exists( 'Vc_Manager' ) ) {
            add_action( 'init', array( __CLASS__, 'map' ) );
        }

        // Add shortcode
        add_shortcode( 'netbase_hsidebar', array( __CLASS__, 'shortcode_hsidebar' ) );

        // Enqueue script
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map() {
        $order_by_values = array(
            '',
            __( 'Date', 'udetor' )          => 'date',
            __( 'ID', 'udetor' )            => 'ID',
            __( 'Author', 'udetor' )        => 'author',
            __( 'Title', 'udetor' )         => 'title',
            __( 'Modified', 'udetor' )      => 'modified',
            __( 'Random', 'udetor' )        => 'rand',
            __( 'Comment count', 'udetor' ) => 'comment_count',
            __( 'Menu order', 'udetor' )    => 'menu_order',
        );
        $order_way_values = array(
            '',
            __( 'Descending', 'udetor' ) => 'DESC',
            __( 'Ascending', 'udetor' )  => 'ASC',
        );

        // Get all terms of toolkit
        $hsidebar_cat = array(
            __( 'All', 'udetor' ) => '',
        );
        $terms = get_terms( 'hsidebar_cat' );
        if ( $terms && ! isset( $terms->errors ) ) {
            foreach ( $terms as $key => $value ) {
                $hsidebar_cat[$value->name] = $value->term_id;
            }
        }

        // Map new Toolkit element.
        vc_map(
            array(
                'name'     => __( 'Sidebar', 'udetor' ),
                'base'     => 'netbase_hsidebar',
//				'icon'     => 'fa fa-picture-o',
                'category' => __( 'Udetor Elements', 'udetor' ),
                'params'   => array(
                    array(
                        'heading'     => __( 'Select a sidebar', 'udetor' ),
                        'param_name'  => 'select_sidebar',
                        'type'        => 'widgetised_sidebars',
                        'description' => __( 'Select widget area to display.', 'udetor' ),
                        'admin_label' => true,
                    ),
                    array(
                        'heading'     => __( 'Position', 'udetor' ),
                        'param_name'  => 'sidebar_position',
                        'type'        => 'dropdown',
                        'std'         => 'left',
                        'admin_label' => true,
                        'description' => __( 'Select position that display sidebar when click icon.', 'udetor' ),
                        'value'       => array(
                            __('Left', 'udetor')      => 'left',
                            __('Right', 'udetor')     => 'right',
                            __('Top', 'udetor')       => 'top',
                            __('Bottom', 'udetor')    => 'bottom',
                        ),
                    ),
                    array(
                        'heading'     => __( 'Width', 'udetor' ),
                        'param_name'  => 'sidebar_width',
                        'type'        => 'textfield',
                        'std'         => '300',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Unit', 'udetor' ),
                        'param_name'  => 'sidebar_width_unit',
                        'type'        => 'dropdown',
                        'std'         => 'px',
                        'admin_label' => true,
                        'value'       => array(
                            __('px', 'udetor')      => 'px',
                            __('%', 'udetor')       => '%',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Icon library', 'udetor' ),
                        'value' => array(
                            __( 'Font Awesome', 'udetor' ) => 'fontawesome',
                            __( 'Open Iconic', 'udetor' ) => 'openiconic',
                            __( 'Typicons', 'udetor' ) => 'typicons',
                            __( 'Entypo', 'udetor' ) => 'entypo',
                            __( 'Linecons', 'udetor' ) => 'linecons',
                            __( 'Mono Social', 'udetor' ) => 'monosocial',
                        ),
                        'admin_label' => true,
                        'param_name' => 'type',
                        'description' => __( 'Select icon library.', 'udetor' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => __( 'Icon', 'udetor' ),
                        'param_name' => 'icon_fontawesome',
                        'value' => 'fa fa-adjust', // default value to backend editor admin_label
                        'settings' => array(
                            'emptyIcon' => false,
                            // default true, display an "EMPTY" icon?
                            'iconsPerPage' => 4000,
                            // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                        ),
                        'dependency' => array(
                            'element' => 'type',
                            'value' => 'fontawesome',
                        ),
                        'description' => __( 'Select icon from library.', 'udetor' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => __( 'Icon', 'udetor' ),
                        'param_name' => 'icon_openiconic',
                        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
                        'settings' => array(
                            'emptyIcon' => false, // default true, display an "EMPTY" icon?
                            'type' => 'openiconic',
                            'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                        ),
                        'dependency' => array(
                            'element' => 'type',
                            'value' => 'openiconic',
                        ),
                        'description' => __( 'Select icon from library.', 'udetor' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => __( 'Icon', 'udetor' ),
                        'param_name' => 'icon_typicons',
                        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
                        'settings' => array(
                            'emptyIcon' => false, // default true, display an "EMPTY" icon?
                            'type' => 'typicons',
                            'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                        ),
                        'dependency' => array(
                            'element' => 'type',
                            'value' => 'typicons',
                        ),
                        'description' => __( 'Select icon from library.', 'udetor' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => __( 'Icon', 'udetor' ),
                        'param_name' => 'icon_entypo',
                        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
                        'settings' => array(
                            'emptyIcon' => false, // default true, display an "EMPTY" icon?
                            'type' => 'entypo',
                            'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                        ),
                        'dependency' => array(
                            'element' => 'type',
                            'value' => 'entypo',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => __( 'Icon', 'udetor' ),
                        'param_name' => 'icon_linecons',
                        'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
                        'settings' => array(
                            'emptyIcon' => false, // default true, display an "EMPTY" icon?
                            'type' => 'linecons',
                            'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                        ),
                        'dependency' => array(
                            'element' => 'type',
                            'value' => 'linecons',
                        ),
                        'description' => __( 'Select icon from library.', 'udetor' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'iconpicker',
                        'heading' => __( 'Icon', 'udetor' ),
                        'param_name' => 'icon_monosocial',
                        'value' => 'vc-mono vc-mono-fivehundredpx', // default value to backend editor admin_label
                        'settings' => array(
                            'emptyIcon' => false, // default true, display an "EMPTY" icon?
                            'type' => 'monosocial',
                            'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                        ),
                        'dependency' => array(
                            'element' => 'type',
                            'value' => 'monosocial',
                        ),
                        'description' => __( 'Select icon from library.', 'udetor' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Icon color', 'udetor' ),
                        'param_name' => 'color',
                        'value' => array_merge( getVcShared( 'colors' ), array( __( 'Custom color', 'udetor' ) => 'custom' ) ),
                        'description' => __( 'Select icon color.', 'udetor' ),
                        'param_holder_class' => 'vc_colored-dropdown',
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => __( 'Custom color', 'udetor' ),
                        'param_name' => 'custom_color',
                        'description' => __( 'Select custom icon color.', 'udetor' ),
                        'dependency' => array(
                            'element' => 'color',
                            'value' => 'custom',
                        ),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Hover icon color', 'udetor' ),
                        'param_name' => 'hover_color',
                        'value' => array_merge( getVcShared( 'colors' ), array( __( 'Custom color', 'udetor' ) => 'custom' ) ),
                        'description' => __( 'Select hover icon color.', 'udetor' ),
                        'param_holder_class' => 'vc_colored-dropdown',
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => __( 'Custom hover color', 'udetor' ),
                        'param_name' => 'custom_hover_color',
                        'description' => __( 'Select custom hover icon color.', 'udetor' ),
                        'dependency' => array(
                            'element' => 'hover_color',
                            'value' => 'custom',
                        ),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Background shape', 'udetor' ),
                        'param_name' => 'background_style',
                        'value' => array(
                            __( 'None', 'udetor' ) => '',
                            __( 'Circle', 'udetor' ) => 'rounded',
                            __( 'Square', 'udetor' ) => 'boxed',
                            __( 'Rounded', 'udetor' ) => 'rounded-less',
                            __( 'Outline Circle', 'udetor' ) => 'rounded-outline',
                            __( 'Outline Square', 'udetor' ) => 'boxed-outline',
                            __( 'Outline Rounded', 'udetor' ) => 'rounded-less-outline',
                        ),
                        'description' => __( 'Select background shape and style for icon.', 'udetor' ),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Background color', 'udetor' ),
                        'param_name' => 'background_color',
                        'value' => array_merge( getVcShared( 'colors' ), array( __( 'Custom color', 'udetor' ) => 'custom' ) ),
                        'std' => 'grey',
                        'description' => __( 'Select background color for icon.', 'udetor' ),
                        'param_holder_class' => 'vc_colored-dropdown',
                        'dependency' => array(
                            'element' => 'background_style',
                            'not_empty' => true,
                        ),
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => __( 'Custom background color', 'udetor' ),
                        'param_name' => 'custom_background_color',
                        'description' => __( 'Select custom icon background color.', 'udetor' ),
                        'dependency' => array(
                            'element' => 'background_color',
                            'value' => 'custom',
                        ),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Size', 'udetor' ),
                        'param_name' => 'size',
                        'value' => array_merge( getVcShared( 'sizes' ), array( 'Extra Large' => 'xl' ) ),
                        'std' => 'md',
                        'description' => __( 'Icon size.', 'udetor' ),
                    ),
                    array(
                        'type'        => 'attach_image',
                        'heading'     => __( 'Background image', 'udetor' ),
                        'param_name'  => 'sidebar_background',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
//                    array(
//                        'type' => 'attach_image',
//                        'holder' => 'img',
//                        'class' => 'images_test',
//                        'heading' => __( 'Upload Avatar', 'netbase_element_testimonial' ),
//                        'param_name' => 'sidebar_background',
//                        'description' => __('Follow upload image', 'netbase_element_testimonial'),
//                        'admin_label' => false,
//                        'group' => 'Custom Group',
//                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => __( 'Background Color', 'udetor' ),
                        'param_name' => 'sidebar_bg_color',
                        'description' => __( 'Select custom sidebar color.', 'udetor' ),
                    ),
                    array(
                        'param_name' => 'enable_center',
                        'heading'    => __( 'Enable center element', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'If enabled then Center Element Setting of element More on the same row will be disabled', 'udetor' ),
                    ),
                    array(
                        'heading'    => __( 'Extra class name', 'udetor' ),
                        'param_name' => 'extra_class',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'    => __( 'Custom id name', 'udetor' ),
                        'param_name' => 'custom_id',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'udetor' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'udetor' ),
                    )
                )
            )
        );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_hsidebar( $atts, $content = null ) {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'select_sidebar'        => '',
                    'type'                  => 'fontawesome',
                    'sidebar_position'      => 'left',
                    'sidebar_width'         => '300',
                    'sidebar_width_unit'    => 'px',
                    'icon_fontawesome'      => 'fa fa-adjust',
                    'icon_openiconic'       => 'vc-oi vc-oi-dial',
                    'icon_typicons'         => 'typcn typcn-adjust-brightness',
                    'icon_entypo'           => 'entypo-icon entypo-icon-note',
                    'icon_linecons'         => 'vc_li vc_li-heart',
                    'icon_monosocial'       => 'vc-mono vc-mono-fivehundredpx',
                    'color'                 => 'blue',
                    'custom_color'          => '',
                    'hover_color'           => 'blue',
                    'custom_hover_color'    => '',
                    'background_style'      => '',
                    'background_color'      => 'grey',
                    'custom_background_color'=> '',
                    'size'                  => '',
                    'sidebar_background'    => '',
                    'sidebar_bg_color'      => '',
                    'extra_class'           => '',
                    'custom_id'             => '',
                    'css'                   => '',
                ),
                $atts
            )
        );


        // Generate custom ID
        $id = uniqid( 'netbase_custom_css_' );


        // Enqueue needed icon font.
        vc_icon_element_fonts_enqueue( $type );
        $iconClass = isset( ${'icon_' . $type} ) ? esc_attr( ${'icon_' . $type} ) : 'fa fa-adjust';

        // color and hovor color needed icon
        ?>

        <script>
            // icon color
            var color = "<?php echo $color;?>";
            var custom_color = "<?php echo $custom_color;?>";
            var hover_color = "<?php echo $hover_color;?>";
            var custom_hover_color = "<?php echo $custom_hover_color; ?>";

            var main_color = (color !== 'custom') ? color : custom_color;
            var main_hover_color = (hover_color !== 'custom') ? hover_color : custom_hover_color;


            (function ($) {
                $(document).ready(function () {

                    // icon color
                    $('.edu-element-sidebar .icon-sidebar i').css('color', main_color);

                    // hover icon
                    $('.edu-element-sidebar .icon-sidebar i').hover(function () {
                        $(this).css('color', main_hover_color);
                    },function () {
                        $(this).css('color', main_color)
                    });


                });

            })(jQuery);

        </script>

        <?php

        // background shape
        $has_style = false;
        if ( strlen( $background_style ) > 0 ) {
            $has_style = true;
            if ( false !== strpos( $background_style, 'outline' ) ) {
                $background_style .= ' vc_icon_element-outline'; // if we use outline style it is border in css
            } else {
                $background_style .= ' vc_icon_element-background';
            }
        }
        $style_shape = '';
        if ( 'custom' === $background_color ) {
            if ( false !== strpos( $background_style, 'outline' ) ) {
                $style_shape = 'border-color:' . $custom_background_color;
            } else {
                $style_shape = 'background-color:' . $custom_background_color;
            }
        }
        $style_shape = $style_shape ? ' style="' . esc_attr( $style_shape ) . '"' : '';

        // sidebar animate
        $animate_class = 'animation-';
        $style_animate_sidebar = 'style="';
        $edu_sidebar_width = $sidebar_width . $sidebar_width_unit;

        switch ($sidebar_position) {
            case 'left':
                $animate_class .=  $sidebar_position;
                $style_animate_sidebar .= '-webkit-transform: translateX(-' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'transform: translateX(-' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'width: ' . $edu_sidebar_width . ';';
                $style_animate_sidebar .= 'left: 0;';
                $style_animate_sidebar .= 'top: 0;';
                $style_animate_sidebar .= 'height: 100%;';
                break;
            case 'right':
                $animate_class .= $sidebar_position;
                $style_animate_sidebar .= '-webkit-transform: translateX(' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'transform: translateX(' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'width: ' . $edu_sidebar_width . ';';
                $style_animate_sidebar .= 'right: 0;';
                $style_animate_sidebar .= 'top: 0;';
                $style_animate_sidebar .= 'height: 100%;';
                break;
            case 'top':
                $animate_class .=  $sidebar_position;
                $style_animate_sidebar .= '-webkit-transform: translateY(-' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'transform: translateY(-' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'height: ' . $edu_sidebar_width . ';';
                $style_animate_sidebar .= 'left: 0;';
                $style_animate_sidebar .= 'top: 0;';
                $style_animate_sidebar .= 'width: 100%;';
                break;
            case 'bottom':
                $animate_class .=  $sidebar_position;
                $style_animate_sidebar .= '-webkit-transform: translateY(' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'transform: translateY(' . $edu_sidebar_width . ');';
                $style_animate_sidebar .= 'height: ' . $edu_sidebar_width . ';';
                $style_animate_sidebar .= 'left: 0;';
                $style_animate_sidebar .= 'bottom: 0;';
                $style_animate_sidebar .= 'width: 100%;';
                break;
            default:
                $animate_class .= 'left';
        }

        if ($sidebar_bg_color !== '') {
            $style_animate_sidebar .= 'background-color: ' . $sidebar_bg_color . ' !important;';
        }
        if ($sidebar_background !== '') {
            $sidebar_image_url = wp_get_attachment_image_src($sidebar_background,'extra-large');
            $style_animate_sidebar .= 'background-image: url(' . $sidebar_image_url[0] . ');';
            $style_animate_sidebar .= 'background-position: center center;';
            $style_animate_sidebar .= 'background-repeat: no-repeat;';
            $style_animate_sidebar .= 'background-size: cover;';
            $style_animate_sidebar .= 'text-transform: none;';
        }
        $style_animate_sidebar .= '"';

        // style css
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ),'netbase_hsidebar', $atts );
        }
        // get content sidebar
        ob_start();
        dynamic_sidebar($select_sidebar);
        $content_sidebar = ob_get_clean();

        // get sidebarname
        global $wp_registered_sidebars;
        $edu_sidebar_name = ( isset( $wp_registered_sidebars[$select_sidebar] ) ? $wp_registered_sidebars[$select_sidebar]['name'] : NULL );

        // Generate HTML code.
        $html .= '<div id="' . esc_attr( $id ) . '" class="edu-element edu-element-sidebar '.$css_class.' '.$extra_class;
        $html .= '">';

            // icon sidebar
            $html .= '<div class="vc_icon_element vc_icon_element-outer';
                if ($has_style) {
                    $html .= ' vc_icon_element-have-style';
                }
            $html .= '">';

                $html .= '<div class="icon-sidebar';
                $html .= ' vc_icon_element-inner';
                $html .= ' vc_icon_element-size-' . esc_attr($size);
                $html .= ' vc_icon_element-style-' . esc_attr($background_style);
                $html .= ' vc_icon_element-background-color-' . esc_attr($background_color);
                if ($has_style) {
                    $html .= ' vc_icon_element-have-style-inner';
                }
                $html .= '"';

                $html .= $style_shape;

                $html .= '>';
                $html .= '<i class=" vc_icon_element-icon '.$iconClass.'"></i>';
                $html .= '</div>';

            $html .= '</div>';

            // content-sidebar
            $html .= '<div class="content-sidebar">';

                $html .= '<div class="animation-sidebar '.$animate_class.'" '.$style_animate_sidebar.'>';
                    $html .= '<div class="sidebar-inner">';
                        if ($content_sidebar !== '') {
                            $html .= $content_sidebar;
                        }else{
                            $html .= '<p>';
                                $html .= 'Please add widget to ' . $edu_sidebar_name . ' sidebar ';
                                $html .= '<a target="_blank" href="'.admin_url().'widgets.php">' . 'here' . '</a>';
                            $html .= '</p>';
                        }
                    $html .= '</div>';
                $html .= '</div>';

                $html .= '<div class="edu-close-mobile">';
                    $html .= '<span></span>';
                $html .= '</div>';

                $html .= '<div class="overlay">';
                $html .= '</div>';


            $html .= '</div>';

        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters( 'netbase_shortcode_hsidebar', force_balance_tags( $html ) );
    }


    /**
     * Enqueue scripts and styles.
     *
     * @return  void
     */
    public static function enqueue_scripts() {
        // Isotope
        wp_enqueue_script( 'isotope', NETBASE_TOOLKIT_URL . 'assets/vendors/nivo-lightbox/nivo-lightbox.min.js', array(), false, true );

        // hsidebar js
        wp_enqueue_script( 'edu-element-hsidebar', NETBASE_TOOLKIT_URL . 'assets/js/element/hsidebar.js', array(), false, true );

    }
}
