<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_HSearch {
	/**
	 * Initialize.
	 *
	 * @return  void
	 */
	public static function initialize() {
		// Add map for vc
		if ( class_exists( 'Vc_Manager' ) ) {
			add_action( 'init', array( __CLASS__, 'map' ) );
		}

		// Add shortcode
		add_shortcode( 'netbase_hsearch', array( __CLASS__, 'shortcode_hsearch' ) );

		// Enqueue script
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );
	}

	/**
	 * Map new parameters and elements.
	 *
	 * @since  1.0
	 * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
	 */
	public static function map() {
		$order_by_values = array(
			'',
			__( 'Date', 'udetor' )          => 'date',
			__( 'ID', 'udetor' )            => 'ID',
			__( 'Author', 'udetor' )        => 'author',
			__( 'Title', 'udetor' )         => 'title',
			__( 'Modified', 'udetor' )      => 'modified',
			__( 'Random', 'udetor' )        => 'rand',
			__( 'Comment count', 'udetor' ) => 'comment_count',
			__( 'Menu order', 'udetor' )    => 'menu_order',
		);
		$order_way_values = array(
			'',
			__( 'Descending', 'udetor' ) => 'DESC',
			__( 'Ascending', 'udetor' )  => 'ASC',
		);

		// Get all terms of toolkit
		$hsearch_cat = array(
			__( 'All', 'udetor' ) => '',
		);
		$terms = get_terms( 'hsearch_cat' );
		if ( $terms && ! isset( $terms->errors ) ) {
			foreach ( $terms as $key => $value ) {
				$hsearch_cat[$value->name] = $value->term_id;
			}
		}

		// Map new Toolkit element.
		vc_map(
			array(
				'name'     => __( 'Search', 'udetor' ),
				'base'     => 'netbase_hsearch',
//				'icon'     => 'fa fa-picture-o',
				'category' => __( 'Udetor Elements', 'udetor' ),
				'params'   => array(
					array(
						'heading'     => __( 'Layout type', 'udetor' ),
						'param_name'  => 'layout_style',
						'type'        => 'dropdown',
                        'std'         => 'dropdown',
						'value'       => array(
                            __( 'Fullscreen', 'udetor' )     => 'fullscreen',
                            __( 'Dropdown', 'udetor' )    => 'dropdown',
                            __( 'Boxed', 'udetor' )    => 'boxed',
                            __( 'Topbar', 'udetor' )    => 'topbar',
                            __( 'Expand width', 'udetor' )    => 'expand_width',
                        ),
						'admin_label' => true,
					),
                    array(
                        'heading'     => __( 'Theme', 'udetor' ),
                        'param_name'  => 'search_theme',
                        'type'        => 'dropdown',
                        'std'       => 'light',
                        'admin_label' => true,
                        'value'       => array(
                            __( 'Light', 'udetor' )     => 'light',
                            __( 'Dark', 'udetor' )    => 'dark',
                        ),
                    ),

                    // dropdown
                    array(
                        'param_name' => 'search_form_animation',
                        'heading'    => __( 'Form animation', 'udetor' ),
                        'type'       => 'dropdown',
                        'std'      => 'none',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'value' => array(
                            __( 'None', 'udetor' ) => 'none',
                            __( 'Fade', 'udetor' ) => 'fade',
                            __( 'Top to bottom', 'udetor' ) => 'top-to-bottom',
                            __( 'Bottom to top', 'udetor' ) => 'bottom-to-top',
                            __( 'Left to right', 'udetor' ) => 'left-to-right',
                            __( 'Right to left', 'udetor' ) => 'right-to-left',
                            __( 'Appear from center', 'udetor' ) => 'appear',
                        ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'dropdown',
                        ),
                    ),
                    array(
                        'param_name' => 'search_margin_top',
                        'heading'    => __( 'Form margin top', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => '',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'dropdown',
                        ),

                    ),

                    // boxed
                    array(
                        'param_name' => 'search_button_type',
                        'heading'    => __( 'Button type', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => 'icon',
                        'value' => array(
                            __( 'Icon', 'udetor' ) => 'icon',
                            __( 'Text', 'udetor' ) => 'text',
                        ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'boxed',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'search_text_button',
                        'heading'    => __( 'Text button', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 'Search',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'boxed',
                        ),
                    ),
                    array(
                        'param_name' => 'search_text_color_button',
                        'heading'    => __( 'Text color button', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#ffffff',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'search_button_type',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'param_name' => 'search_background_color_button',
                        'heading'    => __( 'Background color button', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#d6aa74',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'search_button_type',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'param_name' => 'search_hover_text_color_button',
                        'heading'    => __( 'Hover color button', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#ffffff',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'search_button_type',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'param_name' => 'search_hover_background_color_button',
                        'heading'    => __( 'Hover background color button', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#dea35b',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency' => array(
                            'element' => 'search_button_type',
                            'value'   => 'text',
                        ),
                    ),

                    // other

                    array(
                        'heading'     => __( 'Icon color', 'udetor' ),
                        'param_name'  => 'search_icon_color',
                        'type'        => 'colorpicker',
                        'value'        => '#333333',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Hover icon color', 'udetor' ),
                        'param_name'  => 'search_hover_icon_color',
                        'type'        => 'colorpicker',
                        'value'        => '#d6aa74',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Icon size', 'udetor' ),
                        'param_name'  => 'search_icon_size',
                        'type'        => 'textfield',
                        'value'        => '14',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Place holder', 'udetor' ),
                        'param_name'  => 'search_place_holder',
                        'type'        => 'textfield',
                        'std'         => '',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Width text search', 'udetor' ),
                        'param_name'  => 'search_width',
                        'type'        => 'textfield',
                        'std'         => '300',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'param_name' => 'enable_center',
                        'heading'    => __( 'Enable center element', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'If enabled then Center Element Setting of element More on the same row will be disabled', 'udetor' ),
                    ),
					array(
                        'heading'    => __( 'Extra class name', 'udetor' ),
						'param_name' => 'extra_class',
						'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
					),
                    array(
                        'heading'    => __( 'Custom id name', 'udetor' ),
                        'param_name' => 'custom_id',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'udetor' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'udetor' ),
                    )
				)
			)
		);
	}

	/**
	 * Add shortcode toolkit.
	 *
	 * @since  1.0
	 */
	public static function shortcode_hsearch( $atts, $content = null ) {
		$html = $attr_parent = '';

		// Extract shortcode parameters.
		extract(
			shortcode_atts(
				array(
					'search_type'             => 'image',
					'layout_style'            => 'dropdown',
					'search_theme'            => 'light',
					'search_button_type'      => 'icon',
					'search_text_button'      => 'Search',
					'search_text_color_button'=> '#ffffff',
					'search_background_color_button' => '#d6aa74',
					'search_hover_text_color_button' => '#ffffff',
					'search_hover_background_color_button' => '#dea35b',
					'search_icon_color'       => '',
					'search_hover_icon_color' => '',
					'search_icon_size'        => '14',
					'search_place_holder'     => '',
					'search_form_animation'   => 'none',
					'search_margin_top'       => '',
					'search_width'            => '300',
					'search_content'          => 'Search',
					'color'                   => '#000000',
					'font_size'               => '20',
					'font_weight'             => '400',
					'font_style'              => 'normal',
					'line_height'             => '20',
					'letter_spacing'          => '0',
					'enable_center'           => 'no',
					'extra_class'             => '',
					'custom_id'               => '',
					'css'                     => '',
				),
				$atts
			)
		);

		// Generate custom ID
        $id = ($custom_id !== '') ? $custom_id : uniqid( 'netbase_custom_css_' );

		// layout type
        $class_layout_type = '';
        switch ($layout_style) {
            case 'fullscreen':
                $class_layout_type = 'edu-search-fs';
                break;
            case 'dropdown':
                $class_layout_type = 'edu-search-dropdown';
                break;
            case 'boxed':
                $class_layout_type = 'edu-search-boxed';
                break;
            case 'expand_width':
                $class_layout_type = 'edu-search-expand_width';
                break;
        }


        // style for icon search
        if ($search_button_type == 'icon') {

            $icon_search_style = '';
            $icon_search_style .= 'style="';
            $icon_search_style .= 'color: ' . $search_icon_color . ' !important';
            $icon_search_style .= '"';
            ?>

            <script>
                var color = "<?php echo $search_icon_color;?>";
                var hover = "<?php echo $search_hover_icon_color;?>";
                (function ($) {
                    $(document).ready(function () {
                        $('.edu-element-search .search-inner .open').hover(function () {
                            $(this).css('color', hover);
                        }, function () {
                            $(this).css('color', color);
                        });
                    });
                })(jQuery);
            </script>

            <?php
        }elseif ($search_button_type == 'text'){
            // style for button text search
            $button_text_search_style = '';
            $button_text_search_style .= 'style="';
            $button_text_search_style .= 'color: ' . $search_text_color_button . ' !important;';
            $button_text_search_style .= 'background-color: ' . $search_background_color_button . ' !important;';
            $button_text_search_style .= '"';

            ?>

            <script>
                var color_button = "<?php echo $search_text_color_button;?>";
                var color_background_button = "<?php echo $search_background_color_button;?>";
                var color_hover_button = "<?php echo $search_hover_text_color_button;?>";
                var color_hover_background_button = "<?php echo $search_hover_background_color_button;?>";

                (function ($) {
                    $(document).ready(function () {
                        $('.button-text .search-inner .open').hover(function () {
                            $(this).css('color', color_hover_button);
                            $(this).css('background-color', color_hover_background_button);
                        },function () {
                            $(this).css('color', color_button);
                            $(this).css('background-color', color_background_button);
                        });
                    });
                })(jQuery);

            </script>

            <?php
        }


        // style for input search
        $input_search_style = '';
        $input_search_style .= 'style="';
        $input_search_style .= 'width: ' . $search_width . 'px !important;';
        $input_search_style .= '"';

        // get class css editor
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ),'netbase_hsearch', $atts );
        }

        // Generate HTML code.
		$html .= '<div id="' . esc_attr( $id ) . '" class="edu-element edu-element-search ';
        // enable center element
        if ($enable_center == 'yes') {
            $html .= 'edu-element-center';
            $html .= ' ';
        }
        // extra class
        if ($extra_class !== '') {
            $html .= $extra_class;
            $html .= ' ';
        }

        if ($layout_style == 'dropdown') {
            $html .= 'animate-' . $search_form_animation;
            $html .= ' ';
        }
        if ($layout_style !== 'boxed') {
            $html .= $css_class;
        }else{
            $html .= 'button-' . $search_button_type;
        }

        $html .= ' edu-'.$layout_style;
        $html .= '"';

        if ($layout_style == 'dropdown') {
            $html .= ' animation-type="' . $search_form_animation.'"';
            $html .= ' data-margin-top="' . $search_margin_top . '"';
        }


        $html .= '>';

            $html .= '<div class="search-inner">';

                // input search
                $html .= '<div class="search-form '.$class_layout_type.'">';

                //ToDO : custom margin
                    $html .= '<div class="search-form-inner '.$search_theme.'-background" style="margin-top: '.$search_margin_top.'px;">';

                        $html .= '<form class="edu-form-search" action="'.get_home_url().'" method="get" role="search">';
                            $html .= '<input required type="text" placeholder="'.$search_place_holder.'" name="s" class="txt-search ';
                            if ($layout_style == 'boxed') {
                                $html .= $css_class;
                            }
                                $html .= '"';
                            $html .= ' '.$input_search_style.'>';
                            $html .= '<input type="submit" class="btn-search">';
                        $html .= '</form>';

                        $html .= '<div class="close"></div>';

                    $html .= '</div>';
                $html .= '</div>';

                // icon search
                if ($search_button_type == 'icon') {
                    $html .= '<span class="open" '.$icon_search_style.'>';
                        $html .= '<i class="fa fa-search "  aria-hidden="true" style="font-size: '.$search_icon_size.'px; !important">';
                        $html .= '</i>';
                    $html .= '</span>';
                }else{
                    $html .= '<span class="open" '.$button_text_search_style.'>';
                        $html .= $search_text_button;
                    $html .= '</span>';

                }


            $html .= '</div>';
		$html .= '</div>';

		wp_reset_postdata();

		return apply_filters( 'netbase_shortcode_hsearch', force_balance_tags( $html ) );
	}


	/**
	 * Enqueue scripts and styles.
	 *
	 * @return  void
	 */
	public static function enqueue_scripts() {        

        // Hsearch javascript
        wp_enqueue_script( 'edu-element-hsearch', NETBASE_TOOLKIT_URL . 'assets/js/element/hsearch.js', array(), false, true );
	}
}
