<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

if ( ! defined( 'ABSPATH' ) )
    exit;
class Netbase_Toolkit_Element_HMenu {

    /**
     * attribute layout style : custom or mega menu
     */

    public static $layout_style;

    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize() {
        // Add map for vc
        if ( class_exists( 'Vc_Manager' ) ) {
            add_action( 'init', array( __CLASS__, 'map' ) );
        }
        // Add shortcode
        add_shortcode( 'netbase_hmenu', array( __CLASS__, 'shortcode_hmenu' ) );

        // Enqueue script
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_s' ) );

    }

    public static function enqueue_s(){
        wp_enqueue_style('edu-element-hmenu-mega', NETBASE_TOOLKIT_URL . 'assets/css/element/hmenu-mega.css');
        wp_enqueue_script( 'edu-element-hmenu-mega', NETBASE_TOOLKIT_URL . 'assets/js/element/hmenu-mega.js', array(), false, true );
    }
    
    public static function map() {
        $order_by_values = array(
            '',
            __( 'Date', 'udetor' )          => 'date',
            __( 'ID', 'udetor' )            => 'ID',
            __( 'Author', 'udetor' )        => 'author',
            __( 'Title', 'udetor' )         => 'title',
            __( 'Modified', 'udetor' )      => 'modified',
            __( 'Random', 'udetor' )        => 'rand',
            __( 'Comment count', 'udetor' ) => 'comment_count',
            __( 'Menu order', 'udetor' )    => 'menu_order',
        );
        $order_way_values = array(
            '',
            __( 'Descending', 'udetor' ) => 'DESC',
            __( 'Ascending', 'udetor' )  => 'ASC',
        );

        // Get all terms of toolkit
        $hmenu_cat = array(
            __( 'All', 'udetor' ) => '',
        );
        $terms = get_terms( 'hmenu_cat' );
        if ( $terms && ! isset( $terms->errors ) ) {
            foreach ( $terms as $key => $value ) {
                $hmenu_cat[$value->name] = $value->term_id;
            }
        }

        // Get Menu List
        $custom_menus = array();
        if ( 'vc_edit_form' === vc_post_param( 'action' ) && vc_verify_admin_nonce() ) {
            $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
            if ( is_array( $menus ) && ! empty( $menus ) ) {
                foreach ( $menus as $single_menu ) {
                    if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
                        $custom_menus[ $single_menu->name ] = $single_menu->term_id;
                    }
                }
            }
        }

        $getname_menu = array();
        if ( 'vc_edit_form' === vc_post_param( 'action' ) && vc_verify_admin_nonce() ) {
            $allmenus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
            if ( is_array( $allmenus ) && ! empty( $allmenus ) ) {
                foreach ( $allmenus as $single_menu ) {
                    if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
                        $getname_menu[ $single_menu->name ] = $single_menu->slug;
                    }
                }
            }
        }

        // Map new Toolkit element.
        vc_map(
            array(
                'name'     => __( 'Menu', 'udetor' ),
                'base'     => 'netbase_hmenu',
                'category' => __( 'Udetor Elements', 'udetor' ),
                'params'   => array(
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Choose menu', 'udetor' ),
                        'param_name' => 'nav_menu',
                        'value' => $getname_menu,
                        'description' => empty( $getname_menu ) ? __( 'Custom menus not found. Please visit <b>Appearance > Menus</b> page to create new menu.', 'udetor' ) : __( 'Select menu to display.', 'udetor' ),
                        'admin_label' => true,
                        'save_always' => true,
                    ),
                    array(
                        'heading'     => __( 'Layout style', 'udetor' ),
                        'param_name'  => 'layout_style',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'         =>'text',
                        'value'       => array(
                            /*__('Text' , 'udetor') => 'text',
                            __('Icon' , 'udetor') => 'icon',*/
                            __('Mega' , 'udetor') => 'mega'
                        ),
                    ),
                    array(
                        'heading'     => __( 'Menu style', 'udetor' ),
                        'param_name'  => 'menu_style',
                        'type'        => 'dropdown',
                        'std'        => 'fullscreen',
                        'admin_label' => true,
                        'value'       => array(
                            __('Fullscreen' , 'udetor') => 'fullscreen',
                            __('Sidebar' , 'udetor') => 'sidebar',
                        ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => __( 'Effect', 'udetor' ),
                        'param_name' => 'css_animation_effect',
                        'admin_label' => true,
                        'std'       => 'fade',
                        'value' => array(
                            __( 'No', 'udetor' ) => 'none',
                            __( 'Fade', 'udetor' ) => 'fade',
                            __( 'Appear from center', 'udetor' ) => 'appear',
                        ),
                        'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'udetor' ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'fullscreen',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Position', 'udetor' ),
                        'param_name'  => 'sidebar_postion',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'        => 'left',
                        'value'       => array(
                            __('Left' , 'udetor')      => 'left',
                            __('Right' , 'udetor')    => 'right',
                        ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'sidebar',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Animation', 'udetor' ),
                        'param_name'  => 'sidebar_animation',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'        => 'slide_in_on_top',
                        'value'       => array(
                            __('Slide in on top' , 'udetor')      => 'slide_in_on_top',
                            __('Push' , 'udetor')    => 'push',
                            __('Fall down' , 'udetor')    => 'fall_down',
                            __('Fall up' , 'udetor')    => 'fall_up',
                        ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'sidebar',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Vertical align', 'udetor' ),
                        'param_name'  => 'sidebar_vertical_align',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'        => 'middle',
                        'value'       => array(
                            __('Top' , 'udetor')      => 'top',
                            __('Middle' , 'udetor')    => 'middle',
                            __('Bottom' , 'udetor')    => 'bottom',
                        ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'sidebar',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'param_name' => 'icon_color',
                        'heading'    => __( 'Icon color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#333333',
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'icon',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Width', 'udetor' ),
                        'param_name'  => 'sidebar_width',
                        'type'        => 'textfield',
                        'admin_label' => true,
                        'value'       => '300',
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'sidebar',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Unit', 'udetor' ),
                        'param_name'  => 'sidebar_unit',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'        => 'px',
                        'value'       => array(
                            __('px' , 'udetor')      => 'px',
                            __('%' , 'udetor')    => '%',
                        ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'sidebar',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'menu_background_image',
                        'heading'    => __( 'Background image', 'udetor' ),
                        'type'       => 'attach_image',
                        'value'      => '',
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'icon',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'menu_background_color',
                        'heading'    => __( 'Background Color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#ffffff',
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'icon',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Hover style', 'udetor' ),
                        'param_name'  => 'hover_style',
                        'type'        => 'dropdown',
                        'std'         => 'default',
                        'admin_label' => true,
                        'value'       => array(
                            __('Default' , 'udetor')      => 'default',
                            __('Underline' , 'udetor')    => 'underline',
                            __('Background' , 'udetor')   => 'background',
                            __('Outline' , 'udetor')      => 'outline',
                        ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => array('icon', 'text'),
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Border style', 'udetor' ),
                        'param_name'  => 'border_style',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'         => 'solid',
                        'value'       => array(
                            __('Solid' , 'udetor')      => 'solid',
                            __('Dashed' , 'udetor')     => 'dashed',
                            __('Dotted' , 'udetor')     => 'dotted',
                            __('Double' , 'udetor')     => 'double',
                            __('Groove' , 'udetor')     => 'groove',
                            __('Inset' , 'udetor')      => 'inset',
                            __('Outset' , 'udetor')     => 'outset',
                            __('Ridge' , 'udetor')      => 'ridge',
                        ),
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => 'outline',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Underline style', 'udetor' ),
                        'param_name'  => 'underline_style',
                        'type'        => 'dropdown',
                        'admin_label' => true,
                        'std'         => 'solid',
                        'value'       => array(
                            __('Solid' , 'udetor')      => 'solid',
                            __('Dashed' , 'udetor')     => 'dashed',
                            __('Dotted' , 'udetor')     => 'dotted',
                            __('Double' , 'udetor')     => 'double',
                            __('Groove' , 'udetor')     => 'groove',
                            __('Inset' , 'udetor')      => 'inset',
                            __('Outset' , 'udetor')     => 'outset',
                            __('Ridge' , 'udetor')      => 'ridge',
                        ),
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => 'underline',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Underline width', 'udetor' ),
                        'param_name'  => 'underline_width',
                        'type'        => 'textfield',
                        'admin_label' => true,
                        'value'       => '2',
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => 'underline',
                        ),
                    ),
                    array(
                        'heading'     => __( 'Border width', 'udetor' ),
                        'param_name'  => 'border_width',
                        'type'        => 'textfield',
                        'admin_label' => true,
                        'value'       => '2',
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => 'outline',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'     => __( 'Border radius', 'udetor' ),
                        'param_name'  => 'border_radius',
                        'type'        => 'textfield',
                        'admin_label' => true,
                        'value'       => '0',
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => array('background','outline'),
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Use color hover default Setting', 'udetor' ),
                        'param_name' => 'color_hover_default',
                        'value' => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'Use font family from the theme.', 'udetor' ),
                        
                    ),
                    array(
                        'param_name' => 'hover_text_color',
                        'heading'    => __( 'Hover text color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#d6aa74',
                        'dependency' => array(
                            'element' => 'color_hover_default',
                            'value_not_equal_to' => 'yes',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'hover_outline_color',
                        'heading'    => __( 'Hover outline color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#ebebeb',
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => 'outline',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'hover_background_color',
                        'heading'    => __( 'Hover background color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#ebebeb',
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => 'background',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'underline_color',
                        'heading'    => __( 'Underline color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#ebebeb',
                        'dependency' => array(
                            'element' => 'hover_style',
                            'value'   => 'underline',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'enable_center',
                        'heading'    => __( 'Enable center element', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'If enabled then Center Element Setting of element More on the same row will be disabled', 'udetor' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'hide_icon_has_children',
                        'heading'    => __( 'Hide icon has children', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'heading'     => __( 'Box Position', 'udetor' ),
                        'param_name'  => 'icon_box_position',
                        'type'        => 'dropdown',
                        'std'         => 'left',
                        'value'       => array(
                            __( 'Left', 'udetor' )     => 'left',
                            __( 'Center', 'udetor' )     => 'center',
                            __( 'Right', 'udetor' )    => 'right',
                        ),
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'heading'    => __( 'Extra class name', 'udetor' ),
                        'param_name' => 'extra_class',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'heading'    => __( 'Custom id name', 'udetor' ),
                        'param_name' => 'custom_id',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'param_name' => 'show_icon_cart_is_mobile',
                        'heading'    => __( 'Show icon cart header mobile', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    // Text options
                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Use theme default font family?', 'udetor' ),
                        'param_name' => 'use_theme_fonts',
                        'value' => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'Use font family from the theme.', 'udetor' ),
                        'group' => __( 'Text options', 'udetor' ),
                    ),
                    array(
                        'type' => 'google_fonts',
                        'param_name' => 'google_fonts',
                        'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
                        'settings' => array(
                            'fields' => array(
                                'font_family_description' => __( 'Select font family.', 'udetor' ),
                                'font_style_description' => __( 'Select font styling.', 'udetor' ),
                            ),
                        ),
                        'dependency' => array(
                            'element' => 'use_theme_fonts',
                            'value_not_equal_to' => 'yes',
                        ),
                        'group' => __( 'Text options', 'udetor' ),
                    ),
                    array(
                        'type' => 'font_container',
                        'param_name' => 'font_container',
                        'value' => 'tag:h2|text_align:left',
                        'settings' => array(
                            'fields' => array(
                                'text_transform' => 'none',
                                'font_style' => 'normal',
                                'text_align' => 'left',
                                'font_size' => '14px',
                                'line_height' => '21px',
                                'color' => '#000000',
                                'tag_description' => __( 'Select element tag.', 'udetor' ),
                                'text_align_description' => __( 'Select text alignment.', 'udetor' ),
                                'font_size_description' => __( 'Enter font size.', 'udetor' ),
                                'line_height_description' => __( 'Enter line height.', 'udetor' ),
                                'color_description' => __( 'Select heading color.', 'udetor' ),
                            ),
                        ),
                        'group' => __( 'Text options', 'udetor' ),
                    ),

                    array(
                        'param_name' => 'letter_spacing',
                        'heading'    => __( 'Letter Spacing', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 0,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Text options', 'udetor' ),
                    ),
                    array(
                        'param_name' => 'menu_item_spacing',
                        'heading'    => __( 'Item spacing', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 30,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Text options', 'udetor' ),
                    ),

                    // Submenu options
                    array(
                        'param_name' => 'submenu_animation_text',
                        'heading'    => __( 'Submenu Animation 1', 'udetor' ),
                        'type'       => 'dropdown',
                        'std'       => 'none',
                        'value' => array(
                            __( 'No', 'udetor' ) => 'none',
                            __( 'Fade', 'udetor' ) => 'fade',
                            __( 'Top to bottom', 'udetor' ) => 'top-to-bottom',
                            __( 'Bottom to top', 'udetor' ) => 'bottom-to-top',
                            __( 'Left to right', 'udetor' ) => 'left-to-right',
                            __( 'Right to left', 'udetor' ) => 'right-to-left',
                            __( 'Appear from center', 'udetor' ) => 'appear',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'param_name' => 'submenu_margin_top',
                        'heading'    => __( 'Margin top', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => '',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'param_name' => 'submenu_animation_icon_fullscreen',
                        'heading'    => __( 'Submenu Animation 2', 'udetor' ),
                        'type'       => 'dropdown',
                        'std'       => 'slide',
                        'value' => array(
                            __( 'Slide', 'udetor' ) => 'slide',
                            __( 'Accordion', 'udetor' ) => 'accordion',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'icon',
                        ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'fullscreen',
                        ),
                    ),

                    array(
                        'param_name' => 'submenu_animation_icon_sidebar',
                        'heading'    => __( 'Submenu Animation 3', 'udetor' ),
                        'type'       => 'dropdown',
                        'std'       => 'normal',
                        'value' => array(
                            __( 'Normal', 'udetor' ) => 'normal',
                            __( 'Slide', 'udetor' ) => 'slide',
                            __( 'Accordion', 'udetor' ) => 'accordion',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'icon',
                        ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'sidebar',
                        ),
                    ),
                    array(
                        'param_name' => 'submenu_effect',
                        'heading'    => __( 'Submenu effect', 'udetor' ),
                        'type'       => 'dropdown',
                        'std'      => 'none',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'value' => array(
                            __( 'None', 'udetor' ) => 'none',
                            __( 'Fade', 'udetor' ) => 'fade',
                            __( 'Top to bottom', 'udetor' ) => 'top-to-bottom',
                            __( 'Bottom to top', 'udetor' ) => 'bottom-to-top',
                            __( 'Left to right', 'udetor' ) => 'left-to-right',
                            __( 'Right to left', 'udetor' ) => 'right-to-left',
                            __( 'Appear from center', 'udetor' ) => 'appear',
                        ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'icon',
                        ),
                        'dependency' => array(
                            'element' => 'menu_style',
                            'value'   => 'sidebar',
                        ),
                        'dependency' => array(
                            'element' => 'submenu_animation_icon_sidebar',
                            'value'   => 'normal',
                        ),
                    ),

                    array(
                        'type' => 'font_container',
                        'param_name' => 'submenu_font_container',
                        'settings' => array(
                            'fields' => array(
                                'text_transform' => 'none',
                                'font_weight' => '400',
                                'font_style' => 'normal',
                                'text_align' => 'left',
                                'font_size' => '13px',
                                'line_height' => '22px',
                                'color' => '#000000',
                                'tag_description' => __( 'Select element tag.', 'udetor' ),
                                'text_align_description' => __( 'Select text alignment.', 'udetor' ),
                                'font_size_description' => __( 'Enter font size.', 'udetor' ),
                                'line_height_description' => __( 'Enter line height.', 'udetor' ),
                                'color_description' => __( 'Select heading color.', 'udetor' ),
                            ),
                        ),
                        'group' => __( 'Submenu options', 'udetor' ),
                    ),
                    array(
                        'param_name' => 'submenu_hover_text_color',
                        'heading'    => __( 'Hover text color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                    ),
                    array(
                        'param_name' => 'submenu_background_color',
                        'heading'    => __( 'Background color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'submenu_animation_icon_sidebar',
                            'value'   => 'normal',
                        ),
                    ),
                    array(
                        'param_name' => 'submenu_mega_background_color',
                        'heading'    => __( 'Background color', 'udetor' ),
                        'type'       => 'colorpicker',
                        'value'      => '#ededed',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'mega',
                        ),
                    ),
                    array(
                        'param_name' => 'submenu_width_normal',
                        'heading'    => __( 'Width', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 220,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'submenu_animation_icon_sidebar',
                            'value'   => 'normal',
                        ),
                    ),
                    array(
                        'param_name' => 'submenu_width_text',
                        'heading'    => __( 'Width', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 220,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'param_name' => 'submenu_letter_spacing',
                        'heading'    => __( 'Letter spacing', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 0,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'group' => __( 'Submenu options', 'udetor' ),
                    ),
                    array(
                        'param_name' => 'submenu_possition',
                        'heading'    => __( 'Possition', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __('Left', 'udetor')     => 'left',
                            __('Center', 'udetor')   => 'center',
                            __('Right', 'udetor')    => 'right'
                        ),
                        'std'        => 'left',
                        'group'      => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'mega',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'param_name' => 'max_width_layout_designer',
                        'heading'    => __( 'Max Width Layout Designer', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 500,
                        'group'      => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'mega',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

                    array(
                        'param_name' => 'full_screen_layout_designer',
                        'heading'    => __( 'Full Screen Layout Designer', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'group'      => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'mega',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'description' => __( 'If enabled then Center Element Setting of element More on the same row will be disabled', 'udetor' ),
                    ),

                    array(
                        'param_name' => 'box_shadow_submenu',
                        'heading'    => __( 'Box Shadow', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'group'      => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'mega',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'description' => __( 'If enabled then Shadow of element will be show', 'udetor' ),
                    ),

                    array(
                        'param_name' => 'tooltip_submenu',
                        'heading'    => __( 'Submenu as Tooltip', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'group'      => __( 'Submenu options', 'udetor' ),
                        'dependency' => array(
                            'element' => 'layout_style',
                            'value'   => 'mega',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'description' => __( 'If enabled then Shadow of element will be show', 'udetor' ),
                    ),

                    // CSS options
                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'udetor' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'udetor' ),
                    )
                )
            )
        );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_hmenu( $atts, $content = null ) {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'nav_menu'              =>'',
                    'layout_style'          => 'mega',
                    'hover_style'           => 'default',
                    'border_radius'         => '0',
                    'hover_background_color'=> '#ebebeb',                    
                    'underline_style'       => 'solid',
                    'underline_width'       => '2',
                    'underline_color'       => '#ebebeb',
                    'border_style'          => 'solid',
                    'border_width'          => '2',
                    'hover_outline_color'   => '#ebebeb',
                    'enable_center'         => 'no',
                    'hide_icon_has_children' => 'no',
                    'show_icon_cart_is_mobile' => '',
                    'hover_text_color'      => '#d6aa74',
                    'color_hover_default' => '',
                    'font_container'        => 'font_size:14px|text_align:left|color:#000000|line_height:21px',
                    'google_fonts'          => '',
                    'submenu_width_text'    => '220',
                    'submenu_font_container'=> '',
                    'submenu_hover_text_color'=> '',
                    'submenu_margin_top'    => '',
                    'submenu_animation_text'=> 'none',
                    'letter_spacing'        => '0',
                    'submenu_letter_spacing'=> '0',
                    'menu_item_spacing'     => '30',
                    'menu_style'            => 'fullscreen',
                    'css_animation_effect'  => 'fade',
                    'icon_color'            => '#333333',
                    'menu_background_image' => '',
                    'sidebar_postion'       => 'left',
                    'sidebar_width'         => '300',
                    'sidebar_unit'          => 'px',
                    'sidebar_vertical_align'=> 'middle',
                    'sidebar_animation'     => 'slide_in_on_top',
                    'submenu_animation_icon_sidebar' => 'normal',
                    'submenu_animation_icon_fullscreen' => 'slide',
                    'submenu_effect'        => 'none',
                    'submenu_mega_background_color' => '#ededed',
                    'submenu_possition'     => 'left',
                    'max_width_layout_designer' => '500',
                    'full_screen_layout_designer' => '',
                    'box_shadow_submenu' => '',
                    'extra_class'           => '',
                    'custom_id'             => '',
                    'use_theme_fonts'       => '',
                    'css'                   => '',
                    'icon_box_position'     => 'left',
                ),
                $atts
            )
        );
        
        $extraclass = array();
        
        if($hide_icon_has_children == 'yes'){
            $extraclass[] = 'hide-icon-has-children';
        }
        if ($extra_class !== '') {
            $extraclass[] = $extra_class;
        }
        // Generate custom ID
        $id = ($custom_id !== '') ? $custom_id : uniqid( 'netbase_custom_css_' );

        // position
        $pclasses['style-p'] = '';
        if (is_rtl()) {
            switch ($icon_box_position) {
            case 'left':
                $pclasses['style-p'] .= 'float:left;';
                break;
            case 'right':
                $pclasses['style-p'] .= 'float:right;';
                break;
            case 'center':
                $pclasses['style-p'] .= 'right: 50% !important;transform: translateX(50%);z-index: 9999;';
                break;
            }

        }else{
            switch ($icon_box_position) {
            case 'left':
                $pclasses['style-p'] .= 'float:left;';
                break;
            case 'right':
                $pclasses['style-p'] .= 'float:right;';
                break;
            case 'center':
                $pclasses['style-p'] .= 'left: 50% !important;transform: translateX(-50%);z-index: 9999;';
                break;
            }
        }
        

        // Get layout style
        $classes['layout-style'] = $layout_style;

        // Get hover style menu
        $classes['hover-style'] = 'style="';
        $classes['hover-style-outline'] = 'style="';

        $classes['hover-style'] .= '"';
        $classes['hover-style-outline'] .= '"';

        if ($menu_style == 'fullscreen') {
            $classes['submenu-animation'] = $submenu_animation_icon_fullscreen;
        }else{
            $classes['submenu-animation'] = $submenu_animation_icon_sidebar;
        }
        $font_container_field = array();
        $submenu_font_container_field = array();
        if (  class_exists( 'WPBMap' ) ) {
            $font_container_field = WPBMap::getParam('netbase_hmenu', 'font_container');
            $submenu_font_container_field = WPBMap::getParam('netbase_hmenu', 'submenu_font_container');
        }
        $font_container_obj = '';
        if ( class_exists( 'Vc_Font_Container' ) ) {
            $font_container_obj = new Vc_Font_Container();
        }
        $font_container_field_settings = isset( $font_container_field['settings'], $font_container_field['settings']['fields'] ) ? $font_container_field['settings']['fields'] : array();


        $submenu_font_container_field_settings = isset( $submenu_font_container_field['settings'], $submenu_font_container_field['settings']['fields'] ) ? $font_container_field['settings']['fields'] : array();
        $submenu_font_container_data = $font_container_data ='';
        if($font_container_obj !='' ){
            $font_container_data = $font_container_obj->_vc_font_container_parse_attributes($font_container_field_settings, $font_container);
            $submenu_font_container_data = $font_container_obj->_vc_font_container_parse_attributes($submenu_font_container_field_settings, $submenu_font_container);
        }
        $google_fonts_data ='';
        if ($use_theme_fonts !== 'yes') {
            $google_fonts_field = array();
            if (  class_exists( 'WPBMap' ) ) {
                $google_fonts_field = WPBMap::getParam('netbase_hmenu','google_fonts');
            }
            $google_fonts_obj ='';
            if (  class_exists( 'Vc_Google_Fonts' ) ) {
                $google_fonts_obj = new Vc_Google_Fonts();
            }
            $google_fonts_field_settings = isset( $google_fonts_field['settings'], $google_fonts_field['settings']['fields'] ) ? $google_fonts_field['settings']['fields'] : array();
            if($google_fonts_obj !=''){
                $google_fonts_data = $google_fonts_obj->_vc_google_fonts_parse_attributes($google_fonts_field_settings, $google_fonts);
            }
            
        }

        $arr_text_option_style = self::getStyles($css, $google_fonts_data, $font_container_data, $atts);

        $arr_submenu_text_option_style = self::getStyles($css, $google_fonts_data, $submenu_font_container_data, $atts);

        $text_option_style = 'style="';
        $text_option_style_icon = '';
        $submenu_text_option_style = '';
        $menu_text_color = '';
        $submenu_text_color = '';

        /*set menu with header color customizer*/
        $set_df_header_color = get_theme_mod( 'udetor_header_default_custom_color', false ); 
        $df_header_color = get_theme_mod( 'udetor_header_color_df', '#ffffff' ); 

        if($set_df_header_color  && $df_header_color !=''){
            $arr_text_option_style['styles'][1] = "color: $df_header_color";
        }
        
        foreach ($arr_text_option_style['styles'] as $style) {
            if (strpos($style, 'color:') !== false) {
                $menu_text_color = explode(':', $style);
                $menu_text_color = end($menu_text_color);
            }

            if (strpos($style, 'font-weight:') !== false) {
                if (array_search('font-style-bold: 1', $arr_text_option_style['styles'])) {
                    continue;
                }
            }

            if (strpos($style, 'font-style:normal') !== false) {
                if (array_search('font-style-italic: 1', $arr_text_option_style['styles'])) {
                    continue;
                }
            }

            // font style
            if (strpos($style, 'font-style-italic') !== false) {
                $text_option_style .= 'font-style: italic';
                $text_option_style .= ';';
                $text_option_style_icon .= 'font-style: italic';
                $text_option_style_icon .= ';';
                continue;
            }

            // font style bold
            if (strpos($style, 'font-style-bold') !== false) {
                $text_option_style .= 'font-weight: bold';
                $text_option_style .= ';';

                $text_option_style_icon .= 'font-weight: bold';
                $text_option_style_icon .= ';';
                continue;
            }
            $text_option_style .= $style;
            $text_option_style .= ' ;';
            $text_option_style_icon .= $style;
            $text_option_style_icon .= ';';
        }               

        foreach ($arr_submenu_text_option_style['styles'] as $style) {
            if (strpos($style, 'color:') !== false) {
                $submenu_text_color = explode(':', $style);
                $submenu_text_color = end($submenu_text_color);
            }

            if (strpos($style, 'font-weight:') !== false) {
                if (array_search('font-style-bold: 1', $arr_submenu_text_option_style['styles'])) {
                    continue;
                }
            }

            if (strpos($style, 'font-style:normal') !== false) {
                if (array_search('font-style-italic: 1', $arr_submenu_text_option_style['styles'])) {
                    continue;
                }
            }

            // font style
            if (strpos($style, 'font-style-italic') !== false) {
                $submenu_text_option_style .= 'font-style: italic';
                $submenu_text_option_style .= ';';

                continue;
            }

            // font style bold
            if (strpos($style, 'font-style-bold') !== false) {
                $submenu_text_option_style .= 'font-weight: bold';
                $submenu_text_option_style .= ';';

                continue;
            }

            $submenu_text_option_style .= $style;
            $submenu_text_option_style .= ' ;';
        }

        $text_option_style .= '"';
        $primary_color = get_theme_mod( 'udetor_color_primary', '' );
        ?>
        <script>
                (function ($) {
                    $(document).ready(function () {                        
                        <?php if(isset($color_hover_default) && $color_hover_default == "yes" && $primary_color !=''){ ?>
                            var mega_submenu_hover_text_color = "<?php echo $primary_color;?>";
                        <?php }else{ ?>
                            var mega_submenu_hover_text_color = "<?php echo $submenu_hover_text_color;?>";
                        <?php } ?>

                        var mega_submenu_text_color = "<?php echo $submenu_text_color;?>";
                        <?php if($set_df_header_color  && $df_header_color !=''){ ?>
                            var mega_menu_text_color = "<?php echo $df_header_color;?>";

                        <?php }else{ ?>
                            var mega_menu_text_color = "<?php echo $menu_text_color;?>";
                        <?php } ?>
                        <?php if(isset($color_hover_default) && $color_hover_default == "yes" && $primary_color !=''){ ?>
                            var mega_menu_hover_text_color = "<?php echo $primary_color;?>";
                        <?php }else{ ?>
                            var mega_menu_hover_text_color = "<?php echo $hover_text_color;?>";
                        <?php } ?>
                        
                        var submenu_mega_background_color = "<?php echo $submenu_mega_background_color;?>";
                        var mega_text_option_style = "<?php echo $text_option_style_icon;?>";

                        var mega_submenu_text_option_style = "<?php echo $submenu_text_option_style;?>";
                        var mega_item_spacing = "<?php echo $menu_item_spacing;?>";
                        var mega_item_padding = 0;
                        if (mega_item_spacing) {
                            mega_item_padding = parseFloat(mega_item_padding) / 2;
                        }
                        var mega_letter_spacing = "<?php echo $letter_spacing;?>";
                        var mega_submenu_letter_spacing = "<?php echo $submenu_letter_spacing;?>";
                        var mega_submenu_possition = "<?php echo $submenu_possition;?>";
                        var mega_max_width_layout_designer = "<?php echo $max_width_layout_designer;?>";
                        var full_screen_layout_designer = "<?php echo $full_screen_layout_designer;?>";
                        var box_shadow_submenu = "<?php echo $box_shadow_submenu;?>";
                        var id = "<?php echo $id; ?>";                    

                        var idmenu = '#' + id + ' .site-navigator > li > a'            ;

                        $('.edu-element-hmenu-mega .site-navigator > .udetor-menu-layout-builder > .sub-menu .menu li a').hover(function () {
                            $(this).css('color', mega_submenu_hover_text_color);
                        },function () {
                            $(this).css('color', mega_submenu_text_color);
                        });
                        
                        $(idmenu).css('color', mega_menu_text_color);

                        $(idmenu).hover(function () {
                            /*enable full screen*/
                            if (full_screen_layout_designer) {
                                var offset = $(this).offset().left;
                                $('.edu-element-hmenu-mega').addClass('fs-layout-designer');
                                $('.edu-element-hmenu-mega .site-navigator .udetor-menu-layout-builder > .sub-menu').css({
                                    'min-width' : $(document).width() + 'px',
                                    'left' : '-' + offset + 'px',
                                    'right': 'auto',
                                });
                            }
                            /*enable box-shadow*/
                            if (box_shadow_submenu) {
                                $('.edu-element-hmenu-mega').addClass('shadow-layout-designer');
                            }
                            
                            $(this).css('color', mega_menu_hover_text_color);

                            $(this).parent().find('.sub-menu').hover(function () {
                                $(this).parents('.edu-menu-item').find(' > a').css('color', mega_menu_hover_text_color);
                            }, function () {
                                $(this).parents('.edu-menu-item').find(' > a').css('color', mega_menu_text_color);
                            });

                        }, function () {

                            $(this).css('color', mega_menu_text_color);
                        });
                        $('.edu-element-hmenu-mega .site-navigator .edu-menu-item-link').attr('style', mega_text_option_style);

                        /*sub menu*/
                        $('.edu-element-hmenu-mega .site-navigator .edu-sub-menu-item > a').css('color', mega_submenu_text_color);
                        $('.edu-element-hmenu-mega .site-navigator .mega-sub-menu li > a').css('color', mega_submenu_text_color);

                        $('.edu-element-hmenu-mega .site-navigator .edu-sub-menu-item > a').hover(function () {
                            $(this).css('color', mega_submenu_hover_text_color);
                        }, function () {
                            $(this).css('color', mega_submenu_text_color);
                        });
                        $('.edu-element-hmenu-mega .site-navigator .sub-menu').css('background', submenu_mega_background_color);
                        $('.edu-element-hmenu-mega .site-navigator .sub-menu .edu-sub-menu-item-link').attr('style', mega_submenu_text_option_style);
                        
                        $('.edu-element-hmenu-mega .site-navigator .edu-menu-item').css({
                            'padding-left' : mega_item_padding + 'px',
                            'padding-right' : mega_item_padding + 'px'
                        });
                        
                        $('.edu-element-hmenu-mega .site-navigator .edu-menu-item-link').css({
                            'letter-spacing': mega_letter_spacing + 'px'
                        });
                        $('.edu-element-hmenu-mega .site-navigator .edu-sub-menu-item-link').css({
                            'letter-spacing': mega_submenu_letter_spacing + 'px'
                        });

                        /*submenu position*/
                        if (mega_submenu_possition == 'left') {
                            $('.edu-element-hmenu-mega').addClass('position-left');
                        }
                        if (mega_submenu_possition == 'center') {
                            $('.edu-element-hmenu-mega').addClass('position-center');
                        }

                        if (mega_submenu_possition == 'right') {
                            $('.edu-element-hmenu-mega').addClass('position-right');
                        }
                        /*max-width layout desinger*/
                        $('.edu-element-hmenu-mega .site-navigator .udetor-menu-layout-builder .sub-menu').css({
                            'max-width': mega_max_width_layout_designer + 'px'
                        });
                    });

                })(jQuery);
            </script>
        <?php
        // nav-menu
        $edu_args = array(
            'menu'        => $nav_menu,
            'menu_class'  => 'site-navigator',
            'container'   => false,
            'fallback_cb' => '',
            'allow_hb'    => true,
            'echo'        => false,

        );

        // Generate HTML code.
            $html .= '<div class="udetor-mega-menu '.esc_attr( implode( ' ', $extraclass ) ) .'">';

                $html .= '<div style="'.$pclasses['style-p'].'" id="' . esc_attr( $id ) . '" class="edu-element edu-element-hmenu-mega '.$arr_text_option_style['css_class'].'">';

                    $html .= '<nav role="navigation" class="width-navigation table-cell table-right">';
                        // custom walker nav menu
                        $html .= html_entity_decode(wp_nav_menu($edu_args));
                    $html .= '</nav>';
                    if ($show_icon_cart_is_mobile == 'yes' && class_exists( 'WooCommerce' )  ) {
                        $html .= '<div class="udetor-cart-mobile"><a class="cart-contents" href="'.esc_url( wc_get_cart_url() ).'">';
                        $html .= '<span class="count">'.WC()->cart->get_cart_contents_count().'</span>';
                        $html .= '</a></div>';
                    }
                    $html .= '<div class="menu-mobile-effect navbar-toggle" data-effect="mobile-effect">';
                        $html .= '<span class="icon-bar icon-bar-top"></span>';
                        $html .= '<span class="icon-bar icon-bar-middle"></span>';
                        $html .= '<span class="icon-bar icon-bar-botton"></span>';
                    $html .= '</div>';

                $html .= '</div>';

                $html .= '<div class="edu-mega-mobile-menu">';
                    $html .= '<nav class="mega-mobile-menu-container">';
                        $html .= html_entity_decode(wp_nav_menu($edu_args));
                        $html .= '<div class="close-menu"><i class="fa fa-times" aria-hidden="true"></i></div>';                        
                       
                    $html .= '</nav>';

                    $html .= '<div class="mobile-overlay-menu"></div>';
                $html .= '</div>';

            $html .= '</div>';       

        wp_reset_postdata();

        return apply_filters( 'netbase_shortcode_hmenu', force_balance_tags( $html ) );
    }


    /**
     * Enqueue scripts and styles.
     *
     * @return  void
     */
    public static function enqueue_scripts() {
        // font awesome
        wp_enqueue_style('font-awesome');
    }


    /**
     * Parses google_fonts_data and font_container_data to get needed css styles to markup
     *
     * @param $el_class
     * @param $css
     * @param $google_fonts_data
     * @param $font_container_data
     * @param $atts
     *
     * @since 4.3
     * @return array
     */
    public static function getStyles( $css, $google_fonts_data, $font_container_data, $atts ) {
        $styles = array();
        if ( ! empty( $font_container_data ) && isset( $font_container_data['values'] ) ) {
            foreach ( $font_container_data['values'] as $key => $value ) {
                if ( 'tag' !== $key && strlen( $value ) ) {
                    if ( preg_match( '/description/', $key ) ) {
                        continue;
                    }
                    if ( 'font_size' === $key || 'line_height' === $key ) {
                        $value = preg_replace( '/\s+/', '', $value );
                    }
                    if ( 'font_size' === $key ) {
                        $pattern = '/^(\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';
                        // allowed metrics: http://www.w3schools.com/cssref/css_units.asp
                        $regexr = preg_match( $pattern, $value, $matches );
                        $value = isset( $matches[1] ) ? (float) $matches[1] : (float) $value;
                        $unit = isset( $matches[2] ) ? $matches[2] : 'px';
                        $value = $value . $unit;
                    }
                    if ( strlen( $value ) > 0 ) {
                        $styles[] = str_replace( '_', '-', $key ) . ': ' . $value;
                    }
                }
            }
        }
        if ( ( ! isset( $atts['use_theme_fonts'] ) || 'yes' !== $atts['use_theme_fonts'] ) && ! empty( $google_fonts_data ) && isset( $google_fonts_data['values'], $google_fonts_data['values']['font_family'], $google_fonts_data['values']['font_style'] ) ) {
            $google_fonts_family = explode( ':', $google_fonts_data['values']['font_family'] );
            $styles[] = 'font-family:' . $google_fonts_family[0];
            $google_fonts_styles = explode( ':', $google_fonts_data['values']['font_style'] );
            if (isset($google_fonts_styles[1])) {
                $styles[] = 'font-weight:' . $google_fonts_styles[1];
            }
            if (isset($google_fonts_styles[2])) {
                $styles[] = 'font-style:' . $google_fonts_styles[2];
            }
        }

        /**
         * Filter 'VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG' to change vc_custom_heading class
         *
         * @param string - filter_name
         * @param string - element_class
         * @param string - shortcode_name
         * @param array - shortcode_attributes
         *
         * @since 4.3
         */
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ));
        }
        return array(
            'css_class' => trim( preg_replace( '/\s+/', ' ', $css_class ) ),
            'styles' => $styles,
        );
    }

}