<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

class Netbase_Toolkit_Element_HLogo {
	/**
	 * Initialize.
	 *
	 * @return  void
	 */
	public static function initialize() {
		// Add map for vc
		if ( class_exists( 'Vc_Manager' ) ) {
			add_action( 'init', array( __CLASS__, 'map' ) );
		}
		// Add shortcode
		add_shortcode( 'netbase_hlogo', array( __CLASS__, 'shortcode_hlogo' ) );

	}
	
	public static function map() {
		$order_by_values = array(
			'',
			__( 'Date', 'udetor' )          => 'date',
			__( 'ID', 'udetor' )            => 'ID',
			__( 'Author', 'udetor' )        => 'author',
			__( 'Title', 'udetor' )         => 'title',
			__( 'Modified', 'udetor' )      => 'modified',
			__( 'Random', 'udetor' )        => 'rand',
			__( 'Comment count', 'udetor' ) => 'comment_count',
			__( 'Menu order', 'udetor' )    => 'menu_order',
		);
		$order_way_values = array(
			'',
			__( 'Descending', 'udetor' ) => 'DESC',
			__( 'Ascending', 'udetor' )  => 'ASC',
		);

		// Get all terms of toolkit
		$hlogo_cat = array(
			__( 'All', 'udetor' ) => '',
		);
		$terms = get_terms( 'hlogo_cat' );
		if ( $terms && ! isset( $terms->errors ) ) {
			foreach ( $terms as $key => $value ) {
				$hlogo_cat[$value->name] = $value->term_id;
			}
		}

		// Map new Toolkit element.
		vc_map(
			array(
				'name'     => __( 'Logo', 'udetor' ),
				'base'     => 'netbase_hlogo',
//				'icon'     => 'fa fa-picture-o',
				'category' => __( 'Udetor Elements', 'udetor' ),
				'params'   => array(
					array(
						'heading'     => __( 'Logo type', 'udetor' ),
						'param_name'  => 'logo_type',
						'type'        => 'dropdown',
                        'std'         => 'image',
						'value'       => array(
                            __( 'Text', 'udetor' )     => 'text',
                            __( 'Image', 'udetor' )    => 'image',
                            __( 'Logo Default Setting', 'udetor' ) => 'default',
                        ),
						'admin_label' => true,
					),
                    array(
                        'heading'     => __( 'Regular logo', 'udetor' ),
                        'param_name'  => 'regular_logo',
                        'type'        => 'attach_image',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency'  => array(
                            'element' => 'logo_type',
                            'value'   => 'image'
                        ),
                    ),
                    array(
                        'heading'     => __( 'Retina logo', 'udetor' ),
                        'param_name'  => 'retina_logo',
                        'type'        => 'attach_image',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                        'dependency'  => array(
                            'element' => 'logo_type',
                            'value'   => 'image'
                        ),
                    ),
                    array(
                        'heading'     => __( 'Width', 'udetor' ),
                        'param_name'  => 'logo_width',
                        'type'        => 'textfield',
                        'std'         => '138',
                        'admin_label' => true,
                        'dependency'  => array(
                            'element' => 'logo_type',
                            'value_not_equal_to'   => 'text'
                        ),
                    ),
                    array(
                        'heading'     => __( 'Logo content', 'udetor' ),
                        'param_name'  => 'logo_content',
                        'type'        => 'textfield',
                        'std'         => 'Logo',
                        'admin_label' => true,
                        'dependency'  => array(
                            'element' => 'logo_type',
                            'value'   => 'text'
                        ),
                    ),
                    array(
                        'type' => 'vc_link',
                        'heading' => __( 'URL (Link)', 'udetor' ),
                        'param_name' => 'link',
                        'description' => __( 'Add link to custom heading.', 'udetor' ),
                        // compatible with btn2 and converted from href{btn1}
                    ),
                    array(
                        'type' => 'font_container',
                        'param_name' => 'font_container',
                        'value' => 'tag:h2|text_align:left',
                        'settings' => array(
                            'fields' => array(
                                'tag' => 'h2', // default value h2
                                'text_align',
                                'font_size' => '20',
                                'line_height' => '1',
                                'color' => '#000000',
                                'tag_description' => __( 'Select element tag.', 'udetor' ),
                                'text_align_description' => __( 'Select text alignment.', 'udetor' ),
                                'font_size_description' => __( 'Enter font size.', 'udetor' ),
                                'line_height_description' => __( 'Enter line height.', 'udetor' ),
                                'color_description' => __( 'Select heading color.', 'udetor' ),
                            ),
                        ),
                        'dependency' => array(
                            'element' => 'logo_type',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'type' => 'checkbox',
                        'heading' => __( 'Use theme default font family?', 'udetor' ),
                        'param_name' => 'use_theme_fonts',
                        'value' => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'Use font family from the theme.', 'udetor' ),
                        'dependency' => array(
                            'element' => 'logo_type',
                            'value'   => 'text',
                        ),
                    ),
                    array(
                        'type' => 'google_fonts',
                        'param_name' => 'google_fonts',
                        'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
                        'settings' => array(
                            'fields' => array(
                                'font_family_description' => __( 'Select font family.', 'udetor' ),
                                'font_style_description' => __( 'Select font styling.', 'udetor' ),
                            ),
                        ),
                        'dependency' => array(
                            'element' => 'use_theme_fonts',
                            'value_not_equal_to' => 'yes',
                        ),
                    ),
                    array(
                        'param_name' => 'letter_spacing',
                        'heading'    => __( 'Letter Spacing', 'udetor' ),
                        'type'       => 'textfield',
                        'value'      => 0,
                        'dependency' => array(
                            'element' => 'logo_type',
                            'value'   => 'text',
                        ),
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'param_name' => 'enable_center',
                        'heading'    => __( 'Enable center element', 'udetor' ),
                        'type'       => 'checkbox',
                        'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                        'description' => __( 'If enabled then Center Element Setting of element More on the same row will be disabled', 'udetor' ),
                    ),
                    array(
                        'heading'     => __( 'Position', 'udetor' ),
                        'param_name'  => 'icon_box_position',
                        'type'        => 'dropdown',
                        'std'         => 'left',
                        'value'       => array(
                            __( 'Left', 'udetor' )     => 'left',
                            __( 'Center', 'udetor' )     => 'center',
                            __( 'Right', 'udetor' )    => 'right',
                        ),
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),

					array(
                        'heading'    => __( 'Extra class name', 'udetor' ),
						'param_name' => 'extra_class',
						'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
					),
                    array(
                        'heading'    => __( 'Custom id name', 'udetor' ),
                        'param_name' => 'custom_id',
                        'type'       => 'textfield',
                        'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    ),
                    array(
                        'type' => 'css_editor',
                        'heading' => __( 'Css', 'udetor' ),
                        'param_name' => 'css',
                        'group' => __( 'Design options', 'udetor' ),
                    )
				)
			)
		);
	}

	/**
	 * Add shortcode toolkit.
	 *
	 * @since  1.0
	 */
	public static function shortcode_hlogo( $atts, $content = null ) {
        $html = $attr_parent = $google_fonts = $font_container = $font_container_data = $css = $text = $google_fonts_data = '';

		// Extract shortcode parameters.
		extract(
			shortcode_atts(
				array(
					'logo_type'             => 'image',
                    'font_container'        => '',
					'regular_logo'          => '',
					'link'                  => '',
					'retina_logo'           => '',
					'logo_width'            => '138',
					'logo_content'          => 'Logo',
					'color'                 => '#000000',
					'font_size'             => '20',
					'font_weight'           => '400',
					'font_style'            => 'normal',
					'line_height'           => '20',
					'letter_spacing'        => '0',
					'enable_center'         => 'no',
					'extra_class'           => '',
					'custom_id'             => '',
                    'use_theme_fonts'       => '',
					'google_fonts'          =>'',
					'css'                   => '',
                    'icon_box_position'     => 'left',
				),
				$atts
			)
		);

		// Generate custom ID
		$id = uniqid( 'netbase_custom_css_' );

		// custom id
        if ($custom_id !== '') {
            $id = $custom_id;
        }

        // position
        $pclasses['style-p'] = '';
        switch ($icon_box_position) {
            case 'left':
                $pclasses['style-p'] .= 'float:left;';
                break;
            case 'right':
                $pclasses['style-p'] .= 'float:right;';
                break;
            case 'center':
                $pclasses['style-p'] .= 'width:100%;text-align:center;';
                break;
        }


        $classes = [];
        // extra class
        if ($extra_class !== '') {
            $classes[] = $extra_class;
        }

        // enable center
        if ($enable_center == 'yes') {
            $classes[] = 'edu-element-center';
            $classes[] = 'align-self-stretch';
        }

        $default_logo = get_theme_mod( 'udetor_header_default_logo', '' );
        $swidth ='';
        if($logo_width !=''){
            $swidth= 'width="'.$logo_width.'"';
        }

        $classes[] = $logo_type . '-type';
        $font_container_field = array();
        if (  class_exists( 'WPBMap' ) ) {  
            $font_container_field = WPBMap::getParam('netbase_hlogo', 'font_container');
        }
        $font_container_obj = '';
        if ( class_exists( 'Vc_Font_Container' ) ) {
            $font_container_obj = new Vc_Font_Container();
        }
        $font_container_field_settings = isset( $font_container_field['settings'], $font_container_field['settings']['fields'] ) ? $font_container_field['settings']['fields'] : array();
        $font_container_data = '';
        if($font_container_obj !='' ){
            $font_container_data = $font_container_obj->_vc_font_container_parse_attributes($font_container_field_settings, $font_container);
        }
        

        if ($use_theme_fonts !== 'yes') {   
            $google_fonts_field = array();  
            if (  class_exists( 'WPBMap' ) ) {       
                $google_fonts_field = WPBMap::getParam('netbase_hlogo','google_fonts');
            }
            $google_fonts_obj = '';
            if (  class_exists( 'Vc_Google_Fonts' ) ) {  
                $google_fonts_obj = new Vc_Google_Fonts();
            }
            $google_fonts_field_settings = isset( $google_fonts_field['settings'], $google_fonts_field['settings']['fields'] ) ? $google_fonts_field['settings']['fields'] : array();

            $google_fonts_data = '';
            if($google_fonts_obj != ''){
                $google_fonts_data = $google_fonts_obj->_vc_google_fonts_parse_attributes($google_fonts_field_settings, $google_fonts);
            }
            
        }

        // add link to custom heading
        $link_redirect = get_home_url();
        $arr_link = [];

        if ($link !== '|||' && $link !== '') {
            $arr_link = vc_build_link($link);
            if (!empty($arr_link['url'])) {
                $link_redirect = $arr_link['url'];
            }
        }

        // get style css for tag
        $arr_style = self::getStyles($css, $google_fonts_data, $font_container_data, $atts);
        $style_tag = 'style="';
        foreach ($arr_style['styles'] as $value) {
            $style_tag .= $value . ' !important;';
            $style_tag .= ' ';
        }
        $style_tag .= 'letter-spacing: ' . $letter_spacing . 'px !important;';
        $style_tag .= ' margin: 0px !important;"';

        // Generate HTML code.
        $html .= '<div style="'.$pclasses['style-p'].'" id="' . esc_attr($id) . '" class="' . $arr_style['css_class'] . ' edu-element edu-element-hlogo';
        foreach ($classes as $class) {
            $html .= ' ';
            $html .= $class;
        }
        $html .= '">';

            $html .= '<div class="content-hlogo">';
                $html .= '<a href="'.$link_redirect.'"';
                if (!empty($arr_link)) {
                    if (!empty($arr_link['target'])) {
                        $html .= 'target="blank"';
                        $html .= ' ';
                    }
                    if (!empty($arr_link['rel'])) {
                        $html .= 'rel="' . $arr_link['rel'] . '"';
                    }
                }
                $html .= '>';

                    if ($logo_type == 'text') {
                        $html .= '<' . $font_container_data['values']['tag'] . ' ' . $style_tag;
                        $html .= '>';
                            $html .= $logo_content;
                        $html .= '</' . $font_container_data['values']['tag'] . '>';
                    }
                    elseif($logo_type == 'default' && $default_logo){
                        $html .= '<img '.$swidth.' src="'.esc_url( $default_logo ).'" class="image-hlogo regular-hlogo" alt="'. esc_attr( get_bloginfo('description') ).'">';      
                        $html .= '<img '.$swidth.' src="'.esc_url( $default_logo ).'" class="image-hlogo retina-hlogo" alt="'. esc_attr( get_bloginfo('description') ).'">';                        
                    }
                    else{
                        if ($regular_logo !== '' || $retina_logo !== '') {
                            if($regular_logo !== ''){
                                $src_regular = wp_get_attachment_image_src((int) $regular_logo, 'full', false);
                                $html .= '<img '.$swidth.' class="image-hlogo regular-hlogo" src="' . $src_regular[0] . '" alt="'. esc_attr( get_bloginfo('name') ).'">';
                            }
                            if($retina_logo !== ''){
                                $src_retina = wp_get_attachment_image_src((int) $retina_logo, 'full', false);                            
                                $html .= '<img alt="'. esc_attr( get_bloginfo('name') ).'" '.$swidth.' class="image-hlogo retina-hlogo" src="' . $src_retina[0] . '">';
                            }elseif($regular_logo !== ''){
                                $src_regular1 = wp_get_attachment_image_src((int) $regular_logo, 'full', false);
                                $html .= '<img '.$swidth.' class="image-hlogo retina-hlogo" src="' . $src_regular1[0] . '" alt="'. esc_attr( get_bloginfo('name') ).'">';
                            }
                        }
                        elseif($regular_logo == '' && $retina_logo == '') {
                            $html .= '<img alt="'. esc_attr( get_bloginfo('description') ).'" '.$swidth.' class="image-hlogo" src="' . NETBASE_TOOLKIT_URL . 'assets/images/no-thumbnail.jpg">';
                        }

                    }
                $html .= '</a>';
            $html .= '</div>';

		$html .= '</div>';

		wp_reset_postdata();

		return apply_filters( 'netbase_shortcode_hlogo', force_balance_tags( $html ) );
	}
	

    /**
     * Parses google_fonts_data and font_container_data to get needed css styles to markup
     *
     * @param $el_class
     * @param $css
     * @param $google_fonts_data
     * @param $font_container_data
     * @param $atts
     *
     * @since 4.3
     * @return array
     */
    public static function getStyles( $css, $google_fonts_data, $font_container_data, $atts ) {
        $styles = array();
        if ( ! empty( $font_container_data ) && isset( $font_container_data['values'] ) ) {
            foreach ( $font_container_data['values'] as $key => $value ) {
                if ( 'tag' !== $key && strlen( $value ) ) {
                    if ( preg_match( '/description/', $key ) ) {
                        continue;
                    }
                    if ( 'font_size' === $key || 'line_height' === $key ) {
                        $value = preg_replace( '/\s+/', '', $value );
                    }
                    if ( 'font_size' === $key ) {
                        $pattern = '/^(\d*(?:\.\d+)?)\s*(px|\%|in|cm|mm|em|rem|ex|pt|pc|vw|vh|vmin|vmax)?$/';
                        // allowed metrics: http://www.w3schools.com/cssref/css_units.asp
                        $regexr = preg_match( $pattern, $value, $matches );
                        $value = isset( $matches[1] ) ? (float) $matches[1] : (float) $value;
                        $unit = isset( $matches[2] ) ? $matches[2] : 'px';
                        $value = $value . $unit;
                    }
                    if ( strlen( $value ) > 0 ) {
                        $styles[] = str_replace( '_', '-', $key ) . ': ' . $value;
                    }
                }
            }
        }
        if ( ( ! isset( $atts['use_theme_fonts'] ) || 'yes' !== $atts['use_theme_fonts'] ) && ! empty( $google_fonts_data ) && isset( $google_fonts_data['values'], $google_fonts_data['values']['font_family'], $google_fonts_data['values']['font_style'] ) ) {
            $google_fonts_family = explode( ':', $google_fonts_data['values']['font_family'] );
            $styles[] = 'font-family:' . $google_fonts_family[0];
            $google_fonts_styles = explode( ':', $google_fonts_data['values']['font_style'] );
            if (isset($google_fonts_styles[1])) {
                $styles[] = 'font-weight:' . $google_fonts_styles[1];
            }
            if (isset($google_fonts_styles[2])) {
                $styles[] = 'font-style:' . $google_fonts_styles[2];
            }
        }

        /**
         * Filter 'VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG' to change vc_custom_heading class
         *
         * @param string - filter_name
         * @param string - element_class
         * @param string - shortcode_name
         * @param array - shortcode_attributes
         *
         * @since 4.3
         */
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ));
        }   

        return array(
            'css_class' => trim( preg_replace( '/\s+/', ' ', $css_class ) ),
            'styles' => $styles,
        );
    }
}
