<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Heading
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_heading', array(__CLASS__, 'shortcode_heading'));

    }
    
    public static function map()
    {
        vc_map( array(
            'name'        => esc_html__( 'Udetor Heading', 'udetor' ),
            'base'        => 'netbase_heading',
            'category'    => esc_html__( 'Udetor Elements', 'udetor' ),
            'description' => esc_html__( 'Display heading.', 'udetor' ),
            'params'      => array(
                //Title
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading', 'udetor' ),
                    'param_name'  => 'title',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'Write the title for the heading.', 'udetor' )
                ),

                array(
                    'heading'    => __( 'Text Heading Color Primary', 'udetor' ),
                    'param_name' => 'title_e1',
                    'type'       => 'textfield',
                    'description'=> '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Text Heading After', 'udetor' ),
                    'param_name' => 'title_e2',
                    'type'       => 'textfield',
                    'description'=> '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                
                array(
                    'type'        => 'colorpicker',                    
                    'heading'     => esc_html__( 'Heading color ', 'udetor' ),
                    'param_name'  => 'textcolor',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'Select the title color.', 'udetor' ),
                    'group' => esc_html__( 'Heading Settings', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column', 
                ),

                array(
                    'type'        => 'textfield',                    
                    'heading'     => esc_html__( 'Heading margin bottom', 'udetor' ),
                    'param_name'  => 'heading_margin_bottom',
                    'min'         => 0,
                    'value'       => '',
                    'suffix'      => 'px',
                    'description' => esc_html__( 'Custom heading margin bottom px.', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column', 
                    'group' => esc_html__( 'Heading Settings', 'udetor' ),
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading tag', 'udetor' ),
                    'param_name'  => 'heading_size',
                    'std' =>'h4',
                    'value'       => array(
                        'h2' => 'h2',
                        'h3' => 'h3',
                        'h4' => 'h4',
                        'h5' => 'h5',
                        'h6' => 'h6',
                    ),
                    'description' => esc_html__( 'Choose heading element.', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'udetor' ),
                ),

                //Use custom or default title?
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Use custom or default title?', 'udetor' ),
                    'param_name'  => 'title_custom',
                    'value'       => array(
                        __( 'Default', 'udetor' ) => '',
                        __( 'Custom', 'udetor' )  => 'custom',
                    ),
                    'description' => esc_html__( 'If you select default you will use default title which customized in typography.', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'udetor' ),
                ),

                array(
                    'type'        => 'textfield',                    
                    'heading'     => esc_html__( 'Font size ', 'udetor' ),
                    'param_name'  => 'font_size',
                    'min'         => 0,
                    'value'       => '',
                    'suffix'      => 'px',
                    'description' => esc_html__( 'Custom title font size px.', 'udetor' ),
                    'std'         => '14',
                    'dependency'  => array(
                        'element' => 'title_custom',
                        'value'   => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'udetor' ),
                ),
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Font Weight ', 'udetor' ),
                    'param_name'  => 'font_weight',
                    'value'       => array(
                        __( 'Custom font weight', 'udetor' ) => '',
                        __( 'Normal', 'udetor' )             => 'normal',
                        __( 'Bold', 'udetor' )               => 'bold',
                        __( '100', 'udetor' )                => '100',
                        __( '200', 'udetor' )                => '200',
                        __( '300', 'udetor' )                => '300',
                        __( '400', 'udetor' )                => '400',
                        __( '500', 'udetor' )                => '500',
                        __( '600', 'udetor' )                => '600',
                        __( '700', 'udetor' )                => '700',
                        __( '800', 'udetor' )                => '800',
                        __( '900', 'udetor' )                => '900',
                    ),
                    'description' => esc_html__( 'Custom title font weight.', 'udetor' ),
                    'dependency'  => array(
                        'element' => 'title_custom',
                        'value'   => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'udetor' ),
                ),

                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Font style ', 'udetor' ),
                    'param_name'  => 'font_style',
                    'value'       => array(
                        __( 'Choose the title font style', 'udetor' ) => '',
                        __( 'Italic', 'udetor' )                      => 'italic',
                        __( 'Oblique', 'udetor' )                     => 'oblique',
                        __( 'Initial', 'udetor' )                     => 'initial',
                        __( 'Inherit', 'udetor' )                     => 'inherit',
                        __( 'Normal', 'udetor' )                      => 'normal',
                    ),
                    'description' => esc_html__( 'Custom title font style.', 'udetor' ),
                    'dependency'  => array(
                        'element' => 'title_custom',
                        'value'   => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'udetor' ),
                ),
                
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Sub heading', 'udetor' ),
                    'param_name'  => 'sub_heading',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'Enter sub heading.', 'udetor' ),
                ),
                
                array(
                    'type'        => 'colorpicker',                    
                    'heading'     => esc_html__( 'Sub heading color ', 'udetor' ),
                    'param_name'  => 'sub_heading_color',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'Select the sub heading color.', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column', 
                ),

                array(
                    'type'        => 'textfield',                    
                    'heading'     => esc_html__( 'Sub heading margin bottom', 'udetor' ),
                    'param_name'  => 'sub_heading_margin',
                    'min'         => 0,
                    'value'       => '',
                    'suffix'      => 'px',
                    'description' => esc_html__( 'Custom Sub heading margin bottom px.', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column', 
                ),

                //Show separator?
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Show Separator?', 'udetor' ),
                    'param_name'  => 'separator',
                    'value'       => array(
                            __( 'None', 'udetor' )     => 'none',
                            __( 'Short Line', 'udetor' )    => 'line',
                            __( 'Image', 'udetor' )    => 'image',
                        ),
                    
                    'description' => esc_html__( 'Tick it to show the separator between title and description.', 'udetor' ), 
                ),

                array(
                        'heading'     => __( 'Image Separator', 'udetor' ),
                        'param_name'  => 'separator_img',
                        'type'        => 'attach_image',                        
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                        
                        'dependency'  => array(
                            'element' => 'separator',
                            'value'   => 'image'
                        ),
                    ),                
                
                array(
                    'type'        => 'colorpicker',
                    'heading'     => esc_html__( 'Separator color', 'udetor' ),
                    'param_name'  => 'separator_line_color',
                    'value'       => esc_html__( '', 'udetor' ),
                    'description' => esc_html__( 'Choose the separator color.', 'udetor' ),
                    'dependency'  => array(
                        'element' => 'separator',
                        'value'   => 'line',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column', 
                ),

                array(
                    'type'        => 'dropdown',                     
                    'std' => '1',                
                    'heading'     => esc_html__( 'Separator line height', 'udetor' ),
                    'param_name'  => 'separator_line_height',
                    'value'       => array(
                            __( '1px', 'udetor' )   => '1',
                            __( '2px', 'udetor' )   => '2',
                            __( '3px', 'udetor' )   => '3',
                            __( '4px', 'udetor' )   => '4',
                            __( '5px', 'udetor' )   => '5',                            
                        ),
                    'dependency'  => array(
                        'element' => 'separator',
                        'value'   => 'line',
                    ),
                    
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                    
                ),

                array(
                    'type'        => 'dropdown',                       
                    'std' => '10',                
                    'heading'     => esc_html__( 'Separator line width', 'udetor' ),
                    'param_name'  => 'separator_line_width',
                    'value'       => array(
                            __( '10%', 'udetor' )   => '10',
                            __( '20%', 'udetor' )   => '20',
                            __( '30%', 'udetor' )   => '30',
                            __( '40%', 'udetor' )   => '40',
                            __( '50%', 'udetor' )   => '50',
                            __( '60%', 'udetor' )   => '60',
                            __( '70%', 'udetor' )   => '70',
                            __( '80%', 'udetor' )   => '80',
                            __( '90%', 'udetor' )   => '90',
                            __( '100%', 'udetor' )  => '100',                            
                        ),
                    'dependency'  => array(
                        'element' => 'separator',
                        'value'   => 'line',
                    ),
                    'description' => esc_html__( 'Separator line width.', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                    
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Position', 'udetor' ),
                    'param_name'  => 'separator_position',
                    'value'       => array(
                        __( 'Select Position', 'udetor' )     => '',
                        __( 'Top', 'udetor' )     => 'top',
                        __( 'Bottom', 'udetor' )    => 'bottom',                            
                    ),
                    "dependency" => Array('element' => "separator", 'value' => array('image','line')),
                    'description' => esc_html__( 'Position.', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                    
                ),
                
                //Alignment
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text alignment', 'udetor' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Text at left', 'udetor' )   => 'text-left',
                        __( 'Text at center', 'udetor' ) => 'text-center',
                        __( 'Text at right', 'udetor' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                ),
                //Animation
                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__( 'Animation', 'udetor' ),
                    'param_name'  => 'css_animation',                    
                    'value'       => array(
                        __( 'No', 'udetor' )                 => '',
                        __( 'Top to bottom', 'udetor' )      => 'top-to-bottom',
                        __( 'Bottom to top', 'udetor' )      => 'bottom-to-top',
                        __( 'Left to right', 'udetor' )      => 'left-to-right',
                        __( 'Right to left', 'udetor' )      => 'right-to-left',
                        __( 'Appear from center', 'udetor' ) => 'appear'
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'udetor' )
                ),

                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'editor_css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ) );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_heading($atts, $content = null)
    {
        $css_class = $html = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'             => '',
                    'title_e1' => '',
                    'title_e2' => '',
                    'heading_size'              => 'h4',
                    'textcolor'         => '',
                    'font_size'         => '',
                    'font_weight'       => '',
                    'font_style'        => '',
                    'title_custom'      => '',
                    'sub_heading'       => '',
                    'sub_heading_color' => '',
                    'line'              => '',
                    'bg_line'           => '',
                    'css_animation'     => '',
                    'text_align'        => '',
                    'separator' => 'none',
                    'separator_position' =>'bottom',
                    'separator_img' => '',
                    'separator_line_color' =>'#e1e1e1',
                    'separator_line_width' =>'10',
                    'separator_line_height' =>'1',
                    'editor_css' =>'',
                    'sub_heading_margin' =>'',
                    'heading_margin_bottom' =>'',
                    'extra_class'=>'',
                ),
                $atts
            )
        );
        $extraclass = array();
        if ($extra_class !== '') {
            $extraclass[] = $extra_class;
        }
        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $editor_css, ' ' ), 'netbase_heading', $atts );
        }
        $separator_line = $udetor_animation = $sub_heading_css = $html = $css = $line = $line_css = $hmb =  '';
        $udetor_animation .= Netbase_Toolkit_Element_Helper::udetor_getCSSAnimation( $css_animation );

        if(isset($heading_margin_bottom) && $heading_margin_bottom !=''){
            $hmb .= 'margin-bottom:' . $heading_margin_bottom . 'px;';
        }
        if($hmb){
            $hmb = ' style="' . $hmb . '"';
        }
        if ( $textcolor ) {
            $css .= 'color:' . $textcolor . ';';
        }       
        
        if ( $title_custom == 'custom' ) {
            if ( $font_size != '' ) {
                $css .= 'font-size:' . $font_size . 'px;';
            }
            if ( $font_weight != '' ) {
                $css .= 'font-weight:' . $font_weight . ';';
            }
            if ( $font_style != '' ) {
                $css .= 'font-style:' . $font_style . ';';
            }
        }        
        if ( $css ) {
            $css = ' style="' . $css . '"';
        }        

        if($sub_heading_color) {
            $sub_heading_css .= 'color:' . $sub_heading_color . ';';
        }
        
        if($sub_heading_margin !=''){
            $sub_heading_css .= 'margin-bottom:' . $sub_heading_margin . 'px;';
        }

        if($separator_line_height){
            $separator_line .='border-bottom-width:'.$separator_line_height.'px;';
        }

        if($separator_line_color){
            $separator_line .='border-color:' .$separator_line_color.';';
            //$udetorseparator_line_color = ' style="border-color:' .$separator_line_color.'"';
        }
        if ( $separator_line ) {
            $udetorseparator_line_color = ' style="' .$separator_line . '"';
        } 
        if($sub_heading !=''){
            $sub_heading = '<p class="sub-heading" style="'.$sub_heading_css.'">'.$sub_heading.'</p>';    
        }        
        
        if($line && $line <> ''){
            if ( $bg_line ) {
                $line_css = ' style="background-color:' . $bg_line . '"';
            }
            $line = '<span' . $line_css . ' class="line"></span>';
        }
        $src = wp_get_attachment_image_src($separator_img);       
       
        if($text_align && $text_align <> ''){
            $text_align = $text_align;
        }else{
             $text_align = '';
        }

        // Generate HTML code.
        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit heading '.esc_attr( $css_class ).' '.esc_attr( implode( ' ', $extraclass ) ) .'" '.$hmb.'>';
        $html .= '<div class="udetor_heading headline-container' . $udetor_animation . ' '.$text_align.'" >';
        if($separator=='image'){
            if($separator_position == 'top'){
                $html .= '<img src="' . esc_url( $src[0] ) . '" alt="Separator" />';
            }
        }
        elseif($separator=='line'){   
            if($separator_position == 'top'){         
                $html .='<div class="headline-separator vc_sep_width_'.$separator_line_width.'" '.$udetorseparator_line_color.'></div>';
            }
        }
        $html .= '<' . $heading_size . $css . ' class="title">' . $title ;
        if($title_e1){
            $html .='<span class="color-green"> '.$title_e1.'</span>';
        }
        if($title_e2){
            $html .=' '.$title_e2;
        }
        $html .='</' . $heading_size . '>';
        $html .= $sub_heading;
        $html .= $line;
        if($separator=='image'){
            if($separator_position == 'bottom'){
                $html .= '<img src="' . esc_url( $src[0] ) . '" alt="Separator" />';
            }
        }
        elseif($separator=='line'){   
            if($separator_position == 'bottom'){         
                $html .='<div class="headline-separator vc_sep_width_'.$separator_line_width.'" '.$udetorseparator_line_color.'></div>';
            }
        }
        $html .= '</div>';
        $html .= '</div>';
        // End HTML code.

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_heading', force_balance_tags($html));
    }
}