<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Custom_Nav
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_custom_nav', array(__CLASS__, 'shortcode_custom_nav'));        
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map()
    {
        $getname_menu = array();
        if ( 'vc_edit_form' === vc_post_param( 'action' ) && vc_verify_admin_nonce() ) {
            $allmenus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
            if ( is_array( $allmenus ) && ! empty( $allmenus ) ) {
                foreach ( $allmenus as $single_menu ) {
                    if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
                        $getname_menu[ $single_menu->name ] = $single_menu->slug;
                    }
                }
            }
        }

        vc_map(array(
            'name' => esc_html__('Udetor: Custom Navigation', 'udetor'),
            'base' => 'netbase_custom_nav',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display Custom Navigation.', 'udetor'),
            'icon' => 'udetor-widget-icon udetor-widget-icon-testimonials',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'udetor'),
                    'param_name' => 'title',
                    'value' => '',
                ),

                array(
                        'type' => 'dropdown',
                        'heading' => __( 'Choose menu', 'udetor' ),
                        'param_name' => 'nav_menu',
                        'value' => $getname_menu,
                        'description' => empty( $getname_menu ) ? __( 'Custom menus not found. Please visit <b>Appearance > Menus</b> page to create new menu.', 'udetor' ) : __( 'Select menu to display.', 'udetor' ),
                        'admin_label' => true,
                        'save_always' => true,
                ),
                
                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_custom_nav($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'     => '',
                    'nav_menu'  =>'',                    
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_testimonials_');

        $classes = $attr = array();

        // nav-menu
        $edu_args = array(
            'menu'        => $nav_menu,
            'menu_class'  => 'menu',
            'container'   => false,
            'fallback_cb' => '',
            'allow_hb'    => true,
            'echo'        => false,

        );
        
        
        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit custom-nav" >';
        $html .= '<div class="widget widget_nav_menu">';
            // custom walker nav menu
        $html .= html_entity_decode(wp_nav_menu($edu_args));
        $html .= '</div>';
        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_custom_nav', force_balance_tags($html));
    }

}
