<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Course_Category_Carousel
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }

        // Add shortcode
        add_shortcode('netbase_course_category_carousel', array(__CLASS__, 'shortcode_course_category_carousel'));
        
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map()
    {

        vc_map(array(
            'name' => esc_html__('Udetor: Course Category Carousel', 'udetor'),
            'base' => 'netbase_course_category_carousel',
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display course category.', 'udetor'),
            'icon' => 'udetor-widget-icon udetor-widget-icon-course-category',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'udetor'),
                    'param_name' => 'title',
                    'value' => '',
                ),               
               
                
                array(
                    'type' => 'colorpicker',
                    'admin_label' => true,
                    'heading' => esc_html__('Text Color', 'udetor'),
                    'param_name' => 'txt_color',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
               

                 array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'udetor'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),    

                array(
                        'param_name' => 'navigation',
                        'heading'    => esc_html__( 'Enable Navigation', 'udetor' ),
                        'type'       => 'checkbox',                                                
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                    ),
                    array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'udetor' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                    ),  
                array(
                        'param_name' => 'nav_position',
                        'heading'    => esc_html__( 'Navigation Position', 'udetor' ),
                        'type'       => 'dropdown',
                        'value'      => array(
                            __( 'Top', 'udetor' ) => 'top',
                            __( 'Center', 'udetor' ) => 'center',
                            __( 'Bottom', 'udetor' ) => 'bottom',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 mgt15',
                        'dependency' => array(
                            'element' => 'navigation',
                            'value'   => 'true',
                        ),
                    ),          

                array(
                        'param_name'  => 'columns',
                        'heading'     => esc_html__( 'Number of columns displayed', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'udetor' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'udetor' )  => '',
                            __( '1 column', 'udetor' )  => '1',
                            __( '2 columns', 'udetor' ) => '2',
                            __( '3 columns', 'udetor' ) => '3',
                            __( '4 columns', 'udetor' ) => '4',
                            __( '5 columns', 'udetor' ) => '5',
                            __( '6 columns', 'udetor' ) => '6',
                            __( '7 columns', 'udetor' ) => '7',
                            __( '8 columns', 'udetor' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),


                
                array(
                        'param_name'  => 'margin',
                        'heading'     => esc_html__( 'Margin Element', 'udetor' ),
                        'description' => esc_html__( 'Margin Element', 'udetor' ),
                        'type'        => 'textfield',
                        'value'       => 30,
                ),

                
                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_course_category_carousel($atts, $content = null)
    {
        $html = $attr_parent = $css= '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title' => '',
                    'layout' => 'default',
                    'columns' => '3',    
                    'columnstablet' =>'',                
                    'nav_position' => 'bottom',
                    'slider'       => true,
                    'pagination'   => '',
                    'navigation'   => '',
                    'txt_color' => '',
                    'margin'       => 30,
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_toolkit_coursecat_');

        $classes = $attr = array();

        if ( ! empty( $slider ) ) {

            if($margin){
                
                $attr[] = '"margin": "' . ( int ) $margin . '"';
            }
            
            if ( $navigation ) {
                $attr[] = '"nav": "true"';
            }
            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"ades": "' . ( int ) $columnstablet . '"';
            }

            
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }

            if ( $nav_position && $navigation) {
                $classes[] =' nav-'.$nav_position.' ';
            }

            $classes[] = 'udetor-carousel owl-carousel owl-loaded owl-drag';
        }
        if ( $txt_color != '') {
            $css .= 'color:' . $txt_color . ';';
        }
        if ( $css ) {
            $css = ' style="' . $css . '"';
        }

        $categories = get_terms( 'course_category' );

        if ( empty( $categories ) ) {
            return '';
        }
        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit course-cat" >';

        $html .='<ul class="'. esc_attr( implode( ' ', $classes ) ) .'" '.$data_owlcarousel.'>';
        foreach ( $categories as $category ) {

            
            $get_thumb_field = get_field('course_cat_thumb', $category );            
            
            $category_id = ! empty( $category->term_id ) ? $category->term_id : '';

            $html .= '<li>';
            if($get_thumb_field['url']){
                $html .= '<div class="vccat-thumb"><img src="'. esc_url( $get_thumb_field['url'] ) .'" alt="course category"></div>';
            }
            $html .= sprintf( '<a href="%s" %s>%s</a>',
                get_term_link( $category_id, 'course_category' ),
                $css,
                ! empty( $category->name ) ? $category->name : ''
            );

            $html .= '</li>';

            /*$html .= sprintf( '<li class="cat-item cat-item-%s" data-slug="%s"><a href="%s">%s</a></li>',
                $category_id,
                ! empty( $category->slug ) ? $category->slug : '',
                get_term_link( $category_id, 'course_category' ),
                ! empty( $category->name ) ? $category->name : ''
            );*/
        }
        $html .='</ul>';
        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_course_category_carousel', force_balance_tags($html));
    }

}
