<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

class Netbase_Toolkit_Element_Counters_Box{
    
    public static function initialize(){
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('netbase_counters_box', array(__CLASS__, 'shortcode_counters_box'));
    }
    
    public static function map(){
        vc_map(array(
            'name' => esc_html__('Udetor: Counters Box', 'netbase-toolkit'),
            'base' => 'netbase_counters_box',
            'category' => esc_html__('Udetor Elements', 'netbase-toolkit'),
            'description' => esc_html__('Display Counters Box.', 'netbase-toolkit'),
            'params' => array(               

                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Counters Value', 'netbase-toolkit'),
                    'param_name' => 'counters_value',
                    'std' => '20',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),                              

                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Text After Value', 'netbase-toolkit'),
                    'param_name' => 'txt_after_value',
                    'std' => '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type' => 'colorpicker',                    
                    'heading' => esc_html__('Text Color', 'netbase-toolkit'),
                    'param_name' => 'txt_color',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type'        => 'textfield',                    
                    'heading'     => esc_html__( 'Font size ', 'netbase-toolkit' ),
                    'param_name'  => 'font_size',
                    'min'         => 0,
                    'value'       => '',
                    'suffix'      => 'px',
                    'description' => esc_html__( 'Custom title font size px.', 'netbase-toolkit' ),
                    'std'         => '40',    
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                
                ),
                array(
                        'param_name' => 'txt_font_weight',
                        'heading'    => esc_html__( 'Font Weight', 'netbase-toolkit' ),
                        'type'       => 'dropdown',  
                        'std' =>'',                      
                        'value'      => array(
                            __( 'Select font weight', 'netbase-toolkit' )   => '',
                            __( 'normal', 'netbase-toolkit' )   => 'normal',
                            __( 'bold', 'netbase-toolkit' )  => 'bold',                             
                        ),                        
                        
                    ),

                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Counters Label', 'netbase-toolkit'),
                    'param_name' => 'counters_label',
                    'std' => '',
                ),
                array(
                    'type' => 'colorpicker',                    
                    'heading' => esc_html__('Label Color', 'netbase-toolkit'),
                    'param_name' => 'label_color',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type'        => 'textfield',                    
                    'heading'     => esc_html__( 'Label Font size ', 'netbase-toolkit' ),
                    'param_name'  => 'label_font_size',
                    'min'         => 0,
                    'value'       => '',
                    'suffix'      => 'px',
                    'description' => esc_html__( 'Custom title font size px.', 'netbase-toolkit' ),
                    'std'         => '18',     
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',               
                ),
                array(
                    'type' => 'checkbox',                    
                    'heading' => esc_html__('Disable Line Before Label', 'netbase-toolkit'),
                    'param_name' => 'disable_line_label',
                    'std' => false,                    
                ),  

                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('View More Text', 'netbase-toolkit'),
                    'param_name' => 'view_more_text',
                    'std' => '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('View More Link', 'netbase-toolkit'),
                    'param_name' => 'view_more_link',
                    'std' => '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),                                               

                //Alignment
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text alignment', 'netbase-toolkit' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Text at left', 'netbase-toolkit' )   => 'text-left',
                        __( 'Text at center', 'netbase-toolkit' ) => 'text-center',
                        __( 'Text at right', 'netbase-toolkit' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                ),

                array(
                    'heading'    => __( 'Extra class name', 'netbase-toolkit' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                /*icon*/
                array(
                    'param_name'       => 'style_icon',
                    'heading'          => esc_html__( 'Style Icon', 'netbase-toolkit' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                        
                        'value'            => array(                 
                            __( 'Select Style Icon', 'netbase-toolkit' )      => 'none',                                    
                            __( 'Icon', 'netbase-toolkit' )      => 'icon_fontawesome',
                            /*__( 'Image', 'netbase-toolkit' )     => 'image',*/
                            __( 'Icon Icomoon', 'netbase-toolkit' ) => 'icomoon',
                        ),
                ),
                array(
                        'param_name'  => 'icon',
                        'heading'     => esc_html__( 'Icon', 'netbase-toolkit' ),
                        'description' => esc_html__( 'Select icon from library.', 'netbase-toolkit' ),
                        'type'        => 'iconpicker',
                        'group'       => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'value'       => 'fa fa-adjust',
                        'settings'    => array(
                            'emptyIcon'    => false,
                            'iconsPerPage' => 4000,
                        ),
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value'   => 'icon_fontawesome',
                        ),
                ),
                array(
                        'param_name'  => 'icon_icomoon',
                        'heading'     => esc_html__( 'Icon icomoon', 'netbase-toolkit' ),
                        'description' => esc_html__( 'Select icon from library.', 'netbase-toolkit' ),
                        'type'        => 'iconpicker',
                        'group'       => esc_html__( 'Icon Settings', 'netbase-toolkit' ),
                        'value'       => '',
                        'settings' => array(
                            'emptyIcon' => true,
                            'type' => 'icomoon',
                            'iconsPerPage' => 200,
                        ),
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value'   => 'icomoon',
                        ),
                ),

                array(
                        'param_name' => 'icon_position',
                        'heading'    => esc_html__( 'Icon Position', 'netbase-toolkit' ),
                        'type'       => 'dropdown',                        
                        'value'      => array(
                            /*__( 'Top', 'udetor' )   => 'top',*/
                            __( 'Left', 'udetor' )  => 'left',  
                            /*__( 'Right', 'nb-elements' )  => 'right', */                         
                        ),                        
                        'edit_field_class' => 'vc_col-sm-4 vc_column',
                        'group' => esc_html__('Icon Settings', 'netbase-toolkit'),
                        'dependency'  => array(
                            'element' => 'style_icon',
                            'value_not_equal_to'   => 'none',
                        ),
                    ),
                
                array(
                    'type'        => 'textfield',                    
                    'heading'     => esc_html__( 'Icon size ', 'netbase-toolkit' ),
                    'param_name'  => 'icon_size',
                    'min'         => 0,
                    'value'       => '',
                    'suffix'      => 'px',
                    'description' => esc_html__( 'Custom font size px.', 'netbase-toolkit' ),                      
                    'edit_field_class' => 'vc_col-sm-4 vc_column',    
                    'group' => esc_html__('Icon Settings', 'netbase-toolkit'),
                    'dependency'  => array(
                        'element' => 'style_icon',
                        'value_not_equal_to'   => 'none',
                    ),           
                ),

                array(
                    'type' => 'colorpicker',
                    'admin_label' => true,
                    'heading' => esc_html__('Counters Icon Color', 'netbase-toolkit'),
                    'param_name' => 'counter_color',
                    'edit_field_class' => 'vc_col-sm-4 vc_column',
                    'group' => esc_html__('Icon Settings', 'netbase-toolkit'),
                    'dependency'  => array(
                        'element' => 'style_icon',
                        'value_not_equal_to'   => 'none',
                    ),
                ),
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Icon margin Top', 'netbase-toolkit'),
                    'param_name' => 'icon_margin_top',
                    'std' => '',
                    'edit_field_class' => 'vc_col-sm-4 vc_column',
                    'group' => esc_html__('Icon Settings', 'netbase-toolkit'),
                ),
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'netbase-toolkit' ),
                    'param_name' => 'editor_css',
                    'group' => __( 'Design options', 'netbase-toolkit' ),
                )
            )
        ));
    }
   
    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_counters_box($atts, $content = null){
        $label_class = $label_css = $css_class = $html = $css= $iconcss= $classwap = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'counters_label' => '',
                    'counters_value' => '20',
                    'txt_after_value' => '',
                    'view_more_text' => '',
                    'view_more_link' => '',
                    'txt_color' => '',
                    'icon' => '',                    
                    'counter_color' => '',                    
                    'font_size'         => '',
                    'text_align'=>'',
                    'editor_css' => '',
                    'label_color' =>'',
                    'label_font_size' =>'',
                    'disable_line_label' => false,
                    'txt_font_weight' =>'',
                    'icon_icomoon' => '',
                    'icon_position' => 'left',
                    'style_icon'=>'',
                    'icon_size' => '',
                    'icon_margin_top' =>'',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_counters_');
             
        if ( $txt_color != '') { $css .= 'color:' . $txt_color . ';'; }
        if ( $font_size != '' ) { $css .= 'font-size:' . $font_size . 'px;'; }
        if(isset($txt_font_weight) && $txt_font_weight !=''){ $css .= 'font-weight:' . $txt_font_weight .';';   }
        if ( $css ) {
            $css = ' style="' . $css . '"';
        }

        if(isset($text_align) && $text_align != ''){ $classwap .= $text_align; }
        if($icon_position == 'left'){
            $classwap .=' icon-pos-left';
        }elseif($icon_position == 'right'){
            $classwap .=' icon-pos-right';
        }

        $css_class = '';
        if (function_exists('vc_shortcode_custom_css_class')) {
            $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $editor_css, ' ' ), 'netbase_counters_box', $atts );  
        }
        if(isset($label_color) && $label_color !=''){
            $label_css .= 'color:' . $label_color . ';';
        }
        if ( isset($label_font_size) && $label_font_size != '' ) {
            $label_css .= 'font-size:' . $label_font_size . 'px;';
        }
        if($label_css){
            $label_css = ' style="' . $label_css . '"';
        }        
        if ( ! empty( $disable_line_label ) ) { $label_class .='line-none'; }
        if($icon_margin_top){
            $iconcss .='margin-top: '. $icon_margin_top .'px;' ;
        }
        if($icon_size){
             $iconcss .= 'font-size:' . ( is_numeric( trim( $icon_size ) ) ? trim( $icon_size ) . 'px' : trim( $icon_size ) ).';' ;
        }
        if($counter_color){
            $iconcss .='color: ' . esc_attr( $counter_color ).';' ;
        }
        if ( $iconcss ) {
            $iconcss = ' style="' . $iconcss . '"';
        }

        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="'.esc_attr( $css_class ).' netbase-toolkit udetor-counter-box '.$classwap.'">';
        if($counters_value){   
            if ( isset($style_icon) && 'icon_fontawesome' == $style_icon ) {            
                $html .= '<div class="counter-icon"><span class="' . esc_attr( $icon ) .'" '.$iconcss.'></span></div>';
            }elseif(isset($style_icon) && 'icomoon' == $style_icon){
                $html .= '<div class="counter-icon" ><span class="' . esc_attr( $icon_icomoon ) .'" '.$iconcss.'></span></div>';
            }         
            
            $html .= '<div class="content-box-percentage"><div class="display-percentage font-h1" data-percentage="' . $counters_value . '" '.$css.'>'. $counters_value .'</div>';           
            if ( $counters_label != '' ) {
                $html .= '<div class="counter-label '. esc_html($label_class) .'" '.$label_css.'>' . $counters_label . '</div>';
            }
            if ( '' != $view_more_text && '' != $view_more_link ) {
                $html .= '<a class="view-more" href="' . esc_url($view_more_link ) . '">' . esc_html($view_more_text) . '</a>';
            }
            if($txt_after_value){
                $html .='<style>#'. esc_attr($id) . ' .display-percentage:after{content:"'.$txt_after_value.'";} </style>';
            }
            $html .= '</div>';
        }
        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_counters_box', force_balance_tags($html));
    }
}
