<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
class Netbase_Toolkit_Element_Countdown
{
    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'map'));
        }
        // Add shortcode
        add_shortcode('netbase_countdown', array(__CLASS__, 'shortcode_countdown'));
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map()
    {
        vc_map( array(
            'name'        => esc_html__( 'Udetor: Countdown Box', 'udetor' ),
            'base'        => 'netbase_countdown',
            'category'    => esc_html__( 'Udetor Elements', 'udetor' ),
            'description' => esc_html__( 'Display Countdown Box.', 'udetor' ),
            'icon' => 'udetor-widget-icon udetor-widget-icon-countdown-box',
            'params'      => array(               
                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Days', 'udetor' ),
                    'param_name'  => 'text_days',
                    'std'         => esc_html__( 'days', 'udetor' ),
                    'group' => esc_html__( 'Text Settings', 'udetor' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Hours', 'udetor' ),
                    'param_name'  => 'text_hours',
                    'std'         => esc_html__( 'hours', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'udetor' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Minutes', 'udetor' ),
                    'param_name'  => 'text_minutes',
                    'std'         => esc_html__( 'minutes', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'udetor' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Seconds', 'udetor' ),
                    'param_name'  => 'text_seconds',
                    'std'         => esc_html__( 'seconds', 'udetor' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'udetor' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Year', 'udetor' ),
                    'param_name'  => 'time_year',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Month', 'udetor' ),
                    'param_name'  => 'time_month',
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Day', 'udetor' ),
                    'param_name'  => 'time_day',
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                /*array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Hour', 'udetor' ),
                    'param_name'  => 'time_hour',
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),*/

                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Style color', 'udetor' ),
                    'param_name' => 'style_color',
                    'value' => array_merge( getVcShared( 'colors' ) ),
                    'description' => __( 'Select style color.', 'udetor' ),
                    'param_holder_class' => 'vc_colored-dropdown',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'udetor' ),
                ),
                /*array(
                    'type' => 'colorpicker',
                    'heading' => __( 'Custom color', 'udetor' ),
                    'param_name' => 'custom_color',
                    'description' => __( 'Select custom icon color.', 'udetor' ),
                    'dependency' => array(
                        'element' => 'style_color',
                        'value' => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'udetor' ),
                ),*/
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text alignment', 'udetor' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        esc_html__( 'Select', 'udetor' )         => '',
                        esc_html__( 'Text at left', 'udetor' )   => 'text-left',
                        esc_html__( 'Text at center', 'udetor' ) => 'text-center',
                        esc_html__( 'Text at right', 'udetor' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'udetor' ),
                ),

                array(
                    'heading'    => __( 'Extra class name', 'udetor' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'udetor' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'udetor' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'udetor' ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Style Countdown', 'udetor' ),
                    'param_name' => 'style_countdown',
                    'description'=> 'Change style count down',
                    'value' => array(
                        'default' => 'default',
                        'square' => 'square',
                    ),
                ),
                
            )
        ) );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_countdown($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'text_days'    => esc_html__( 'days', 'udetor' ),
                    'text_hours'   => esc_html__( 'hours', 'udetor' ),
                    'text_minutes' => esc_html__( 'minutes', 'udetor' ),
                    'text_seconds' => esc_html__( 'seconds', 'udetor' ),
                    'time_year'    => '',
                    'time_month'   => '',
                    'time_day'     => '',
                    /*'time_hour'    => '',*/
                    'style_color'  => '',
                    'text_align'   => '',   
                    'style_countdown' =>'default',                 
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        $classes = array();
        if($style_color){
            $classes[] =' countdown-'.$style_color.' ';
        }

        $text_days    = ( isset( $text_days ) && '' != $text_days ) ? $text_days : 'days';
        $text_hours   = ( isset( $text_hours ) && '' != $text_hours ) ? $text_hours : 'hours';
        $text_minutes = ( isset( $text_minutes ) && '' != $text_minutes ) ? $text_minutes : 'minutes';
        $text_seconds = ( isset( $text_seconds ) && '' != $text_seconds ) ? $text_seconds : 'seconds';
  
        $year = ( (int) ( $time_year ) != '' ) ? (int) ( $time_year ) : date( "Y", time() );
        $month = ( (int) ( $time_month ) != '' ) ? (int) ( $time_month ) : date( "m", time() );
        $day = ( (int) ( $time_day ) != '' ) ? (int) ( $time_day ) : date( "d", time() );
      
        /*if ( $time_hour != '' ) {
            $hour = ( (int) ( $time_hour ) != '' ) ? (int) ( $time_hour ) : date( "G", time() );
        }*/

        // Generate HTML code.
        $datetime = date( ent2ncr($year. '/'. $month  .'/' . $day  ));
        
        $html .= '<div id="' . esc_attr($id) . '" class="netbase-toolkit countdown-box '. esc_attr( implode( ' ', $classes ) ) .' '.esc_html($style_countdown).'">';        
            $html .= '<div class="education-event-time-countdown">';
            //$start_date = $datetime->start_date('Y/m/d'); 
            $html .= '<div data-countdown="'.$datetime.'" class="education-time-countdown">';
            $html .= '<div class="education-days font-h1"><span></span>'.$text_days.'</div>';
            $html .= '<div class="education-hours font-h1"><span></span>'.$text_hours.'</div>';
            $html .= '<div class="education-mins font-h1"><span></span>'.$text_minutes.'</div>';
            $html .= '<div class="education-secs font-h1"><span></span>'.$text_seconds.'</div>';
            $html .= '</div>';
            $html .= '</div>';
        $html .= '</div><!-- .netbase-toolkit -->';

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_countdown', force_balance_tags($html));
    }
    
}