<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;


// Element Class 
class Netbase_Toolkit_Element_Content_Tabs  {

    public static function initialize()
    {
        // Add map for vc
        if (class_exists('Vc_Manager')) {
            add_action('init', array(__CLASS__, 'vc_mapping'));
        }

        // Add shortcode
        add_shortcode('netbase_vc_content_tabs', array(__CLASS__, 'netbase_vc_content_tabs'));     
        add_action( 'wp_ajax_load_content_tabs', array( __CLASS__, 'load_content_tabs' ) );
        add_action( 'wp_ajax_nopriv_load_content_tabs', array( __CLASS__, 'load_content_tabs' ) );   
        // Enqueue script
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_s' ) );
    }

    public static function enqueue_s(){

        wp_register_script( 'edu-element-tabs', NETBASE_TOOLKIT_URL . 'assets/js/element/content-tabs.js', array('jquery'), false, true );

         wp_localize_script( 'edu-element-tabs', 'educontentajax', array(
            'ajax_url' => admin_url( 'admin-ajax.php' )
         ));
         wp_enqueue_script( 'edu-element-tabs' );
    }
      
    // Element Mapping
    public static function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
        $categories = get_terms( 'course_category' );
        $categories_dropdown[] = array(
                'label' => 'All categories',
                'value' => '',
        );
        foreach ($categories as $category) {
                $name = $category->name;
                $value = $category->slug;
                $categories_dropdown[] = array(
                    'label' => $name,
                    'value' => $value,
                );
        }       
         
        vc_map( array(
            'name' => esc_html__('Udetor: Course Tabs', 'udetor'),
            "base" => "netbase_vc_content_tabs",
            "class" => "",
            'category' => esc_html__('Udetor Elements', 'udetor'),
            'description' => esc_html__('Display Content Tabs.', 'udetor'),

            "params" => array(
                array(
                    'type'          => 'dropdown',
                    'heading'       => esc_html__( 'Product type', 'udetor' ),
                    'param_name'    => 'product_type',
                    'admin_label'   => true,
                    'value'         => array(
                            esc_html__('Recent', 'udetor')       => 'recent',
                            esc_html__('Featured', 'udetor') => 'featured',
                            esc_html__('Best Selling', 'udetor') => 'best_selling',
                            esc_html__('Top Rated', 'udetor')    => 'top_rated',
                            esc_html__('Mixed Order', 'udetor')  => 'mixed_order'
                            ),
                    'description'   => esc_html__( 'Select type of product', 'udetor' ),
                    'group'         =>'Content',
                ),

                array(
                    'type'          => 'param_group',
                    'value'         => '',
                    'heading'       => __('Content', 'udetor'),
                    'param_name'    => 'vc_tab_lists',
                    'group'         =>'Content',
                    'params'        => array(
                        array(
                            "type"          => "textfield",
                            "holder"        => "div",
                            "class"         => "",
                            "heading"       => __( "Label", 'udetor' ),
                            "param_name"    => "vc_tab_label",
                            "value"         => '',
                        ),
                        
                        array(
                            'type'          => 'dropdown',
                            'heading'       => __('Categories', 'udetor'),
                            'param_name'    => 'vc_tab_category',
                            'value'         => $categories_dropdown,
                            'save_always'   => true,
                            'admin_label'   => true,
                            
                        ),
                        
                    )
                ),                

                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Tab title align", 'udetor' ),
                   "param_name"         => "tab_title_align",
                   'group'              =>'Content',
                   'value'              => array(                            
                       __( 'Center', 'udetor' )      => 'text-center',
                       __( 'Left', 'udetor' )        => 'text-left',
                       __( 'Right', 'udetor' )       => 'text-right'
                   ),
                ),

                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Tab Grid Style", 'udetor' ),
                   "param_name"         => "tab_grid_style",
                   'group'              =>'Content',
                   'value'              => array(                            
                       __( 'Default', 'udetor' )      => 'default',
                       __( 'Style 1', 'udetor' )        => 'style-1',
                       __( 'Style 2', 'udetor' )       => 'style-2'                       
                   ),
                ),
                array(
                    "type"          => "textfield",
                    "holder"        => "div",
                    "class"         => "",
                    "heading"       => __( "Limit", 'udetor' ),
                    "param_name"    => "vc_tab_product_limit",
                    'group'         =>'Content',
                    "value"         => 8,
                ),
                array(
                   "type"           => "dropdown",
                   "heading"        => __( "Column", 'udetor' ),
                   "param_name"     => "vc_tab_product_col",
                   'std'            => 4,
                   'group'          =>'Content',
                   'value'          => array(                            
                       __( '1', 'udetor' )       => 1,
                       __( '2', 'udetor' )       => 2,
                       __( '3', 'udetor' )       => 3,
                       __( '4', 'udetor' )       => 4,
                       __( '5', 'udetor' )       => 5,
                   ),
                ),
                array(
                   "type"           => "dropdown",
                   "heading"        => __( "Nice style", 'udetor' ),
                   "param_name"     => "vc_bg_style",
                   'group'          =>'Content',
                   'value'          => array(                            
                       __( 'default', 'udetor' )       => 'default',
                       __( 'Wave', 'udetor' )       => 'bg-white',
                   ),
                   'std'            => 'default',
                   "dependency" => Array('element' => "tab_grid_style", 'value' => array('style-2')),
                ),                     
            )
        ));
    }     
     
    // Element HTML
    public static function netbase_vc_content_tabs($atts, $content = null)
    {
        extract( shortcode_atts( array(
            'tab_title_align'   => 'center',
            'product_type'      => '',
            'vc_tab_lists'      => '',
            'vc_tab_product_limit'      => 8,
            'vc_tab_product_col'        => 4,
            'tab_grid_style'    => '',
            'vc_bg_style'       => 'default',
        ), $atts ) );

        ob_start();
        $vc_tab_lists = vc_param_group_parse_atts($vc_tab_lists);

        if($tab_grid_style != ''){
           $grid_style = $tab_grid_style;
        }else{
           $grid_style = 'default';
        }

        $e_params = array('col' => $vc_tab_product_col, 'grid' => $grid_style);

        // Generate custom ID
        $product_tab_id = uniqid('product_tab_');

        if($vc_tab_lists):

        ?>        
        <div class="netbase-toolkit vc-tab-content-wrapper">                
                <div class="vc-tab-product-header">
                    <ul class="tab-label">
                        <?php 
                        $div_content                = '';
                        $first_tab_label            = '';
                            
                        foreach ($vc_tab_lists as $tab_key => $tab_value):
                            $term                   = get_term_by( 'slug', $tab_value['vc_tab_category'], 'course_category' );
                            $cat_name               = is_object($term) ? $term->name : esc_html__('All categories');
                            $tab_label              = isset($tab_value['vc_tab_label']) ? $tab_value['vc_tab_label'] : $cat_name;
                            
                            if($tab_key == 0) {
                                $first_tab_label = $tab_label;                                
                            }
                            else {
                                $div_content .= '<div id="' . md5($product_tab_id.$tab_key.$tab_label).'" class="tab-panel" data-term_id="'.esc_attr($tab_value['vc_tab_category']).'" data-limit="'.esc_attr($vc_tab_product_limit).'" data-col="'.esc_attr($vc_tab_product_col).'" data-grid="'.esc_attr($grid_style).'"></div>';
                            }
                        ?>
                            <li <?php if($tab_key == 0) echo 'class="active"';?>>
                                <a href="#<?php echo md5($product_tab_id.$tab_key.$tab_label);?>"><?php echo esc_html($tab_label);?></a>
                            </li>
                        <?php endforeach;?>
                    </ul>
                </div>
                
                <div class="vc-tab-product-content <?php if(!empty($vc_bg_style)){echo $vc_bg_style;} ?>">
                    <div id="<?php echo md5($product_tab_id.'0'.$first_tab_label);?>" class="tab-panel panel-active" >
                        <?php                           
                        $product_cat = isset($vc_tab_lists[0]['vc_tab_category']) ? $vc_tab_lists[0]['vc_tab_category'] : '';

                            $tab_args = array(
                                'post_type' => 'sfwd-courses',
                                'post_status' => 'publish',
                                'posts_per_page' => $vc_tab_product_limit,
                                'tax_query' => array(
                                    array(
                                    'taxonomy' => 'course_category',
                                    'field' => 'slug',
                                    'terms' => $product_cat
                                ))
                            );                            

                            $tab_product = new WP_Query( $tab_args );

                            if ( $tab_product->have_posts() ) :
                                echo '<div class="products row grid-type">';

                                while ( $tab_product->have_posts() ) : $tab_product->the_post();                                    
                                    Netbase_Toolkit::netbase_toolkit_template('list-course.php', $e_params, true);
                                endwhile;

                                echo '</div>';
                            endif;
                            wp_reset_postdata();
                        ?>
                   </div>
                   
                   <?php print $div_content; ?>
                </div>
        </div>
        
         <?php
        endif;         
        return ob_get_clean();
    }


    function load_content_tabs() {

        $product_cat  = $_POST['cat'];
        $limit        = absint($_POST['limit']);
        $col          = absint($_POST['col']);
        $grid  = $_POST['grid'];
        $params_type = array('col' => $col, 'grid' => $grid);
        $tab_args = array(
            'post_type' => 'sfwd-courses',
            'post_status' => 'publish',
            'posts_per_page' => $limit,
            'tax_query' => array(
                array(
                'taxonomy' => 'course_category',
                'field' => 'slug',
                'terms' => $product_cat
            ))          
            
        );
        
        $tab_product = new WP_Query( $tab_args );

        if ( $tab_product->have_posts() ) :
            echo '<div class="products row grid-type">';
                while ( $tab_product->have_posts() ) : $tab_product->the_post();
                    Netbase_Toolkit::netbase_toolkit_template('list-course.php', $params_type, true);                    

                endwhile;
            echo '</div>';
        endif;
        wp_reset_postdata();
        die();
    }

    
     
} 

