<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * VC Element Functions
 */
class Netbase_Toolkit_Element_Helper
{

    /**
     * Initialize.
     *
     * @return  void
     */
    public static function initialize()
    {

        vc_add_shortcode_param('number', array(__CLASS__,'udetor_sc_number_settings_field'));
        vc_add_shortcode_param('dropdown_multiple',  array(__CLASS__,'udetor_vc_dropdown_multiple_form_field'));

    }

    public static function udetor_get_feature_image( $attachment_id, $size_type = null, $width = null, $height = null, $alt = null, $title = null ) {

        if ( ! $size_type ) {
            $size_type = 'full';
        }
        $src   = wp_get_attachment_image_src( $attachment_id, $size_type );
        $style = '';
        if ( ! $src ) {
            // Get demo image
            global $wpdb;
            $attachment_id = $wpdb->get_col(
                $wpdb->prepare(
                    "SELECT p.ID FROM $wpdb->posts AS p INNER JOIN $wpdb->postmeta AS pm ON p.ID = pm.post_id
				WHERE 	pm.meta_key = %s
				AND 	pm.meta_value LIKE %s",
                    '_wp_attached_file',
                    '%demo_image.jpg'
                )
            );

            if ( empty( $attachment_id[0] ) ) {
                return;
            }

            $attachment_id = $attachment_id[0];
            $src           = wp_get_attachment_image_src( $attachment_id, 'full' );

        }

        if ( $width && $height ) {

            if ( $src[1] >= $width || $src[2] >= $height ) {

                $crop = ( $src[1] >= $width && $src[2] >= $height ) ? true : false;

                if ( $new_link = aq_resize( $src[0], $width, $height, $crop ) ) {

                    $src[0] = $new_link;

                }

            }
            $style = ' width="' . $width . '" height="' . $height . '"';
        } else {
            if ( ! empty( $src[1] ) && ! empty( $src[2] ) ) {
                $style = ' width="' . $src[1] . '" height="' . $src[2] . '"';
            }
        }

        if ( ! $alt ) {
            $alt = get_the_title( $attachment_id );
        }

        if ( ! $title ) {
            $title = get_the_title( $attachment_id );
        }

        return '<img src="' . esc_url( $src[0] ) . '" alt="' . esc_attr( $alt ) . '" title="' . esc_attr( $title ) . '" ' . $style . '>';

    }

    /**
     * Animation
     *
     * @param $css_animation
     *
     * @return string
     */

    public static function udetor_getCSSAnimation( $css_animation ) {
        $output = '';
        if ( $css_animation != '' ) {
            wp_enqueue_script( 'udetor-waypoints' );
            $output = ' wpb_animate_when_almost_visible wpb_' . $css_animation;
        }

        return $output;
    }

    /**
     * Generate param type "number"
     *
     * @param $settings
     * @param $value
     *
     * @return string
     */

    public static function udetor_sc_number_settings_field($settings, $value)
    {
        $param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
        $type = isset($settings['type']) ? $settings['type'] : '';
        $min = isset($settings['min']) ? $settings['min'] : '';
        $max = isset($settings['max']) ? $settings['max'] : '';
        $suffix = isset($settings['suffix']) ? $settings['suffix'] : '';
        $class = isset($settings['class']) ? $settings['class'] : '';
        $output = '<input type="number" min="' . $min . '" max="' . $max . '" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="' . $value . '" style="max-width:100px; margin-right: 10px;" />' . $suffix;
        return $output;
    }

    public static function udetor_vc_dropdown_multiple_form_field($settings, $value)
    {
        $output = '';
        $css_option = str_replace('#', 'hash-', vc_get_dropdown_option($settings, $value));
        $output .= '<select name="'
            . $settings['param_name']
            . '" class="wpb_vc_param_value wpb-input wpb-select '
            . $settings['param_name']
            . ' ' . $settings['type']
            . ' ' . $css_option
            . '" multiple data-option="' . $css_option . '">';
        if (is_array($value)) {
            $value = isset($value['value']) ? $value['value'] : array_shift($value);
        }
        if (!empty($settings['value'])) {
            foreach ($settings['value'] as $index => $data) {
                if (is_numeric($index) && (is_string($data) || is_numeric($data))) {
                    $option_label = $data;
                    $option_value = $data;
                } elseif (is_numeric($index) && is_array($data)) {
                    $option_label = isset($data['label']) ? $data['label'] : array_pop($data);
                    $option_value = isset($data['value']) ? $data['value'] : array_pop($data);
                } else {
                    $option_value = $data;
                    $option_label = $index;
                }
                $selected = '';
                $option_value_string = (string)$option_value;
                $value_string = (string)$value;
                if ('' !== $value && $option_value_string === $value_string) {
                    $selected = ' selected="selected"';
                }
                $option_class = str_replace('#', 'hash-', $option_value);
                $output .= '<option class="' . esc_attr($option_class) . '" value="' . esc_attr($option_value) . '"' . $selected . '>'
                    . htmlspecialchars($option_label) . '</option>';
            }
        }
        $output .= '</select>';

        return $output;
    }

    /**
     * Get post categories array
     *
     * @return array
     */
    public static function udetor_sc_get_categories()
    {
        $args = array(
            'orderby' => 'id',
            'parent' => 0
        );
        $items = array();
        $items[esc_html__('All', 'udetor')] = 'all';
        $categories = get_categories($args);
        if (isset($categories)) {
            foreach ($categories as $key => $cat) {
                $items[$cat->cat_name] = $cat->cat_ID;
                $childrens = get_term_children($cat->term_id, $cat->taxonomy);
                if ($childrens) {
                    foreach ($childrens as $key => $children) {
                        $child = get_term_by('id', $children, $cat->taxonomy);
                        $items['--' . $child->name] = $child->term_id;

                    }
                }
            }
        }

        return $items;
    }

    public static function udetor_sc_get_categories_slug()
    {
        $args = array(
            'orderby' => 'id',
            'parent' => 0
        );
        $items = array();
        $items[esc_html__('All', 'udetor')] = 'all';
        $categories = get_categories($args);
        if (isset($categories)) {
            foreach ($categories as $key => $cat) {
                $items[$cat->cat_name] = $cat->slug;

                $childrens = get_term_children($cat->term_id, $cat->taxonomy);
                if ($childrens) {
                    foreach ($childrens as $key => $children) {
                        $child = get_term_by('id', $children, $cat->taxonomy);
                        $items['--' . $child->name] = $child->slug;                       

                    }
                }
            }
        }

        return $items;
    }

    public static function udetor_sc_get_list_image_size()
    {
        global $_wp_additional_image_sizes;

        $sizes = array();
        $get_intermediate_image_sizes = get_intermediate_image_sizes();

        // Create the full array with sizes and crop info
        foreach ($get_intermediate_image_sizes as $_size) {

            if (in_array($_size, array('thumbnail', 'medium', 'large'))) {

                $sizes[$_size]['width'] = get_option($_size . '_size_w');
                $sizes[$_size]['height'] = get_option($_size . '_size_h');
                $sizes[$_size]['crop'] = (bool)get_option($_size . '_crop');

            } elseif (isset($_wp_additional_image_sizes[$_size])) {

                $sizes[$_size] = array(
                    'width' => $_wp_additional_image_sizes[$_size]['width'],
                    'height' => $_wp_additional_image_sizes[$_size]['height'],
                    'crop' => $_wp_additional_image_sizes[$_size]['crop']
                );

            }

        }

        $image_size = array();
        $image_size[esc_html__("No Image", 'udetor')] = 'none';
        $image_size[esc_html__("Custom Image", 'udetor')] = 'custom_image';
        if (!empty($sizes)) {
            foreach ($sizes as $key => $value) {
                if ($value['width'] && $value['height']) {
                    $image_size[$value['width'] . 'x' . $value['height']] = $key;
                } else {
                    $image_size[$key] = $key;
                }
            }
        }

        return $image_size;
    }

    /**
     * Custom excerpt
     *
     * @param $length
     *
     * @return string
     */
    public static function udetor_sc_get_the_excerpt($length)
    {
        $excerpt = get_the_excerpt();

        if (!$excerpt) {
            $excerpt = __('Sometimes, a picture is worth a thousand words.', 'udetor');
        } else {
            $words = explode(' ', $excerpt);
            $excerpt = '';

            foreach ($words as $word) {
                if (strlen($excerpt) < $length) {
                    $excerpt .= $word . ' ';
                } else {
                    break;
                }
            }
        }
        return $excerpt . '...';
    }


    public static function udetor_sc_get_course_categories($cats = false)
    {
        global $wpdb;
        $query = $wpdb->get_results($wpdb->prepare(
            "
				  SELECT      t1.term_id, t2.name
				  FROM        $wpdb->term_taxonomy AS t1
				  INNER JOIN $wpdb->terms AS t2 ON t1.term_id = t2.term_id
				  WHERE t1.taxonomy = %s
				  AND t1.count > %d
				  ",
            'category', 0
        ));

        if (!$cats) {
            $cats = array();
        }
        if (!empty($query)) {
            foreach ($query as $key => $value) {
                $cats[$value->name] = $value->term_id;
            }
        }

        return $cats;
    }

// Get list category our team
    public static function udetor_sc_get_team_categories()
    {
        global $wpdb;
        $query = $wpdb->get_results($wpdb->prepare(
            "
				  SELECT      t1.term_id, t2.name
				  FROM        $wpdb->term_taxonomy AS t1
				  INNER JOIN $wpdb->terms AS t2 ON t1.term_id = t2.term_id
				  WHERE t1.taxonomy = %s
				  AND t1.count > %d
				  ",
            'team_cat', 0
        ));

        $cats = array();
        $cats['All'] = esc_html__('all', 'udetor');
        if (!empty($query)) {
            foreach ($query as $key => $value) {
                $cats[$value->name] = $value->term_id;
            }
        }

        return $cats;
    }

    public static function udetor_sc_get_portfolio_categories()
    {
        $portfolio_category = get_terms('portfolio_cat', array(
            'hide_empty' => 0,
            'orderby' => 'ASC',
            'parent' => 0
        ));

        $cate = array();
        $cate[esc_html__('All', 'udetor')] = '';
        if (is_array($portfolio_category)) {
            foreach ($portfolio_category as $cat) {
                $cate[$cat->name] = $cat->term_id;
            }
        }

        return $cate;
    }

    public static function udetor_sc_get_categories_autocomplete()
    {
        $args = array(
            'orderby' => 'id',
            'parent' => 0
        );
        $items = array();
        $categories = get_categories($args);
        if (isset($categories)) {
            foreach ($categories as $key => $cat) {
                $items[] = array(
                    'value' => $cat->cat_ID,
                    'label' => $cat->cat_name
                );
                $childrens = get_term_children($cat->term_id, $cat->taxonomy);
                if ($childrens) {
                    foreach ($childrens as $key => $children) {
                        $child = get_term_by('id', $children, $cat->taxonomy);
                        $items[] = array(
                            'value' => $child->term_id,
                            'label' => '--' . $child->name
                        );
                    }
                }
            }
        }

        return $items;
    }


}