<?php
/**
 * @version    1.1
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

/**
 * Define core class.
 */
if( ! class_exists( 'Netbase_Toolkit' ) ):

class Netbase_Toolkit{
    /**
     * Variable to hold class prefix supported for autoloading.
     *
     * @var  string
     */
    protected static $prefix = 'Netbase_Toolkit_';

    /**
     * A reference to an instance of this class.
     */
    private static $instance;
    
    public static $post_type = 'udetor-component';

    /**
     * Returns an instance of this class.
     */
    public static function get_instance() {

        if ( null == self::$instance ) {
            self::$instance = new Netbase_Toolkit();
        }
        

        return self::$instance;
    }

    /**
     * Initialize.
     *
     * @return  void
     */      

    public static function initialize() {
        // Register class autoloader.
        spl_autoload_register( array( __CLASS__, 'autoload' ) );

        // Include function plugins if not include.
        self::include_function_plugins();
        
        // Load plugin textdomain.
        add_action( 'init', array( __CLASS__, 'load_textdomain' ) );

        // Custom Posts Per Page on Toolkit Categories
        add_action( 'pre_get_posts', array( __CLASS__, 'toolkit_custom_posts_per_page' ) );

        // Initialize custom post type.
        Netbase_Toolkit_Post_Type::initialize();

        // Initialize plugin metabox
        //Netbase_Toolkit_ACF_Fields::initialize();

        // Initialize shortcode
        Netbase_Toolkit_Shortcodes::initialize();

        
        if ( is_plugin_active('sfwd-lms/sfwd_lms.php') ) {
            add_action( 'init', array( __CLASS__, 'udetor_course_category_taxonomy' ) , 0 );
        }
        // Add Page Header post type 
        /*add_action('init', array(__CLASS__, 'udetor_register_page_header_type'));*/
        add_action( 'init', array( __CLASS__, 'register_post_type' ), 0 );
        add_filter( 'user_contactmethods',  array( __CLASS__, 'udetor_add_to_author_profile' ));
        add_shortcode('udetor_social_share', array(__CLASS__, 'udetor_social_share'));
        add_action( 'woocommerce_share', array( __CLASS__, 'udetor_social_share' ) );
        // Add custom css to admin
        add_action( 'admin_head', array( __CLASS__, 'admin_custom_css' ) );
        /*IcoMoon*/
        add_filter( 'init', array( __CLASS__, 'udetor_add_new_icon_set_to_iconbox' ), 40 );
        add_filter( 'vc_after_init', array( __CLASS__, 'udetor_add_font_picker' ), 40 );
        add_filter( 'vc_iconpicker-type-icomoon', array( __CLASS__, 'udetor_icon_array' ) );
        add_action( 'vc_base_register_front_css', array( __CLASS__, 'udetor_vc_iconpicker_base_register_css' ) );
        add_action( 'vc_base_register_admin_css', array( __CLASS__, 'udetor_vc_iconpicker_base_register_css') );
        add_action( 'vc_backend_editor_enqueue_js_css', array( __CLASS__, 'udetor_vc_iconpicker_editor_jscss' ) );
        add_action( 'vc_frontend_editor_enqueue_js_css', array( __CLASS__, 'udetor_vc_iconpicker_editor_jscss' ) );
        add_action('vc_enqueue_font_icon_element', array( __CLASS__, 'udetor_enqueue_font_icomoon' ));
        /*bmi calculator*/
        add_shortcode('udetor_bmi_calculator', array(__CLASS__, 'udetor_bmi_calculator'));
        add_action( 'wp_ajax_nopriv_send_bug_report', array(__CLASS__, 'send_bug_report') );
        add_action( 'wp_ajax_send_bug_report', array(__CLASS__, 'send_bug_report') );
        add_action( 'wp_enqueue_scripts', array(__CLASS__, 'scripts1') );
    }
    public static function udetor_core_sc_get_categories()
    {
        $args = array(
            'orderby' => 'id',
            'parent' => 0
        );
        $items = array();
        $items[esc_html__('All', 'udetor')] = 'all';
        $categories = get_categories($args);
        if (isset($categories)) {
            foreach ($categories as $key => $cat) {
                $items[$cat->cat_name] = $cat->cat_ID;
                $childrens = get_term_children($cat->term_id, $cat->taxonomy);
                if ($childrens) {
                    foreach ($childrens as $key => $children) {
                        $child = get_term_by('id', $children, $cat->taxonomy);
                        $items['--' . $child->name] = $child->term_id;

                    }
                }
            }
        }

        return $items;
    }
    public static function udetor_core_sc_get_list_image_size()
    {
        global $_wp_additional_image_sizes;

        $sizes = array();
        $get_intermediate_image_sizes = get_intermediate_image_sizes();

        // Create the full array with sizes and crop info
        foreach ($get_intermediate_image_sizes as $_size) {

            if (in_array($_size, array('thumbnail', 'medium', 'large'))) {

                $sizes[$_size]['width'] = get_option($_size . '_size_w');
                $sizes[$_size]['height'] = get_option($_size . '_size_h');
                $sizes[$_size]['crop'] = (bool)get_option($_size . '_crop');

            } elseif (isset($_wp_additional_image_sizes[$_size])) {

                $sizes[$_size] = array(
                    'width' => $_wp_additional_image_sizes[$_size]['width'],
                    'height' => $_wp_additional_image_sizes[$_size]['height'],
                    'crop' => $_wp_additional_image_sizes[$_size]['crop']
                );

            }

        }

        $image_size = array();
        $image_size[esc_html__("No Image", 'udetor')] = 'none';
        $image_size[esc_html__("Custom Image", 'udetor')] = 'custom_image';
        if (!empty($sizes)) {
            foreach ($sizes as $key => $value) {
                if ($value['width'] && $value['height']) {
                    $image_size[$value['width'] . 'x' . $value['height']] = $key;
                } else {
                    $image_size[$key] = $key;
                }
            }
        }

        return $image_size;
    }
    public static function scripts1() {       

        wp_enqueue_script( 'calculator-live', NETBASE_TOOLKIT_URL . 'assets/js/calculator-scripts.js', array( 'jquery' ), null, true );
        // set variables for script
        wp_localize_script( 'calculator-live', 'settings', array(
            'ajaxurl'    => admin_url( 'admin-ajax.php' ),            
        ) );

    }
    public static function send_bug_report() {        
        /*BMR = 10 × weight(kg) + 6.25 × height(cm) - 5 × age(y) + 5         (man)
        BMR = 10 × weight(kg) + 6.25 × height(cm) - 5 × age(y) - 161     (woman)*/
        $bmi = $info = $bmr = $reclass = '';
        if(isset($_REQUEST['csex']) && isset($_REQUEST['cage'])  ){
            if($_REQUEST['csex'] == 'male'){
            $bmr = 10 * $_REQUEST['ckg'] + 6.25 * $_REQUEST['cheightmeter'] - 5 *  $_REQUEST['cage'] + 5;    
            }elseif($_REQUEST['csex'] == 'female'){
            $bmr = 10 * $_REQUEST['ckg'] + 6.25 * $_REQUEST['cheightmeter'] - 5 *  $_REQUEST['cage'] -161;    
            }
            
        }            
        
        $bmi = $_REQUEST['ckg'] * 10000 / ( $_REQUEST['cheightmeter'] * $_REQUEST['cheightmeter']);
        if($bmi !=''){
            if($bmi < 15 ){
                $info = 'very severely underweight';
                $reclass = 'underweight';
            }
            elseif (($bmi >= 15)&&($bmi < 16)) {
                $info = "severely underweight";
                $reclass = 'underweight';
            }
            elseif (($bmi >= 16)&&($bmi < 18.5)) {
                $info = "underweight";
                $reclass = 'underweight';
            }
            elseif (($bmi >= 18.5)&&($bmi < 25)) {
                $info = "healthy";
                $reclass = 'healthy';
            }
            elseif (($bmi >= 25)&&($bmi < 30)) {
                $info = "overweight";
                $reclass = 'overweight';
            }
            elseif (($bmi >= 30)&&($bmi < 35)) {
                $info = "moderately obese";
                $reclass = 'obese';
            }
            elseif (($bmi >= 35)&&($bmi <= 40)) {
                $info = "severely obese";
                $reclass = 'obese';
            }
            elseif ($bmi >40) {
                $info = "very severely obese";
                $reclass = 'obese';
            }
        }
        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) { 
        echo '<span class="bmi-re '.$reclass.'">You are '.$info.'!!</span> Your BMI is '.round($bmi, 2);
        if($bmr !=''){
            echo ' .BMR:'.$bmr.' Calories/day';
        }
        
        die();
        }

    }
    public static function udetor_bmi_calculator($args){

        $content = '';
        $content .= '<div class="calculator-live row">
        <div class="col-md-6 bmi-cal-form">
        <div class="row">';
        if(isset($args['heading']) && $args['heading'] !=''){
            $content .= '<div class="col-md-12 heading-bmi">';
            $content .= $args['heading'];
            $content .= '</div>';
        }
        
        $content .= '<div class="col-md-6"><input type="text" name="cheightmeter" id="cheightmeter" value="" placeholder="Height / cm" >
            </div>
            <div class="col-md-6"><input type="text" name="ckg" id="ckg" value="" placeholder="Weight / kg" ></div>
            <div class="col-md-6"><input type="text" name="age" id="cage" placeholder="Age"></div>
            <div class="col-md-6 csex-bmi">
            <select name="csex" id="csex">
            <option value="default" selected="selected">sex</option>
            <option value="male">Male</option>
            <option value="female">Female</option>
            </select>
            </div>
            <div class="col-md-12">
                <button class="btn-color send-report">' . __( 'Calculator', 'netbase-toolkit' ) .'</button></div>  
            </div>
        </div>
        <div class="col-md-6 bmi-calculator-chart">
        <div class="bmi-chart-note">* <span>BMR</span> Metabolic Rate / <span>BMI</span> Body Mass Index</div>        
        <table>
                <thead>
                <tr>
                    <th>' . __( 'BMI result', 'netbase-toolkit' ) .'</th>
                    <th>' . __( 'Weight Status', 'netbase-toolkit' ) .'</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>Below 18.5</td>
                    <td>' . __( 'Underweight', 'netbase-toolkit' ) .'</td>
                </tr>
                <tr>
                    <td>18.5 - 24.9</td>
                    <td>' . __( 'Healthy', 'netbase-toolkit' ) .'</td>
                </tr>
                <tr>
                    <td>25.0 - 29.9</td>
                    <td>' . __( 'Overweight', 'netbase-toolkit' ) .'</td>
                </tr>
                <tr>
                    <td>30.0 - and Above</td>
                    <td>' . __( 'Obese', 'netbase-toolkit' ) .'</td>
                </tr>
                </tbody>
            </table>
        
        </div>
            <div class="col-md-12 calculator-response-wap"> 
                <div class="load-icon"></div> <i class="fa fa-times" style="display:none;"></i>    
                <p class="calculator-live-response" style="display:none;"></p>
            </div>
        </div>';

        return $content;

    }
    /*IcoMoon*/
    public static function udetor_add_new_icon_set_to_iconbox( ) {
        if (  class_exists( 'WPBMap' ) ) {   

            $param = WPBMap::getParam( 'vc_icon', 'type' );
            $param['value'][__( 'IcoMoon', 'total' )] = 'icomoon';
            vc_update_shortcode_param( 'vc_icon', $param );
        }
    }
    public static function udetor_add_font_picker() {
        vc_add_param( 'vc_icon', array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'total' ),
                'param_name' => 'icon_icomoon',
                'settings' => array(
                    'emptyIcon' => true,
                    'type' => 'icomoon',
                    'iconsPerPage' => 200,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'icomoon',
                ),
            )
        );
    }
    
    public static function udetor_icon_array() {
    return array(
        array('icomoon icon-abc' => 'bricks'),
        array('icomoon icon-bus' => 'bus'),
        array('icomoon icon-clock' => 'clock'),
        array('icomoon icon-group' => 'group'),
        array('icomoon icon-pencil' => 'pencil'),
        array('icomoon icon-placeholder' => 'placeholder'),
        array('icomoon icon-xylophone' => 'xylophone'),
        array('icomoon icon-book' => 'book'),
        array('icomoon icon-ball' => 'ball'),
        array('icomoon icon-check' => 'check'),
        array('icomoon icon-quality' => 'quality'),   
        array('icomoon icon-physical' => 'physical'),   
        array('icomoon icon-habits' => 'habits'),   
        array('icomoon icon-body_mass' => 'body_mass'),   
        array('icomoon icon-whistle' => 'whistle'),   
        array('icomoon icon-strong' => 'strong'),   
        array('icomoon icon-shorts' => 'shorts'),   
        array('icomoon icon-running' => 'running'), 
        array('icomoon icon-quotes-left' => 'quotes-left'), 
        array('icomoon icon-quotes-right' => 'quotes-right'),        
        array('icomoon icon-chocolate' => 'chocolate'),
        array('icomoon icon-dumbbell' => 'dumbbell'),
        array('icomoon icon-swimming-figure' => 'swimming'),       
        
    );
    }
    public static function udetor_vc_iconpicker_base_register_css(){
        wp_register_style('icomoon', NETBASE_TOOLKIT_URL. 'assets/vendors/icomoon/style.css');
    }
    public static function udetor_vc_iconpicker_editor_jscss(){
        wp_enqueue_style( 'icomoon' );
    }
    public static function udetor_enqueue_font_icomoon($font){
        switch ( $font ) {
            case 'icomoon': wp_enqueue_style( 'icomoon' );
        }
    }
    /*end-IcoMoon*/

    /**
     * Add some custom css to control notice of 3rd-plugin
     *
     * @since  1.1.8
     */
    public static function admin_custom_css() {
        echo '
            <style>
                .vc_license-activation-notice.updated,
                .rs-update-notice-wrap.updated,
                .installer-q-icon {
                    display: none;
                }
            </style>
        ';
    }

    /**
    * Print HTML for social share.
    *
    * @return  void
    */
    public static function udetor_social_share() {
        // Get post thumbnail
        $src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );    
    ?>
        <ul class="social-share pa tc">
            <li class="social-share-label"><?php esc_html_e( 'Share:', 'netbase-toolkit' ); ?></li>
          <li class="social-item mgb10">
            <a class="db tc br-2 color-dark " title="Facebook" href="http://www.facebook.com/sharer.php?u=<?php esc_url( the_permalink() ); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
              <i class="fa fa-facebook"></i>
            </a>
          </li>
          <li class="social-item mgb10">
            <a class="db tc br-2 color-dark " title="Twitter" href="https://twitter.com/share?url=<?php esc_url( the_permalink() ); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
              <i class="fa fa-twitter"></i>
            </a>
          </li>
          <li class="social-item mgb10">
            <a class="db tc br-2 color-dark " title="Googleplus" href="https://plus.google.com/share?url=<?php esc_url( the_permalink() ); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
              <i class="fa fa-google-plus"></i>
            </a>
          </li>
          <li class="social-item mgb10">
            <a class="db tc br-2 color-dark " title="Pinterest" href="//pinterest.com/pin/create/button/?url=<?php esc_url( the_permalink() ); ?>&media=<?php echo esc_attr( $src[0] ); ?>&description=<?php the_title(); ?>" onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
              <i class="fa fa-pinterest"></i>
            </a>
          </li>
        </ul>
    <?php
    }
    /**
     * Add Author Links
     */
    public static function udetor_add_to_author_profile( $contactmethods ) {
      $contactmethods['job_profile'] = 'Job Profile';
      $contactmethods['google_profile'] = 'Google Profile URL';
      $contactmethods['twitter_profile'] = 'Twitter Profile URL';
      $contactmethods['facebook_profile'] = 'Facebook Profile URL';
      $contactmethods['linkedin_profile'] = 'Linkedin Profile URL';
      $contactmethods['pinterest_profile'] = 'Pinterest Profile URL';
      $contactmethods['instagram_profile'] = 'Instagram Profile URL';

      return $contactmethods;
    }
    /**
     * Register custom post type.
     *
     * @since 0.8.2
     */
    public static function register_post_type() {
        $labels  = array(
            'name'                  => _x( 'Netbase Component', 'Post Type General Name', 'netbase-toolkit' ),
            'singular_name'         => _x( 'Netbase Component', 'Post Type Singular Name', 'netbase-toolkit' ),
            'menu_name'             => esc_html__( 'Netbase Components', 'netbase-toolkit' ),
            'name_admin_bar'        => esc_html__( 'Netbase Component', 'netbase-toolkit' ),
            'archives'              => esc_html__( 'Item Archives', 'netbase-toolkit' ),
            'parent_item_colon'     => esc_html__( 'Parent Item:', 'netbase-toolkit' ),
            'all_items'             => esc_html__( 'All Items', 'netbase-toolkit' ),
            'add_new_item'          => esc_html__( 'Add New Item', 'netbase-toolkit' ),
            'add_new'               => esc_html__( 'Add New', 'netbase-toolkit' ),
            'new_item'              => esc_html__( 'New Item', 'netbase-toolkit' ),
            'edit_item'             => esc_html__( 'Edit Item', 'netbase-toolkit' ),
            'update_item'           => esc_html__( 'Update Item', 'netbase-toolkit' ),
            'view_item'             => esc_html__( 'View Item', 'netbase-toolkit' ),
            'search_items'          => esc_html__( 'Search Item', 'netbase-toolkit' ),
            'not_found'             => esc_html__( 'Not found', 'netbase-toolkit' ),
            'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'netbase-toolkit' ),
            'featured_image'        => esc_html__( 'Featured Image', 'netbase-toolkit' ),
            'set_featured_image'    => esc_html__( 'Set featured image', 'netbase-toolkit' ),
            'remove_featured_image' => esc_html__( 'Remove featured image', 'netbase-toolkit' ),
            'use_featured_image'    => esc_html__( 'Use as featured image', 'netbase-toolkit' ),
            'insert_into_item'      => esc_html__( 'Insert into item', 'netbase-toolkit' ),
            'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'netbase-toolkit' ),
            'items_list'            => esc_html__( 'Items list', 'netbase-toolkit' ),
            'items_list_navigation' => esc_html__( 'Items list navigation', 'netbase-toolkit' ),
            'filter_items_list'     => esc_html__( 'Filter items list', 'netbase-toolkit' ),
        );
        $rewrite = array(
            'slug'       => self::$post_type,
            'with_front' => true,
            'pages'      => false,
            'feeds'      => false,
        );
        $args    = array(
            'label'               => esc_html__( 'Netbase Component', 'netbase-toolkit' ),
            'description'         => esc_html__( 'Post Type Description', 'netbase-toolkit' ),
            'labels'              => $labels,
            'supports'            => array( 'editor', ),
            'hierarchical'        => true,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => false,
            'menu_position'       => 20,
            'menu_icon'           => 'dashicons-layout',
            'show_in_admin_bar'   => false,
            'show_in_nav_menus'   => false,
            'can_export'          => false,
            'has_archive'         => false,
            'exclude_from_search' => true,
            'publicly_queryable'  => true,
            'rewrite'             => $rewrite,
            'capability_type'     => 'page',
        );
        register_post_type( self::$post_type, $args );
    }
    /**
     * Page Header Custom Type
     */
    public static function udetor_register_page_header_type()
    {

        /**
         * Post Type: Page Headers.
         */

        $labels = array(
            "name" => esc_html__('Page Headers', 'netbase-toolkit'),
            "singular_name" => esc_html__('Page Header', 'netbase-toolkit'),
        );

        $args = array(
            "label" => esc_html__('Page Headers', 'netbase-toolkit'),
            "labels" => $labels,
            "description" => "",
            "public" => true,
            "publicly_queryable" => true,
            "show_ui" => true,
            "show_in_rest" => false,
            "menu_icon" => 'dashicons-editor-kitchensink',
            "rest_base" => "",
            "has_archive" => false,
            "show_in_menu" => true,
            "exclude_from_search" => false,
            "capability_type" => "post",
            "map_meta_cap" => true,
            "hierarchical" => false,
            "rewrite" => array("slug" => "page_header", "with_front" => true),
            "query_var" => true,
            "supports" => array("title", "editor", "thumbnail"),
            "menu_position" => 0
        );

        register_post_type("page_header", $args);
    }

    // Register Custom Taxonomy
    public static function udetor_course_category_taxonomy() {

        $labels = array(
            'name'                       => _x( 'Udetor Course Category', 'Taxonomy General Name', 'netbase-toolkit' ),
            'singular_name'              => _x( 'course_category', 'Taxonomy Singular Name', 'netbase-toolkit' ),
            'menu_name'                  => __( 'Udetor Course Category', 'netbase-toolkit' ),
            'all_items'                  => __( 'All Items', 'netbase-toolkit' ),
            'parent_item'                => __( 'Parent Item', 'netbase-toolkit' ),
            'parent_item_colon'          => __( 'Parent Item:', 'netbase-toolkit' ),
            'new_item_name'              => __( 'New Item Name', 'netbase-toolkit' ),
            'add_new_item'               => __( 'Add New Item', 'netbase-toolkit' ),
            'edit_item'                  => __( 'Edit Item', 'netbase-toolkit' ),
            'update_item'                => __( 'Update Item', 'netbase-toolkit' ),
            'view_item'                  => __( 'View Item', 'netbase-toolkit' ),
            'separate_items_with_commas' => __( 'Separate items with commas', 'netbase-toolkit' ),
            'add_or_remove_items'        => __( 'Add or remove items', 'netbase-toolkit' ),
            'choose_from_most_used'      => __( 'Choose from the most used', 'netbase-toolkit' ),
            'popular_items'              => __( 'Popular Items', 'netbase-toolkit' ),
            'search_items'               => __( 'Search Items', 'netbase-toolkit' ),
            'not_found'                  => __( 'Not Found', 'netbase-toolkit' ),
            'no_terms'                   => __( 'No items', 'netbase-toolkit' ),
            'items_list'                 => __( 'Items list', 'netbase-toolkit' ),
            'items_list_navigation'      => __( 'Items list navigation', 'netbase-toolkit' ),
        );
        $args = array(
            'labels'                     => $labels,
            'hierarchical'               => true,
            'public'                     => true,
            'show_ui'                    => true,
            'show_admin_column'          => true,
            'show_in_nav_menus'          => true,
            'show_tagcloud'              => true,
        );
        register_taxonomy( 'course_category', array( 'sfwd-courses' ), $args );

    }

   
    /**
     * Include function plugins if not include.
     *
     * @return  void
     *
     * @since  1.1.8
     *
     */
    public static function include_function_plugins() {
        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
    }

    /* Notice message when not actived ACF */
    /*public static function admin_notices_warning_not_install_acf(){

        $class = 'notice notice-warning is-dismissible';
        $message = __( 'Please activate Advanced Custom Fields to make full use of post\'s attributes.', 'netbase' );

        printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );

    }*/

    public static function netbase_pagination_numbers( $custom_query = false ) {
        global $wp_query;
        if ( !$custom_query ) $custom_query = $wp_query;

        $paged_get = 'paged';
        if( is_front_page() && ! is_home() ):
            $paged_get = 'page';
        endif;

        $big = 999999999; // need an unlikely integer
        $pagination = paginate_links( array(
            'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            'format' => '?paged=%#%',
            'current' => max( 1, get_query_var( $paged_get ) ),
            'total' => $custom_query->max_num_pages,
            'type'   => 'list',
            'prev_text'    => '<i class="fa fa-angle-left"></i>',
            'next_text'    => '<i class="fa fa-angle-right"></i>',
        ) );

        $pagenavi_align = get_theme_mod( 'netbase_page_navigation_align' );
        if( ! $pagenavi_align ): $pagenavi_align = 'align-left'; endif;

        if ( $pagination ) {
            return '<div class="netbase-pagination '. esc_attr( $pagenavi_align ) .'">'. $pagination . '</div>';
        }
    }

    /**
     * Custom posts per page toolkit categories listing
     */
    public static function toolkit_custom_posts_per_page( $query ) {
        if ( is_tax( 'toolkit_cat' ) && $query->is_main_query() ) {
            $numpost = get_theme_mod( 'netbase_toolkit_cat_showposts' );
            if( ! isset ( $numpost ) || empty( $numpost ) ): $numpost = '12'; endif;
            $query->set( 'posts_per_page', $numpost );
        }
    }

    /**
     * Load plugin textdomain.
     *
     * @since 1.0.1
     */
    public static function load_textdomain() {
        load_plugin_textdomain( 'netbase-toolkit', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }

    /**
     * Method to autoload class declaration file.
     *
     * @param   string  $class_name  Name of class to load declaration file for.
     *
     * @return  mixed
     */
    public static function autoload( $class_name ) {
        // Verify class prefix.
        if ( 0 !== strpos( $class_name, self::$prefix ) ) {
            return false;
        }

        // Generate file path from class name.
        $base = NETBASE_TOOLKIT_PATH . 'classes/';
        $path = strtolower( str_replace( '_', '/', substr( $class_name, strlen( self::$prefix ) ) ) );

        // Check if class file exists.
        $standard    = $path . '.php';
        $alternative = $path . '/' . basename( $path ) . '.php';

        while ( true ) {
            // Check if file exists in standard path.
            if ( @is_file( $base . $standard ) ) {
                $exists = $standard;

                break;
            }

            // Check if file exists in alternative path.
            if ( @is_file( $base . $alternative ) ) {
                $exists = $alternative;

                break;
            }

            // If there is no more alternative file, quit the loop.
            if ( false === strrpos( $standard, '/' ) || 0 === strrpos( $standard, '/' ) ) {
                break;
            }

            // Generate more alternative files.
            $standard    = preg_replace( '#/([^/]+)$#', '-\\1', $standard );
            $alternative = dirname( $standard ) . '/' . substr( basename( $standard ), 0, -4 ) . '/' . basename( $standard );
        }

        // Include class declaration file if exists.
        if ( isset( $exists ) ) {
            return include_once $base . $exists;
        }

        return false;
    }

    public static function netbase_toolkit_template( $path, $args = array(), $render = false ) {
        $template = locate_template( NETBASE_TOOLKIT_PATH . 'templates/' );

        if ( ! $template ) {
            $template = NETBASE_TOOLKIT_PATH . 'templates/'. $path;
        }

        if ( $render ) {
            return self::netbase_toolkit_render_template( $template, $args );
        }

        return self::netbase_toolkit_get_template( $template, $args );
    }

    private static function netbase_toolkit_get_template( $file, $args = array() ) {
        if ( ! is_file( $file ) || ! is_readable( $file ) ) {
            return false;
        }

        ob_start();
        include $file;

        return ob_get_clean();
    }

    private static function netbase_toolkit_render_template( $file, $args = array() ) {
        if ( ! is_file( $file ) || ! is_readable( $file ) ) {
            return false;
        }

        include $file;

        return true;
    }
}

endif; /* End check if class exists */