<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

require_once(ABSPATH . 'wp-admin/includes/template.php');
// settings

class Netbase_Toolkit_Comment_Star_Rating
{
	public $ratings;
	public $total;
	public $count;
	public $average;
	public $ratings_arrange;
	function __construct() {
        $path				= __FILE__;
        $dir				= dirname( $path );
		$this->ratings 		= array();
		$this->name 		= 'NBComment Star Rating';
		$this->prefix 		= 'nbcsr_';
		$this->options		= array();
        $this->url			= plugins_url( '', $path );
	}
	function init() {
		if ( is_admin() ) {
			add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		} else {
			$this->options = get_option(COMMENT_STAR_RATING_DOMAIN);
			add_action( 'wp',  array( $this, 'get_average_rating') );
			
			add_action( 'wp_head', array( $this, 'raty_init' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'wp_enqueue_styles' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'wp_enqueue_scripts' ) );
			// comment form
			add_filter( 'comment_form_default_fields', array( $this, 'comment_form' ) );
			// comment post
			add_action( 'comment_post', array( $this, 'comment_post' ) );
			// comment display
			add_action( 'comment_text', array( $this, 'comment_display' ) );
			// shortcode
			add_shortcode( 'udetor_comment_star_rating_bar', array( $this, 'shortcode' ) );
			
		}
	}
	
	function shortcode( $atts ){
		ob_start(); 		
		
		if(isset($this->average)){
			$set_average = $this->average;	
		}else{
			$set_average = 0;
		}
		$output = wp_star_rating( array(
			'rating'    => $set_average,
			'type'      => 'rating',
			'number'    => $this->count,
			'echo'      => false
		));
		$snumb = 0;
		if($this->average){
			$snumb = $this->average;
		}
		echo '<div class="row review-bar-wap">';
			echo '<div class="col-md-4 col-sm-12 col-sp-12"><span class="font-h1 review-bar-title">'. esc_html__( 'Avage Rating', 'netbase-toolkit' ) .'</span>';
				echo '<div class="avage-rating-box">';
					echo '<div class="average-rating-value font-h1">'. $snumb .'</div>';
					echo $output;
					echo '<div class="review-amount">'.$this->count.'  rating</div>';
				echo '</div>';
			echo '</div>';			
		?>		
			<div class="reviews_bar col-md-8 col-sm-12 col-sp-12">
			<span class="font-h1 review-bar-title"><?php echo esc_html__( 'Detailed Rating', 'netbase-toolkit' );  ?></span>
	        <?php for ($i = 5; $i >= 1; $i--) :
	            $perc = ($this->count == 0) ? 0 : floor($this->ratings_arrange[$i] / $this->count * 100);
	            ?>

	            <div class="wpnetbase_review_row">
	                <span class="wpnetbase_stars_value"><?php printf(_n('%s <i class="fa fa-star" aria-hidden="true"></i>', '%s <i class="fa fa-star" aria-hidden="true"></i>', $i, 'udetor'), $i); ?></span>
	                <span class="wpnetbase_num_reviews"><?php printf('%s %%', $perc); ?> </span>
					<span class="wpnetbase_rating_bar">
						<span style="background-color:#f4f4f4" class="wpnetbase_scala_rating">
							<span class="wpnetbase_perc_rating" style="<?php echo 'width:'.$perc.'% ;'; ?>">							
	                                <span style="color:#666666" class="wpnetbase_perc_value"></span>                            
							</span>
						</span>
					</span>                
	            </div>
	        <?php endfor; ?>
	    	</div>
    	</div>
		<?php		
		$reviewsbar = ob_get_contents();
        ob_end_clean();
        
        return $reviewsbar; 
	}
	function get_average_rating() {
		global $post;
		if( !is_object($post) ) 
        return;
		$comments = get_comments(array(
			'status' => 'approve',
			'number' => 700,
			'post_id'=> $post->ID,
		));
		// Get total, number, average
		foreach($comments as $comment) {
			$star = get_comment_meta( $comment->comment_ID, 'nbcsr_rating', true);
			
			if( !empty( $star ) ) {
				array_push( $this->ratings, $star );
			}
		}
		
		$this->total      = array_sum($this->ratings);
		$this->count      = count($this->ratings);
		
		if( $this->count > 0 ) {
			$this->average    = $this->total / $this->count;
			$this->ratings_arrange = array_count_values($this->ratings);
		}
		
		// Insert 0 if it is undefined or empty
		for ( $i = 1; $i <= 5; $i++) {
			if( !isset($this->ratings_arrange[$i]) ) {
				$this->ratings_arrange[$i] = 0;
			}
		}
	}
	
	function raty_init() {
		?>
			<script>
				document.addEventListener('DOMContentLoaded', function() {
					jQuery('#input-type-star').raty({
						starType: 'i',	/*Web Fonts*/
						number: 5,		/*number*/
						score : 3,		/*Defaults Star*/
						/*half : true,
						halfShow checke_admin_refere: true, */
						hints: ['I do not like it at all', 'I do not like it', 'ordinary', 'favorite', 'I liked it very much.'],
					});
					jQuery('#commentform').submit(function(){
						var score = jQuery('#input-type-star').raty('score');
						jQuery('input[name=nbcsr_rating]').val(score);
					});
				});
			</script>
		<?php
	}
	function wp_enqueue_styles() {		
		wp_enqueue_style( 'nbcsr-rating', NETBASE_TOOLKIT_URL . 'assets/css/rating.css' );
		
	}
	function wp_enqueue_scripts() {
		wp_enqueue_script( 'raty', NETBASE_TOOLKIT_URL . 'assets/js/jquery.raty.js', array('jquery') );
	}
	// Add / delete star input form to comment
	function comment_form( $fields ) {
		global $post;
		$post_type = get_post_type();
		$fields['rating'] = null;
		if ( isset( $this->options[$post_type] ) && $this->options[$post_type] == 1  ) {
			$fields['rating'] .= '<span class="rating-label">Rating*</span> <div id="input-type-star"></div>';
			$fields['rating'] .= '<input type="hidden" name="nbcsr_rating" value="" />';
		}
		
		return $fields;
	}
	// Saving comments
	function comment_post( $comment_id ) {
		$_comment = get_comment( $comment_id );
		$_post    = get_post( $_comment->comment_post_ID );
		if( !is_user_logged_in() ) {
			// data check
			$rating = isset( $_POST['nbcsr_rating'] ) && is_numeric( $_POST['nbcsr_rating'] ) ? $_POST['nbcsr_rating'] : 3;
			$rating = intval( $rating );
			if ( ! $rating ) {
				$rating = '';
			}
			if ( strlen( $rating ) > 1 ) {
				$rating = substr( $rating, 0, 1 );
			}
			// add
			add_comment_meta( $comment_id, 'nbcsr_rating', $rating );
		}
		return $comment_id;
	}
	// Display rating at end of comment
	function comment_display( $comment ) {
		$post_type = get_post_type();
		$comment_id = get_comment_ID();
		$star = get_comment_meta( get_comment_ID(), 'nbcsr_rating', true);
		$star = isset( $star ) && is_numeric( $star ) ? $star : 3;

		if ( isset( $this->options[$post_type] ) && $this->options[$post_type] == 1  ) {
			$output = wp_star_rating( array(
				'rating'    => $star,
				'type'      => 'rating',
				'number'    => 0,
				'echo'      => false,
			));
			return $comment.$output;
		}
	}
	// Add management screen
	function admin_menu() {
		add_options_page (
			$this->name, //page_title
			$this->name, //menu_title
			'manage_options', // capabiliity
			COMMENT_STAR_RATING_DOMAIN, //menu_slug
			array( $this, 'admin_save_options' ) //callback
		);
	}
	function admin_setting_form() {
		$post_types = wp_list_filter( get_post_types(array('public'=>true)),array('attachment'), 'NOT' );

		?>
		<div class="wrap">
			<h2><?php echo esc_attr($this->name); ?> &raquo; <?php _e('Settings'); ?></h2>
			<form id="<?php echo esc_attr(COMMENT_STAR_RATING_DOMAIN); ?>" method="post" action="">
				<?php wp_nonce_field( 'nbcsr-nonce-key', 'nbcsr-key' ); ?>
				<h3><?php _e('Please select the post type to enable'); ?></h3>
				<?php
					foreach ( $post_types as $post_type ) {
				?>
					<p>
					<strong><?php echo esc_attr($post_type); ?></strong>
					<input type="checkbox" name="<?php echo esc_attr(COMMENT_STAR_RATING_DOMAIN); ?>[<?php echo esc_attr($post_type); ?>]"  value="1" <?php if( isset( $this->options[$post_type] ) && $this->options[$post_type] == '1' ) echo 'checked'; ?> />
					</p>
				<?php 
					} 
				?>
				
				<p class="submit">
					<input class="button-primary" type="submit" name='save' value='<?php _e('Save Changes') ?>' />
				</p>
			</form>
		</div>
		<?php
	}
	// save
	function admin_save_options() {
		$post_types = wp_list_filter( get_post_types(array('public'=>true)),array('attachment'), 'NOT' );

		$key_array = array();
		foreach ( $post_types as $post_type ) {			
			$key_array[] = $post_type;
		}

		if (isset($_POST['save'])) {
		
			if( check_admin_referer( 'nbcsr-nonce-key', 'nbcsr-key' ) ) {
				if ( !empty($_POST[COMMENT_STAR_RATING_DOMAIN]) ) {
					$options = array();
					foreach ( $_POST[COMMENT_STAR_RATING_DOMAIN] as $key => $value ) {
						if( in_array( $key, $key_array) ){
							$key = $key;
						}else{
							break;
						}
						$value = '1';
						$options += array( $key => $value );
					}
					update_option(COMMENT_STAR_RATING_DOMAIN, $options );
				}
				//wp_safe_redirect( menu_page_url( COMMENT_STAR_RATING_DOMAIN, false ) );
			}
		}
		$this->options = get_option(COMMENT_STAR_RATING_DOMAIN);
		$this->admin_setting_form();
	}
}
$comment_star_rating = new Netbase_Toolkit_Comment_Star_Rating();
$comment_star_rating->init();
