(function ($) {
    $(document).ready(function () {

        /*layout type : fullscreen
        trigger when event close search*/
        $('.edu-fullscreen .edu-search-fs .close').on('click', function () {
            $('.edu-fullscreen .edu-search-fs').hide();
        });

        /*trigger when event open search*/
        $('.edu-fullscreen .search-inner .open').on('click', function () {
            $('.edu-fullscreen .search-inner .search-form').show();

        });

        /*layout type : dropdown*/
        var on_click_dropdown = true;
        $('.edu-dropdown .search-inner .open').on('click', function () {

            if (on_click_dropdown) {

                $('.edu-dropdown').addClass('active-dropdown');
                on_click_dropdown = false;
            }else {

                $('.edu-dropdown').removeClass('active-dropdown');
                on_click_dropdown = true;
            }
        });

        var mouse_is_inside_dropdown = false;
        var mouse_is_inside_dropdown_open = false;

        $('.edu-element-search .edu-search-dropdown .txt-search').hover(function(){
            mouse_is_inside_dropdown = true;
        }, function(){
            mouse_is_inside_dropdown = false;
        });

        $('.edu-dropdown .search-inner .open').hover(function(){
            mouse_is_inside_dropdown_open = true;
        }, function(){
            mouse_is_inside_dropdown_open = false;
        });
        $('body').mouseup(function () {
            if (!mouse_is_inside_dropdown && !mouse_is_inside_dropdown_open) {
                $('.edu-dropdown').removeClass('active-dropdown');
            }
        });


        /*layout type : boxed
        set icon center*/
        var icon = $('.edu-boxed.button-icon .search-inner .open');
        var input_height = $('.edu-boxed .search-form .search-form-inner').height();

        icon.css({
            'top': (input_height - icon.height() - 10)/2
        });


        $('.edu-boxed .search-inner .open').on('click', function () {
            var input_text = '';
            input_text = $('.edu-boxed .edu-search-boxed .txt-search').val();

            if (input_text == '') {
                alert('Please fill out this field');
                return false;
            }else{
                $('.edu-form-search')[0].submit(function () {
                    return true;
                });
            }

        });

        /*layout type : expand-width*/
        var expand_width_active = false;
        var width_input_search;

        width_input_search = $('.edu-expand_width .edu-search-expand_width .txt-search').css('width');

        $('.edu-expand_width .search-inner .open').on('click', function () {

            /*close input*/
            if (expand_width_active) {

                $('.edu-expand_width .edu-search-expand_width .edu-form-search').css('width',width_input_search);
                $('.edu-expand_width .edu-search-expand_width .edu-form-search').animate({
                    width: '0px',
                },500,'swing',function () {

                    $('.edu-expand_width .search-inner .open i').addClass('fa-search');
                    $('.edu-expand_width .search-inner .open i').removeClass('fa-times');
                    $('.edu-expand_width').removeClass('active-expand_width');
                    expand_width_active = false;
                });

            }else {
                $('.edu-expand_width .search-inner .open i').removeClass('fa-search');
                $('.edu-expand_width .search-inner .open i').addClass('fa-times');

                $('.edu-expand_width .edu-search-expand_width .edu-form-search').css('width','0px');

                $('.edu-expand_width .edu-search-expand_width .edu-form-search').animate({
                    width: width_input_search,
                }, 500,'swing',function () {
                    expand_width_active = true;
                });
                $('.edu-expand_width').addClass('active-expand_width');
            }
        });

        var mouse_is_inside_ew = false;
        var mouse_is_inside_ew_open = false;

        $('.edu-expand_width .edu-search-expand_width .txt-search').hover(function(){
            mouse_is_inside_ew = true;
        }, function(){
            mouse_is_inside_ew = false;
        });

        $('.edu-expand_width .search-inner .open').hover(function(){
            mouse_is_inside_ew_open= true;
        }, function(){
            mouse_is_inside_ew_open = false;
        });

        $('body').mouseup(function () {
            if (!mouse_is_inside_ew && !mouse_is_inside_ew_open) {

                $('.edu-expand_width .search-inner .open i').addClass('fa-search');
                $('.edu-expand_width .search-inner .open i').removeClass('fa-times');

                $('.edu-expand_width').removeClass('active-expand_width');
            }
        });

        /*layouttype : topbar*/
        var expand_topbar = true;       

        $('.edu-topbar .search-inner .open').on('click', function () {
            var wpadminbar = $('#wpadminbar');
            var Y = wpadminbar.length ? wpadminbar.height() : '0';

            if (expand_topbar) {
                $('.edu-topbar').addClass('edu-fullscreen');
                $('.edu-topbar .search-inner .search-form').addClass('edu-search-fs');

                $('.edu-topbar .search-inner .search-form').show();

                $('.edu-topbar .search-form .txt-search').css('top', '50%');

                $('.edu-topbar .search-form').css({
                    display: 'block',
                    top: Y + 'px',
                    height: '0px'
                }).animate({
                    top: Y + 'px',
                    height: '80px'
                });

                $('#page').css({
                    position: 'relative',
                    top: '0px'
                }).animate({
                    top: '80px'
                });

                expand_topbar = false;

            }else {

                $('.edu-topbar .search-form').css({
                    heigjt: '80px'
                }).animate({
                    height:'0px'
                }, function () {
                    $('.edu-topbar').removeClass('edu-fullscreen');
                    $('.edu-topbar .search-inner .search-form').removeClass('edu-search-fs');
                    $('.edu-topbar .search-inner .search-form').hide();
                });

                $('#page').css({
                    position: 'relative',
                    top: '80px'
                }).animate({
                    top: '0px'
                });

                expand_topbar = true;
            }


        });
        $('.edu-topbar .search-form .search-form-inner .close').on('click', function () {
            $('.edu-topbar .search-form').css({
                height: '80px'
            }).animate({
                height:'0px'
            }, function () {
                $('.edu-topbar .search-inner .search-form').hide();
            });

            $('#page').css({
                position: 'relative',
                top: '80px'
            }).animate({
                top: '0px'
            });
        });

    });

})(jQuery);