<?php
/*
Plugin Name: Printcart Elements
Plugin URI: http://netbaseteam.com/
Description: WPBakery and Elementor Element
Version: 1.0.0
Author: NBTeam
Author URI: http://themeforest.net/user/netbaseteam
*/

define('NB_ELEMENTS_PATH', plugin_dir_path(__FILE__) );
define('NB_ELEMENTS_URL', plugin_dir_url( __FILE__ ));

require_once( NB_ELEMENTS_PATH . 'inc/third-party/custom-icons-for-elementor/elementor-custom-icons.php' );

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
    require_once( NB_ELEMENTS_PATH . 'customize-options/woocommerce.php' );
}
if ( is_plugin_active( 'web-to-print-online-designer/nbdesigner.php' ) ) {
    require_once( NB_ELEMENTS_PATH . 'customize-options/onlinedesign.php' );
}

/**
 * @return Enqueue Script
 */


function jet_modify_controls( $controls_registry ) {
	// Get existing icons
	$icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );
	// Append new icons
	$new_icons = array_merge(
		array(
            'ico-box-nature' => 'icon nature',
            'ico-box-brithday-cake-with-candl'=>'icon cake',
            'ico-box-love'=>'icon love',
            'ico-box-newlyweds'=>'icon newlyweds',
            'ico-box-forest'=>'icon forest',
            'ico-box-checklist'=>'icon checklist',
            'ico-box-upload'=>'icon upload',
            'ico-box-business'=>'icon business',
            'ico-box-wallet'=>'icon wallet',
            'ico-box-24-hours'=>'icon hours',
            'ico-box-medal'=>'icon medal',
            'ico-box-paper-plane'=>'icon plane',
            'ico-box-phone-call'=>'icon call'

		),
		$icons
	);
	// Then we set a new list of icons as the options of the icon control
	$controls_registry->get_control( 'icon' )->set_settings( 'options', $new_icons );
}
add_action( 'elementor/controls/controls_registered', 'jet_modify_controls', 10, 1 );


function nb_elements_enqueue_scripts() {
    wp_enqueue_style( 'nb_elements', NB_ELEMENTS_URL . 'assets/css/main.css', array(), '20180324' );
    wp_enqueue_script( 'nb_elements', NB_ELEMENTS_URL . 'assets/js/main.js', array( 'jquery' ), '20180324', true );

    wp_enqueue_style( 'icomoon_elements', NB_ELEMENTS_URL . 'assets/css/style.css', array(),true);


    wp_enqueue_style( 'swiper', NB_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.css', array(), '4.2.0');
    wp_enqueue_script( 'swiper',  NB_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.js', array('jquery'), '4.2.0', true);
    

    wp_enqueue_style( 'magnific-popup', NB_ELEMENTS_URL . 'assets/vendors/magnific-popup/magnific-popup.css' );
    wp_enqueue_script( 'magnific-popup', NB_ELEMENTS_URL . 'assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array(), '', false );
}
add_action('wp_enqueue_scripts', 'nb_elements_enqueue_scripts' );

// Register Elemetor Categories
function nb_add_elementor_widget_categories( $elements_manager ) {
    $elements_manager = Elementor\Plugin::instance()->elements_manager;

    $elements_manager->add_category( 'PrintCart', [ 'title' => __( 'PrintCart', 'nb-core' ), 'icon' => 'fa fa-plug', ] );  
}
add_action( 'elementor/elements/categories_registered', 'nb_add_elementor_widget_categories' );    

// Require Element
require_once( NB_ELEMENTS_PATH . 'inc/functions.php' );	
require_once( NB_ELEMENTS_PATH . 'elements/social-media.php' );
require_once( NB_ELEMENTS_PATH . 'elements/blog.php' );
require_once( NB_ELEMENTS_PATH . 'elements/brands-list.php' );
require_once( NB_ELEMENTS_PATH . 'elements/heading.php' );
require_once( NB_ELEMENTS_PATH . 'elements/our-team.php' );
require_once( NB_ELEMENTS_PATH . 'elements/product-online-design.php' );
require_once( NB_ELEMENTS_PATH . 'elements/product-sliders.php' );
require_once( NB_ELEMENTS_PATH . 'elements/template-online-design.php' );
require_once( NB_ELEMENTS_PATH . 'elements/time-line.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-contact-info.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-element-step.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-feature-posts.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-get-to.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-icon-services.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-img-banner.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-instagram.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-intro-images.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-leadership.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-map.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-online-design.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-our-service.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-step.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-video.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-wc-hotdeal.php' );
require_once( NB_ELEMENTS_PATH . 'elements/vc-wc-list-product.php' );
require_once( NB_ELEMENTS_PATH . 'elements/product-tabs.php' );
require_once( NB_ELEMENTS_PATH . 'elements/testimonials.php' );

function nb_element_class() {
    //TODO add apply_filter
    return array(
        'NB_Social_Element',
        'NB_Blog_Element',
        'NB_Brands_Element',
        'NB_Heading_Element',
        'NB_Ourteam_Element',
        'NB_Product_Online_Design_Element',
        'NB_Product_Sliders',
        'NB_Template_Online_Design_Element',
        'NB_Timeline_Element',
        'NB_Contact_Info_Element',
        'NB_Element_Step_Element',
        'NB_Feature_Post_Element',
        'NB_Get_To_Element',
        'NB_Icon_Services_Element',
        'NB_Image_Banner_Element',
        'NB_Instagram_Element',
        'NB_Intro_Images_Element',
        'NB_Leadership_Element',
        'NB_Map_Element',
        'NB_Online_Design_Element',
        'NB_Step_Element',
        'NB_Video_Element',
        'NB_Wc_Hotdeal_Element',
        'NB_Wc_List_Product_Element',
        'NB_Our_Service_Element',
        'NB_Product_Tabs_Element',
        'NB_Testimonial_Element'
    );
}

// Elementor
function nb_elementor() {
    $class_arr = nb_element_class();

    foreach( $class_arr as $class ) {
        $element = new $class();
        $options = $element->options();
        $args = array();

        add_action( 'elementor/widgets/widgets_registered', function() use( $options, $args ) {

            include_once NB_ELEMENTS_PATH . 'inc/class-elementor.php';

            $args['widget_name'] = $options['name'];
            $args['id_control'] = isset( $options['id'] ) ? $options['id'] : 'content_section';
            $args['icon'] = isset( $options['icon'] ) ? $options['icon'] : '';
            $args['title'] = $options['name'];
            $args['category'] = $options['category'];
            $args['option'] = $options['params'];
            
            $elementor = new Create_Element();
            $elementor->init( $args );

            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( $elementor );
        } );
    }
}
nb_elementor();

// WPBakery Map
function nb_wpbakery_map() {
    $class_arr = nb_element_class();

    foreach( $class_arr as $class ) {
        $element = new $class();
        $options = $element->options();

        vc_map( $options );
    }
}
add_action( 'vc_before_init', 'nb_wpbakery_map' );

// WPBakery Shortcode
function nb_wpbakery_shortcode() {
    $class_arr = nb_element_class();

    foreach( $class_arr as $class ) {
        $element = new $class();
        $options = $element->options();

        $base = $options['base'];

        add_shortcode( $base, array( $class, 'content' ) );
    }
}
add_action( 'init', 'nb_wpbakery_shortcode' );

function get_excerpt($content, $num, $short) {        

    // filter_content
    $content = trim(strip_tags($content));
    $content = preg_replace('|[[\\/\\!]*?[^\\[\\]]*?]|si', '', $content);
    $content = preg_replace("/[\r\n]*/","",$content);
    mb_internal_encoding('utf-8');
    $content = str_replace('  ', '', $content);

    $limit = $num - 1 ;
    $str_tmp = '';
    $arrstr = explode(" ", $content);
    if ( count($arrstr) <= $num ) {
        if (strlen($content)>(9*$num))
            return substr($content,0,(9*$num)).$short;
        else
            return $content; 
    }
    if (!empty($arrstr))
    {
        for ( $j=0; $j< count($arrstr) ; $j++)
        {
            $str_tmp .= " " . $arrstr[$j];
            if ($j == $limit)
            {  break; }
        }
    }

    if (strlen($str_tmp)>9*$num)
    {
        return substr($str_tmp,0,9*$num).$short;
    }

    return trim($str_tmp.$short);
}
?>