<?php

class NB_Wc_List_Product_Element {

	public function options() {
		$options = array(
            'name' => esc_html__('List Products', 'nb-element'),
            'base' => 'netbase_element_wc_list_products',
            'category' => esc_html__('PrintCart', 'nb-element'),
            
            "params" => array(
                array(
                    'type'      => 'textfield',
                    'heading'     => esc_html__( 'Block title', 'nb-element' ),
                    'param_name'  => 'title',
                    'admin_label'   => true,
                    'value'     => '',
                    'description'   => ''
                ),
                array(
                    'heading'     => __( 'Background Image', 'nb-element' ),
                    'param_name'  => 'background_img',
                    'type'        => 'attach_image',
                ),
                array(
                    'type'      => 'dropdown',
                    'heading'     => esc_html__( 'Product type', 'nb-element' ),
                    'param_name'  => 'product_type',
                    'admin_label'   => true,
                    'value'     => array(
                        esc_html__('Recent', 'nb-element')    => 'recent',
                        esc_html__('Featured', 'nb-element')  => 'featured',
                        esc_html__('Best Selling', 'nb-element')  => 'best_selling',
                        esc_html__('Top Rated', 'nb-element') => 'top_rated',
                        esc_html__('Mixed Order', 'nb-element') => 'mixed_order'
                    ),
                    'description'   => esc_html__( 'Select type of product', 'nb-element' )
                ),
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Per page', 'nb-element' ),
                    'value' => 8,
                    'save_always' => true,
                    'param_name' => 'per_page',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'description' => __( 'The "per_page" shortcode determines how many posts to show on the page', 'nb-element' ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Columns', 'nb-element' ),
                    'value' => array(
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4',
                    ),
                    'std' => '4',
                    'param_name' => 'columns',
                    'save_always' => true,
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                
                array(
                    'type'      => 'dropdown',
                    'heading'     => esc_html__( 'Box Align', 'nb-element' ),
                    'param_name'  => 'box_align',
                    'admin_label'   => true,
                    'value'     => array(
                        esc_html__('Left', 'nb-element')    => 'text-left',
                        esc_html__('Center', 'nb-element')  => 'text-center',
                        esc_html__('Right', 'nb-element') => 'text-right',
                    ),

                ),

            )
        );

        return $options;
    }

    public static function content( $atts ) {
      extract(shortcode_atts(
            array(
                'title'                 => '',
                'background_img' => '',
                'product_type'          => 'recent',
                'per_page'              => 8,
                'columns'               => 4,
                'box_align' =>'text-left',
            ), $atts, 'nb_product_hotdeals'
        ));

        if ( !class_exists('WooCommerce') ){
            return;
        }
        $bg_image_style = '';
        
        if ( $background_img ) {
            $bg_image      = wp_get_attachment_image_src($background_img, 'full');
            $bg_image_style = "style='background: url(" . esc_url( $bg_image[0] ) . ")  center/cover no-repeat'";
        }
        $per_page = absint($per_page);

        $args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => $per_page,
        );
        switch ($columns){
            case '1':
                $columns_class = '';
                break;
            case '2':
                $columns_class = 'two-columns';
                break;
            case '3':
                $columns_class = 'three-columns';
                break;
            case '4':
                $columns_class = 'four-columns';
                break;
            default:
                $columns_class ='four-columns';
                break;
        }
        switch( $product_type ){
            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
                break;
            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
                break;
            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
                break;
            case 'top_rated':
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
                break;
            case 'mixed_order':
                $args['orderby']    = 'rand';
                break;
            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
                break;
        }

        ob_start();
        global $woocommerce_loop, $post, $product;

        $products = new WP_Query( $args );

        if( $products->have_posts() ) {
            echo '<div class="shop-main '.$columns_class.' ">';
            echo '<div class="products row grid-type">';
            while( $products->have_posts() ){

                $products->the_post();
                wc_get_template_part( 'content', 'product' );
            }
            echo '</div>';
            echo '</div>';
        }

        wp_reset_postdata();

        return '<div class="nb-fw list_products woocommerce" ' . $bg_image_style . '>' . ob_get_clean() . '</div>';
  }
}
