<?php

class NB_Our_Service_Element {

	public function options() {

        $terms = get_terms( array(
                'hide_empty' => false,
            ) );            
            $new_option = array();

            if ( $terms ) {
                foreach( $terms as $key => $term ) {
                    if ( $term->taxonomy == 'product_cat' ) {
                        if ( is_object( $term ) ) {
                            $new_option[$term->name] = $term->term_id;
                        }
                    }
                }
            }

		$options = array(
                "name" => __( "Services", "printshop" ),
                "base" => "vc_printshop_our_services",
                "class" => "",
                "category" => __( "PrintCart", "printshop"),
                "params" => array(        
                    array(
                        'type' => 'param_group',
                        'value' => '',
                        'heading' => __('Categories', 'nb-fw'),
                        'param_name' => 'add_vc_our_services_category',
                        'group' => __('Content Options', 'nb-fw'),
                        // Note params is mapped inside param-group:
                        'params' => array(
                            array(
                                'type' => 'dropdown',
                                'heading' => __('Thumbnail size', 'nb-fw'),
                                'param_name' => 'add_vc_our_services_category',
                                'group' => __('Content Options', 'nb-fw'),
                                'value' => $new_option,
                                'std' => '4-3',
                                'save_always' => true,
                                'dependency' => array(
                                    'element' => 'layout',
                                    'value_not_equal_to' => 'wp-list',
                                ),
                            )
                        )
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        'group' => __('Content Options', 'nb-fw'),
                        "class" => "",
                        "heading" => __( "Limit", "printshop" ),
                        "param_name" => "add_vc_our_services_limit",
                        "value" => 4,
                    )
                )
            );

        return $options;
    }

    public static function content( $atts ) {
      extract( shortcode_atts( array(
                'add_vc_our_services_category' => array(),
                'add_vc_our_services_limit' => 4
            ), $atts ) );

            if ( did_action( 'elementor/loaded' ) ) {
                $services_category = $atts['add_vc_our_services_category'];
            }
            else {
                $services_category = vc_param_group_parse_atts( $atts['add_vc_our_services_category'] );
            }
            if( count($services_category) ) {
                ob_start();
                $col = 100 / count($services_category);
                $style = 'max-width: '. absint($col) .'%;flex: 0 0 '. absint($col) .'%;';

                ?>
                <div class="vc-printshop-ourservices">
                    <div class="container">
                        <div class="row">
                            <?php foreach ($services_category as $key => $cat) {
                                $term_id = $cat['add_vc_our_services_category'];
                                $category = get_term_by('term_id', $term_id, 'product_cat');
                                $thumbnail_id = get_woocommerce_term_meta( $term_id, 'thumbnail_id', true );
                                $image = wp_get_attachment_url( $thumbnail_id );

                                if( !empty($category) ) {
                                    ?>
                                    <div class="our-services-box" style="<?php echo $style;?>">
                                        <div class="our-services-child">
                                            <a href="<?php echo get_term_link($category, 'product_cat'); ?>"><img src="<?php echo $image; ?>" alt="<?php echo esc_attr( $category->name ); ?>" /></a>
                                            <div class="left-our-services">
                                                <h4><a href="<?php echo get_term_link($category, 'product_cat');?>"><?php echo esc_attr( $category->name );?></a></h4>
                                                <p><?php echo esc_attr( $category->description );?></p>
                                            </div>
                                        </div>
                                    </div>
                                <?php }
                            }?>
                        </div>
                    </div>
                </div>
                <?php
            }
            
            return ob_get_clean();
    }
}
