<?php

class NB_Online_Design_Element {

	public function options() {
		$options = array(
            "name" => __( "Online Designer", "printshop" ),
            "base" => "vc_printshop_online_desginer",
            "class" => "",
            "category" => __( "PrintCart", "printshop"),
            "params" => array(        
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    'group' => __('Content Options', 'nb-fw'),
                    "class" => "",
                    "heading" => __( "Limit", "printshop" ),
                    "param_name" => "add_vc_our_services_limit",
                    "value" => 4,
                ),
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'group' => __('Content Options', 'nb-fw'),
                    'heading' => esc_html__('Enable Title', 'printshop'),
                    'param_name' => 'enable_title',
                    'std' => true,
                ),
                array(
                    'param_name'  => 'columns',
                    'heading'     => esc_html__( 'Number of columns displayed', 'nb-elements' ),
                    'type'        => 'dropdown',
                    'group' => __('Content Options', 'nb-fw'),
                    'value'       => array(
                        __( '1 column', 'nb-elements' )  => '1',
                        __( '2 columns', 'nb-elements' ) => '2',
                        __( '3 columns', 'nb-elements' ) => '3',
                        __( '4 columns', 'nb-elements' ) => '4',
                        __( '6 columns', 'nb-elements' ) => '6',

                    ),
                    'std'         => '3',
                    'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                array(
                  "type" => "textarea",
                  "heading" => __( "Description", 'nb-elements' ),
                  "param_name" => "description_online_design",
                  "value" => __( "", 'nb-elements' ),
                  "description" => __( "Enter description.", 'nb-elements'),
              ),
            )
        );

        return $options;
    }

    public static function content( $atts ) {
      global $post;
      extract( shortcode_atts( array(
        'add_vc_our_services_limit' => 10,
        'enable_title' => true,
        'columns' =>'3',
        'description_online_design' =>'',
    ), $atts ) );

      ob_start();
      $args = array(
        'posts_per_page'    => $add_vc_our_services_limit,
        'post_type' => 'product',
        'meta_query'    => array(
            array(
                'key'       => '_nbdesigner_enable',
                'value'     => true
            ),
        ),
    );
      $class_columns ='';
      switch ($columns){
        case '1':
        $class_columns= 'col-md-12';
        break;
        case '2':
        $class_columns= 'col-md-6';
        break;
        case '3':
        $class_columns= 'col-md-4';
        break;
        case '4':
        $class_columns= 'col-md-3';
        break;
        case '6':
        $class_columns= 'col-md-2';
        break;
        default:
        $class_columns ='col-md-4';
    }

            // The Query
    $the_query = new WP_Query( $args );

            // The Loop
    if ( $the_query->have_posts() ) {?>
        <div class="vc-online-desginer">
            <ul>
                <?php
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();

                    if ( has_post_thumbnail() ) {
                        echo '<li class="'.$class_columns.'">';
                        echo '<div class="pr">';
                        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'online-desginer' );
                        if ( ! empty( $large_image_url[0] ) ) {
                            echo '<img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/>';
                        }
                        $url = '';
                        if ( is_plugin_active('web-to-print-online-designer/nbdesigner.php') ) {
                            $url =  add_query_arg(array('product_id'    =>  $post->ID),  getUrlPageNBD('create'));
                        }
                        ?>

                        <div class="vc-online-desginer-detail">
                            <div class="links-wrap">

                                <a href="<?php echo esc_url( $url );?>">
                                    <?php if ( $enable_title ) { ?>
                                        <h4><?php echo $post->post_title;?></h4>
                                    <?php } ?>
                                    <h6>Start Desgin</h6>
                                </a>
                            </div>
                        </div></div>

                    </li>
                    <?php
                }
            }
            ?>
        </ul>
    </div>
    <?php
    wp_reset_postdata();
}
return ob_get_clean();
}
}
