<?php

class NB_Leadership_Element {

	public function options() {
		$options = array(
        "name" => __( "Leadership Team", "printshop" ),
        "base" => "vc_printshop_leadership",
        "class" => "",
        "category" => __( "PrintCart", "printshop"),
        "params" => array(
          array(
            'type' => 'param_group',
            'value' => '',
            'heading' => __('Lists', 'nb-fw'),
            'param_name' => 'add_vc_leadership_lists',
            'group' => __('Content Options', 'nb-fw'),
            // Note params is mapped inside param-group:
            'params' => array(
              array(
                "type" => "attach_image",
                'group' => __('Content Options', 'nb-fw'),
                "heading" => __( "Avatar", "printshop" ),
                "param_name" => "add_vc_leadership_avatar",
                "value" => '',
              )
            )
          ),
          array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __( "Limit", "printshop" ),
            "param_name" => "vc_tab_product_limit",
            "value" => 8,
          )
        )
     );

        return $options;
    }

    public static function content( $atts ) {
      extract( shortcode_atts( array(
        'vc_tab_product_limit' => 8
      ), $atts ) );
    
    
      ob_start();
      if ( did_action( 'elementor/loaded' ) ) {
                $add_vc_leadership_lists = $atts['add_vc_leadership_lists'];
            }
            else {
                $add_vc_leadership_lists = ( array ) vc_param_group_parse_atts( $atts['add_vc_leadership_lists'] );
            }
      if($add_vc_leadership_lists) {
      ?>
      <div class="vc-leadership vc-getto-info">
          <div class="vc-getto-para">
            <h2 class="vc-heading-title">The Leadership Team</h2>
            <p>Meet our leadership team – the senior brains behind the brand. Each member of our top team are united by a love of print and great design.</p>
          </div>
    
          <div class="vc-leadership-lists">
            <?php foreach ($add_vc_leadership_lists as $key => $feature) {
                
                 if ( did_action( 'elementor/loaded' ) ) {
                      $feature_link = $feature['add_vc_leadership_avatar']['url'];
                  }
                  else {
                    $feature_thumb = wp_get_attachment_image_src($feature['add_vc_leadership_avatar'], 'full');
                    $feature_link = $feature_thumb[0];
                  }
                ?>
                <div class="vc-leadership-item">
                  <div class="vc-leadership-wrap">
                      <img src="<?php echo esc_url( $feature_link ); ?>" />
                      <div class="vc-leadership-overlay">
                        <div class="vc-leadership-overlay-wrap">
                            <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.</p>
                            <div class="vc-leadership-social">
                              <a href="#"><i class="icon-facebook"></i></a>
                              <a href="#"><i class="icon-linkedin2"></i></a>
                              <a href="#"><i class="icon-twitter"></i></a>
                            </div>
                        </div>
    
                
                      </div>
                      <div class="vc-leadership-info">
                        <h4>Philip Demarco</h4>
                        <p>Business Analyst</p>
                      </div>
                  </div>
    
    
    
                </div>
                <?php
            }?>
          </div>
      </div>
      <?php
      }
      
      return ob_get_clean();
  }
}
