<?php

class NB_Icon_Services_Element {

	public function options() {
		$options = array(
			'name' => esc_html__('Services Icon', 'nb-elements'),
			'base' => 'netbase_icon_services',
			'category' => esc_html__('PrintCart', 'nb-elements'),
			'description' => esc_html__('Display Services Icon.', 'nb-elements'),

			'params' => array(
				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Title', 'nb-elements'),
					'param_name' => 'title_text',
					'value' => '',
				),

				array(
					'param_name'       => 'style',
					'heading'          => esc_html__( 'Style', 'nb-elements' ),
					'type'             => 'dropdown',
					'edit_field_class' => 'vc_col-sm-6 mgt15',                        
					'value'            => array(     
						__( 'Icon none', 'nb-elements' )      => 'none',                       
						__( 'Icon', 'nb-elements' )      => 'icon',
						__( 'Image', 'nb-elements' )     => 'image',
					),
				),
				array(
					'param_name'       => 'align',
					'heading'          => esc_html__( 'Box Alignment', 'nb-elements' ),
					'type'             => 'dropdown',
					'edit_field_class' => 'vc_col-sm-6',                        
					'value'            => array(
						__( 'Left', 'nb-elements' )   => 'left',
						__( 'Center', 'nb-elements' ) => 'center',
						__( 'Right', 'nb-elements' )  => 'right',
					),
				),
				array(
					'param_name' => 'content_box',
					'heading'    => esc_html__( 'Content', 'nb-elements' ),
					'type'       => 'textarea',                        
					'holder'     => 'p'
				),
				array(
					'param_name' => 'text_color',
					'heading'    => esc_html__( 'Title Color', 'nb-elements' ),
					'type'       => 'colorpicker',
					'edit_field_class' => 'vc_col-sm-6', 
				),
				array(
					'param_name' => 'txtcontent_color',
					'heading'    => esc_html__( 'Text Color', 'nb-elements' ),
					'type'       => 'colorpicker',
					'edit_field_class' => 'vc_col-sm-6', 
				),

				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Icon Width', 'nb-elements'),
					'param_name' => 'icon_width',
					'value' => '',
					'edit_field_class' => 'vc_col-sm-6', 
				),
				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Icon Height', 'nb-elements'),
					'param_name' => 'icon_height',
					'value' => '',
					'edit_field_class' => 'vc_col-sm-6', 
				),

				array(
					'type' => 'textfield',
					'admin_label' => true,
					'heading' => esc_html__('Font size Title', 'nb-elements'),
					'param_name' => 'font_size_title',
					'value' => '',
					'edit_field_class' => 'vc_col-sm-6',
					'description'=> 'Example: 20px',
				),

				array(
					'param_name'       => 'style_border',
					'heading'          => esc_html__( 'Style Border Icon', 'nb-elements' ),
					'type'             => 'dropdown',
					'edit_field_class' => 'vc_col-sm-6',                        
					'value'            => array(
						__( 'None', 'nb-elements' )   => 'none',
						__( 'Solid', 'nb-elements' ) => 'solid',
						__( 'Dotted', 'nb-elements' )  => 'dotted',
						__( 'Dashed', 'nb-elements' )  => 'dashed',
					),
				),

				array(
					'param_name' => 'title_font_primary',
					'heading'    => esc_html__( 'Title Font Primary', 'nb-elements' ),
					'type'       => 'checkbox',
					'edit_field_class' => 'vc_col-sm-6', 
				),
				array(
					'param_name' => 'read_more',
					'heading'    => esc_html__( 'Enable Read More?', 'nb-elements' ),
					'type'       => 'checkbox',

				),
				array(
					'param_name' => 'read_more_link',
					'heading'    => esc_html__( 'Read more link', 'nb-elements' ),
					'type'       => 'textfield',                        
					'dependency' => array(
						'element' => 'read_more',
						'value'   => 'true',
					),
				),
				array(
					'param_name' => 'icon_position',
					'heading'    => esc_html__( 'Icon Position', 'nb-elements' ),
					'type'       => 'dropdown',                        
					'value'      => array(
						__( 'Top', 'nb-elements' )   => 'top',
						__( 'Left', 'nb-elements' )  => 'left',
						__( 'Right', 'nb-elements' )  => 'right',
					),

					'edit_field_class' => 'vc_col-sm-4 vc_column',
				),

				array(
					'param_name'  => 'icon_fontawesome',
					'heading'     => esc_html__( 'Icon', 'nb-elements' ),
					'description' => esc_html__( 'Select icon from library.', 'nb-elements' ),
					'type'        => 'iconpicker',
					'group'       => esc_html__( 'Icon Settings', 'nb-elements' ),
					'value'       => 'fa fa-adjust',
					'settings'    => array(
						'emptyIcon'    => false,
						'iconsPerPage' => 4000,
					),
					'dependency'  => array(
						'element' => 'style',
						'value'   => 'icon',
					),
				),
				array(
					'param_name' => 'icon_color',
					'heading'    => esc_html__( 'Icon color', 'nb-elements' ),
					'type'       => 'colorpicker',
					'group'      => esc_html__( 'Icon Settings', 'nb-elements' ),
					'value'      => '#ff4064',
					'dependency' => array(
						'element' => 'style',
						'value'   => 'icon',
					),
				),
				array(
					'param_name' => 'bgicon_color',
					'heading'    => esc_html__( 'Background Icon color', 'nb-elements' ),
					'type'       => 'colorpicker',
					'group'      => esc_html__( 'Icon Settings', 'nb-elements' ),
					'value'      => '#fff',
					'dependency' => array(
						'element' => 'style',
						'value'   => 'icon',
					),
				),

				array(
					'param_name' => 'icon_style',
					'heading'    => esc_html__( 'Icon Box Style', 'nb-elements' ),
					'type'       => 'dropdown',
					'group'      => esc_html__( 'Icon Settings', 'nb-elements' ),
					'value'      => array(
						esc_html__('Select', 'nb-elements') => '',                        
						esc_html__('Circle', 'nb-elements') => 'circle',
						esc_html__('Square', 'nb-elements') => 'square',

					),
					'dependency' => array(
						'element' => 'style',
						'value'   => 'icon',
					),
					'edit_field_class' => 'vc_col-sm-4 vc_column',
				),
				array(
					'param_name' => 'icon_hover_color',
					'heading'    => esc_html__( 'Icon Hover Color', 'nb-elements' ),
					'type'       => 'colorpicker',
					'group'      => esc_html__( 'Icon Settings', 'nb-elements' ),
					'dependency' => array(
						'element' => 'style',
						'value'   => 'icon',
					),
				),
				array(
					'param_name' => 'icon_size',
					'heading'    => esc_html__( 'Icon Size (px)', 'nb-elements' ),
					'type'       => 'textfield',
					'group'      => esc_html__( 'Icon Settings', 'nb-elements' ),
					'value'      => 24,
					'dependency' => array(
						'element' => 'style',
						'value'   => 'icon',
					),
				),
				array(
					'param_name' => 'graphic',
					'heading'    => esc_html__( 'Upload Image', 'nb-elements' ),
					'type'       => 'attach_image',
					'group'      => esc_html__( 'Image Settings', 'nb-elements' ),
					'dependency' => array(
						'element' => 'style',
						'value'   => 'image',
					),
				),
				array(
					'param_name' => 'image_radius',
					'heading'    => esc_html__( 'Border Radius (px)', 'nb-elements' ),
					'type'       => 'textfield',
					'group'      => esc_html__( 'Image Settings', 'nb-elements' ),
					'value'      => 0,
					'dependency' => array(
						'element' => 'style',
						'value'   => 'image',
					),
				),
				array(
					'param_name' => 'primary_text',
					'heading'    => esc_html__( 'Primary Text', 'nb-elements' ),
					'type'       => 'textfield',
					'group'      => esc_html__( 'Icon None Settings', 'nb-elements' ),
					'value'      => '',
					'dependency' => array(
						'element' => 'style',
						'value'   => 'none',
					),
				),


				array(
					'heading'    => __( 'Extra class name', 'nb-elements' ),
					'param_name' => 'extra_class',
					'type'       => 'textfield',
					'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
					'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
				),
				array(
					'heading'    => __( 'Custom id name', 'nb-elements' ),
					'param_name' => 'custom_id',
					'type'       => 'textfield',
					'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
					'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
				),
				array(
					'type' => 'css_editor',
					'heading' => __( 'Css', 'nb-elements' ),
					'param_name' => 'css',
					'group' => __( 'Design options', 'nb-elements' ),
				)
			)
);

return $options;
}

public static function content( $atts ) {
	$html = $txtcolor = $class = $classtitle = $css_custom= $txtcontentcolor = $customcolumn ='';

        // Extract shortcode parameters.
	extract(
		shortcode_atts(
			array(
				'title_text' => '',
				'style'                   => 'none',
				'align'                   => 'left',
				'style_border'            => 'none',
				'content_box'             => '',
				'icon_position'           => 'top',
				'text_color'              => '#333333',
				'txtcontent_color'        => '',
				'bgicon_color' => '#fff',
				'icon_style' => 'square',
				'read_more'               => '',
				'title_font_primary'      => '',
				'read_more_link'          => '',
				'icon_fontawesome'        => 'fa fa-adjust',
				'icon_color'              => '#d6aa74',
				'icon_hover_color'        => '',
				'icon_size'               => 24,
				'graphic'                 => '',
				'image_radius'            => 0,
				'icon_width' => '',
				'icon_height' => '',
				'font_size_title' =>'',
				'css' => '',
				'primary_text' => ''
			),
			$atts
		)
	);

        // Generate custom ID
	$id = uniqid('nb_fw_services_');       

	if($align == 'center'){
		$class .='text-center';
	}elseif($align == 'left'){
		$class .='text-left';
	}else{
		$class .='text-right';
	}

	if($icon_position !=''){
		$class .=' icon-position-'.$icon_position.'';
	}
	else{
		$class .=' icon-position-top';
	}

	if($icon_style == 'circle'){
		$class .=' svicon-circle';
	}

	if(isset($style_border) && $style_border !='none'){
		$class .=' border-'.$style_border;
	}

	if($icon_width !=''){
		$css_custom .= 'width:' . ( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).';' ;
		if($icon_position == 'left'){
			$customcolumn .=' width: calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');';
			$customcolumn .=' width: -webkit-calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');';
			$customcolumn .=' width: -moz-calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');' ;
		}
	}else{
		if($icon_position == 'left'){
			$customcolumn .=' width: calc(100% - 50px); width: -webkit-calc(100% - 50px); width: -moz-calc(100% - 50px);';

		}
	}
	if($icon_height !=''){
		$css_custom .= 'height:' . ( is_numeric( trim( $icon_height ) ) ? trim( $icon_height ) . 'px' : trim( $icon_height ) ).';' ;
	}

	if ( $icon_size != '' ) {
		$css_custom .= 'font-size:' . ( is_numeric( trim( $icon_size ) ) ? trim( $icon_size ) . 'px' : trim( $icon_size ) ).';' ;
	}
	if($icon_color){
		$css_custom .='color: ' . esc_attr( $icon_color ).';' ;
	}
	if($bgicon_color){
		$css_custom .='background-color: ' . esc_attr( $bgicon_color ).';' ;
	}

	if ( $css_custom ) {
		$css_custom = ' style="' . $css_custom . '"';
	}
	if($customcolumn){
		$customcolumn =' style="' . $customcolumn . '"';
	}

	if($font_size_title){
		$sizepx = substr($font_size_title, -2,2);
		if($sizepx == 'px'){
			$txtcolor .='font-size:'. $font_size_title.';';
		}

	}
	if($text_color){
		$txtcolor .='color:'. esc_attr($text_color ).';';
	}
	if($txtcolor){
		$txtcolor =' style="' . $txtcolor . '"';
	}

	if($title_font_primary){
		$classtitle .=' font-h1';
	}
	if($txtcontent_color){
		$txtcontentcolor .='color:'. esc_attr($txtcontent_color ).';';
	}
	if($txtcontentcolor){
		$txtcontentcolor =' style="' . $txtcontentcolor . '"';
	}

        // Generate HTML code.

	$html .= '<div id="' . esc_attr($id) . '" class="nb-fw services '. esc_html($class) .'"  >';

	if ( 'icon' == $style ) {            
		$html .= '<div class="svicon-font" '.$css_custom.'><span class="' . esc_attr( $icon_fontawesome ) .'" ></span></div>';
	} elseif ( $style == 'image' ) {
		if ( ! empty( $graphic ) ) {
                // Get image link and image data
			if ( did_action( 'elementor/loaded' ) ) {
				$image_link = $graphic['url'];
			} else {
				$image = wpb_getImageBySize( array( 'attach_id' => preg_replace( '/[^\d]/', '', $graphic ) ) );
				$image_link = ['p_img_large'][0];
			}

			$html .= '<div class="image-icon"><img src="' . esc_url( $image_link ) . '" alt="' . esc_attr__( 'Separator', 'nb-elements' ) . '" /></div>';
		}
	}
	$html .= '<div class="content" '.$customcolumn.'>';
	$html .= '<h4 class="service-title '. esc_html($classtitle) .'" '. $txtcolor .'>' . wp_kses_post( $title_text ) . '</h4>';
	if ( 'none' == $style && $primary_text!='' ) {
		$html .= '<div class="service_box_primary_txt">'.wp_kses_post($primary_text).'</div>';
	}
	if($content_box) {
		$html .= '<div class="sv-content-box" '. $txtcontentcolor .'>' . wp_kses_post( $content_box ) . '</div>';
	}

	if ( 'true' == $read_more ) {
		$html .= '<a class="more" href="' . esc_url( $read_more_link ) . '">' . __( 'Read more', 'nb-elements' ) . '</a>';
	}
	$html .= '</div>';
	$html .= '</div>';

	wp_reset_postdata();

	return apply_filters('netbase_shortcode_icon_services', $html );
}
}
