<?php

class NB_Get_To_Element {

	public function options() {
		$options = array(
            "name" => __( "Get to Know", "printshop" ),
            "base" => "vc_printshop_get_to",
            "class" => "",
            "category" => __( "PrintCart", "printshop"),
            "params" => array(
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "class" => "",
                    "heading" => __( "Title", "printshop" ),
                    "param_name" => "vc_tab_title_post",
                    "value" => 8,
                ),
                array(
                    "type" => "textarea",
                    "heading" => __( "Description", 'printshop' ),
                    "param_name" => "description_post",
                    "value" => __( "", 'printshop' ),
                    "description" => __( "Enter description.", 'printshop'),
                ),
                array(
                    'type' => 'param_group',
                    'value' => '',
                    'heading' => __('Lists', 'nb-fw'),
                    'param_name' => 'add_vc_getto_lists',
                    'group' => __('Content Options', 'nb-fw'),
                        // Note params is mapped inside param-group:
                    'params' => array(
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Icon", "printshop" ),
                            "param_name" => "add_vc_get_to_icon",
                            "value" => '',
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Heading", "printshop" ),
                            "param_name" => "add_vc_get_to_heading",
                            "value" => '',
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Label", "printshop" ),
                            "param_name" => "add_vc_get_to_label",
                            "value" => '',
                        )
                    )
                ),
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "class" => "",
                    "heading" => __( "Limit", "printshop" ),
                    "param_name" => "vc_tab_product_limit",
                    "value" => 8,
                )
            )
        );
		
		return $options;
	}

	public static function content( $atts ) {
		 extract( shortcode_atts( array(
                'vc_tab_title_post' => '',
                'description_post' => '',
                'vc_tab_product_limit' => 8
            ), $atts ) );


            ob_start();
            if ( did_action( 'elementor/loaded' ) ) {
                $add_vc_getto_lists = $atts['add_vc_getto_lists'];
            }
            else {
                $add_vc_getto_lists = ( array ) vc_param_group_parse_atts( $atts['add_vc_getto_lists'] );
            }
            
            if( $add_vc_getto_lists ) {
                ?>
                <div class="vc-getto-info">
                    <div class="vc-getto-para">
                        <h2 class="vc-heading-title"><?php echo $vc_tab_title_post; ?></h2>
                        <?php echo $description_post; ?>
                    </div>

                    <ul>
                        <?php
                        foreach ($add_vc_getto_lists as $key => $value) {?>
                            <li>
                                <div class="vc-getto-icon"><i class="<?php echo esc_attr($value['add_vc_get_to_icon']);?>"></i></div>
                                <div class="cinfo-lists">
                                    <h2><?php echo esc_attr($value['add_vc_get_to_heading']);?></h2>
                                    <h4 class="cinfo-description"><?php echo $value['add_vc_get_to_label'];?></h4>
                                </div>
                            </li>
                            <?php
                        } ?>
                    </ul>
                </div>
                <?php
            }
            
            return ob_get_clean();
    }
}
