<?php

class NB_Element_Step_Element {

	public function options() {
		$options = array(
                "name" => __( "Step Element", "printshop" ),
                "base" => "vc_printshop_step",
                "class" => "",
                "category" => __( "PrintCart", "printshop"),
          
                "params" => array(
                  array(
                      'type' => 'param_group',
                      'value' => '',
                      'heading' => __('Step', 'nb-fw'),
                      'param_name' => 'add_vc_step_lists',
                      'group' => __('Content Options', 'nb-fw'),
                      // Note params is mapped inside param-group:
                      'params' => array(
                         array(
                            "type" => "textfield",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Icon", "printshop" ),
                            "param_name" => "add_vc_step_icon",
                            "value" => '',
                        ),
                         array(
                            "type" => "textfield",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Label", "printshop" ),
                            "param_name" => "add_vc_step_label",
                            "value" => '',
                        ), 
                         array(
                            "type" => "textarea",
                            "holder" => "div",
                            'group' => __('Content Options', 'nb-fw'),
                            "class" => "",
                            "heading" => __( "Description", "printshop" ),
                            "param_name" => "add_vc_step_description",
                            "value" => '',
                        ),
                      )
                   )
                )
            );
		
		return $options;
	}

	public static function content( $atts ) {
		extract( shortcode_atts( array(
                'vc_tab_product_limit' => 8
            ), $atts ) );
        
        
            ob_start();

            if ( did_action( 'elementor/loaded' ) ) {
                $add_vc_step_lists = $atts['add_vc_step_lists'];
            }
            else {
                $add_vc_step_lists = ( array ) vc_param_group_parse_atts( $atts['add_vc_step_lists'] );
            }
            
            if( $add_vc_step_lists) {
        
            ?>
            <div class="vc-printshop-step">
                <div class="container">
                    <div class="vc-printshop-step-wrapper">
                        <div class="vc-printshop-step-image"></div>
                        <div class="vc-printshop-step-content">
                        <ul>
                            <?php foreach ($add_vc_step_lists as $key => $step) {?>
                            <li>
                                <div class="ib-shape"><div class="icon"> <i class="<?php echo esc_attr($step['add_vc_step_icon']);?>"></i></div></div>
                                <div class="ib-content">
                                    <h4><?php echo esc_attr($step['add_vc_step_label']);?></h4>
                                    <p><?php echo esc_attr($step['add_vc_step_description']);?></p>
                                </div>
                            </li>
                            <?php }?>
                        </ul>
                        </div>
                    </div>
                </div>
        
            </div>
            <?php
            }
            
            return ob_get_clean();
	}
}
