<?php

class NB_Contact_Info_Element {

	public function options() {
		$options = array(
                "name" => __( "Contact Info Element", "printshop" ),
                "base" => "vc_printshop_cinfo",
                "class" => "",
                "category" => __( "PrintCart", "printshop"),
                "params" => array(
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __( "Title", "printshop" ),
                        "param_name" => "vc_tab_title_post",
                        "value" => 8,
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => __( "Description", 'printshop' ),
                        "param_name" => "description_post",
                        "value" => __( "", 'printshop' ),
                        "description" => __( "Enter description.", 'printshop'),
                    ),
                    array(
                        'type' => 'param_group',
                        'value' => '',
                        'heading' => __('Info', 'nb-fw'),
                        'param_name' => 'add_vc_cinfo_lists',
                        'group' => __('Content Options', 'nb-fw'),
                      // Note params is mapped inside param-group:
                        'params' => array(
                            array(
                                "type" => "textfield",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-fw'),
                                "class" => "",
                                "heading" => __( "Icon", "printshop" ),
                                "param_name" => "add_vc_cinfo_icon",
                                "value" => '',
                            ),
                            array(
                                "type" => "textfield",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-fw'),
                                "class" => "",
                                "heading" => __( "Label", "printshop" ),
                                "param_name" => "add_vc_cinfo_label",
                                "value" => '',
                            ),
                            array(
                                "type" => "textarea",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-fw'),
                                "class" => "",
                                "heading" => __( "Description", "printshop" ),
                                "param_name" => "add_vc_cinfo_description",
                                "value" => '',
                            ),
                        )
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __( "Limit", "printshop" ),
                        "param_name" => "vc_tab_product_limit",
                        "value" => 8,
                    )
                )
            );
		
		return $options;
	}

	public static function content( $atts ) {
		extract( shortcode_atts( array(
                'vc_tab_title_post' => '',
                'description_post' => '',
                'add_vc_cinfo_lists' =>'',
                'vc_tab_product_limit' => 8
            ), $atts ) );
        
        
            ob_start();
            if ( did_action( 'elementor/loaded' ) ) {
                $add_vc_cinfo_lists = $add_vc_cinfo_lists;
            }
            else {
                $add_vc_cinfo_lists = ( array ) vc_param_group_parse_atts( $add_vc_cinfo_lists );
            }
            
            if($add_vc_cinfo_lists) {
            ?>
            <div class="vc-pcontact-info">
            <div class="vc-pcontact-para">
                <h3><?php echo $vc_tab_title_post; ?></h3>
                <?php echo $description_post; ?>
            </div>
        
            <ul>
                <?php
                foreach ($add_vc_cinfo_lists as $key => $value) {?>
                    <li>
                        <i class="<?php echo esc_attr($value['add_vc_cinfo_icon']);?>"></i>
                        <div class="cinfo-lists">
                        <h5><?php echo esc_attr($value['add_vc_cinfo_label']);?></h5>
                        <div class="cinfo-description"><?php echo $value['add_vc_cinfo_description'];?></div>
                        </div>
                    </li>
                    <?php
                } ?>
            </ul>
            </div>
            <?php
            }
            
            return ob_get_clean();
	}
}
