<?php

class NB_Template_Online_Design_Element {

	public function options() {
		$options = array(
        'name' => esc_html__('Template Online Design', 'printshop'),
        'base' => 'netbase_template_online_design',
        'category' => esc_html__('PrintCart', 'printshop'),
        'description' => esc_html__('Display template online design.', 'printshop'),
        'icon' => 'icon-wpb-wp',
        'params' => array(
          array(
            'type' => 'textfield',
            "edit_field_class" => "vc_col-xs-6 vc_column",
            'admin_label' => true,
            'heading' => esc_html__('Limit number template display', 'printshop'),
            'param_name' => 'num_template_design',
            'value' => '4',
          ),
          array(
            "type" => "dropdown",
            "holder" => "",
            "class" => "vc_accordion_cq",
            "heading" => __("Select display template style", "vc_accordion_cq"),
            "param_name" => "accordionstyle",
            "value" => array(__("style 1", "vc_accordion_cq") => "style1", __("style 2", "vc_accordion_cq") => "style2"),
            "description" => __("", "vc_accordion_cq")
          ),
          array(
            "type" => "dropdown",
            "class" => "vc_direction",
            "heading" => __("Select display template style", "vc_accordion_cq"),
            "param_name" => "template_direction",
            "value" => array(__("Ascendant", "vc_accordion_cq") => "ASC" ,__("Descendant", "vc_accordion_cq") => "DESC"), 
            "description" => __("", "vc_accordion_cq")
          ),
          array(
            "type" => "textfield",
            "heading" => __("Title", "vc_accordion_cq"),
            "param_name" => "title_template_design",
            "value" => "",
            "dependency" => Array('element' => "accordionstyle", 'value' => array('style1')),
            "description" => __("Enter title.", "vc_accordion_cq")
          ),
          array(
            "type" => "textarea",
            "class" => "",
            "heading" => __( "Description", "vc_accordion_cq" ),
            "param_name" => "description_template_design",
            "value" => __( "", "vc_accordion_cq" ),
            "dependency" => Array('element' => "accordionstyle", 'value' => array('style1')),
            "description" => __( "Enter description.", "vc_accordion_cq" )
          ),
          array(
            "type" => "textfield",
            "heading" => __("Number of templates per page", "vc_accordion_cq"),
            "param_name" => "template_per_view",
            "value" => "2",
            "dependency" => Array('element' => "accordionstyle", 'value' => array('style2'))
          ),
          array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __( "Color arrow", "printshop" ),
            "param_name" => "color_arrow",
            "value" => '#CC7272',
            "dependency" => Array('element' => "accordionstyle", 'value' => array('style2'))
          ),
          // array(
          //   'type' => 'css_editor',
          //   'heading' => __( 'Css', 'printshop' ),
          //   'param_name' => 'css',
          //   'group' => __( 'Design options', 'printshop' ),
          //   "dependency" => Array('element' => "accordionstyle", 'value' => array('style2'))
          // ),
          array(
            "type" => "textfield",
            "heading" => __("Padding", "vc_accordion_cq"),
            "param_name" => "padding_template_design",
            "value" => "",
            "description" => __( "Padding of image in block border ( Example: 5px )", "printshop" ),
            "dependency" => Array('element' => "accordionstyle", 'value' => array('style2'))
          ),
        )
      );
		
		return $options;
	}

	public static function content( $atts ) {
		$html = '';
      extract(
        shortcode_atts(
          array(
            'accordionstyle' => 'style1',
            'num_template_design' => 4,
            'title_template_design' => '',
            'description_template_design' => '',
            'template_per_view' => 2,
            'color_arrow' => '#CC7272',
            'padding_template_design' => '0px',
            'template_direction' => 'ASC',
          ),
          $atts
        )
      );
      
      global $wpdb;
      if ( is_plugin_active('web-to-print-online-designer/nbdesigner.php') ) {
        $sql = "SELECT p.ID, p.post_title, t.id AS tid, t.name, t.folder, t.product_id, t.variation_id, t.user_id, t.thumbnail FROM {$wpdb->prefix}nbdesigner_templates AS t";     
        $sql .= " LEFT JOIN {$wpdb->prefix}posts AS p ON t.product_id = p.ID";
        $sql .= " WHERE t.publish = 1 AND p.post_status = 'publish' AND publish = 1"; 
        $sql .= " ORDER BY t.created_date ".$template_direction;
        $sql .= " LIMIT ".$num_template_design;
        $posts = $wpdb->get_results($sql, 'ARRAY_A');
        $listTemplates = array();
        foreach ($posts as $p) {
          $path_preview = NBDESIGNER_CUSTOMER_DIR .'/'.$p['folder']. '/preview';
          if( $p['thumbnail'] ){
            $image = wp_get_attachment_url( $p['thumbnail'] );
          }else{
            $listThumb = Nbdesigner_IO::get_list_images($path_preview);
            $image = '';
            if(count($listThumb)){
              $image = Nbdesigner_IO::wp_convert_path_to_url(reset($listThumb));
            }                
          }
          $title = $p['name'] ?  $p['name'] : $p['post_title'];
          $listTemplates[] = array('tid' => $p['tid'], 'id' => $p['ID'], 'title' => $title, 'image' => $image, 'folder' => $p['folder'], 'product_id' => $p['product_id'], 'variation_id' => $p['variation_id'], 'user_id' => $p['user_id']);
        }
        $html.='<div class="template-online-design">';

        if($accordionstyle=="style1") {
          if($title_template_design){
            $html.='<h3>'.$title_template_design.'</h3>';
          }
          $html.='<div class="row">';
          if($description_template_design){
            $html.='<div class="col-xs-12 col-md-12 col-lg-8 des">'.$description_template_design.'</div>';
            $html.='<div class="col-xs-12 col-md-12 col-lg-4">';
          }else{
            $html.='<div class="col-xs-12 col-md-12">';
          }

          $html.='<h5><a href="'.getUrlPageNBD('designer').'">Browse all designers</a></h5>';
          $html.='</div>';
          if(count($listTemplates)>0) {
            $UrlPageNBD = getUrlPageNBD('create');
            foreach ($listTemplates as $key => $temp) {
              $link_template = add_query_arg(array(
                'product_id' => $temp['product_id'],
                'variation_id' => $temp['variation_id'],
                'reference'  =>  $temp['folder']
              ), $UrlPageNBD);
              $html.='<div class="col-sm-6 col-md-6 col-lg-3 item effect1">';
              $html.='<a href="'.$link_template.'" class="thumbnail">';
              $html.='<img src="'.$temp['image'].'" alt="'.$temp['title'].'">';
              $html.='</a>';
              $html.='</div>';
            }
          }
          $html.='</div>';
        } else {
          $html.='<div class="vc-printshop-template-online">';
          $html.='<div class="swiper-container vc-template-od">';
          $html.='<div class="swiper-wrapper" data-per="'.$template_per_view.'" data-color="'.$color_arrow.'">';
          if(count($listTemplates)>0) {
            $UrlPageNBD = getUrlPageNBD('create');
            foreach ($listTemplates as $key => $temp) {
              $link_template = add_query_arg(array(
                'product_id' => $temp['product_id'],
                'variation_id' => $temp['variation_id'],
                'reference'  =>  $temp['folder']
              ), $UrlPageNBD);
              $html.='<div class="swiper-slide">';
              $html.='<a href="'.$link_template.'" class="thumbnail" style="padding: '.$padding_template_design.';">';
              $html.='<img src="'.$temp['image'].'" alt="'.$temp['title'].'">';
              $html.='</a>';
              $html.='</div>';
            }
          }
          $html.='</div>';
          // $html.='<div class="swiper-pagination"></div>';
          $html.='<div class="wrap-swiper-button-next"><div class="swiper-button-next-2"></div></div>';
          $html.='<div class="wrap-swiper-button-prev"><div class="swiper-button-prev-2"></div></div>';
          $html.='</div>';
          $html.='</div>';
        }
        $html.='</div>';
      }
      return apply_filters('netbase_shortcode_template_online_design', $html );

	}
}
