<?php

class NB_Social_Element {

	public function options() {
		$options = array(
	      	"name" => __( "Social Element", "nb_element" ),
	      	"base" => "vc_home7_social",
	      	"class" => "",
	      	'icon' => 'fa fa-facebook',
	      	'id' => 'social-media',
	      	"category" => __( "PrintCart", "nb_element"),
	      	"params" => array(
	      		array(
		            'type' => 'textfield',
		            'heading' => __('Facebook', 'nb_element'),
		            'param_name' => 'vc_facebook',
		            'value' => '',
		            'description' => __(' Facebook link ', 'nb_element'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Twitter', 'nb_element'),
		            'param_name' => 'vc_twitter',
		            'value' => '',
		            'description' => __(' Twitter link ', 'nb_element'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Pinterest', 'nb_element'),
		            'param_name' => 'vc_pinterest',
		            'value' => '',
		            'description' => __(' Pinterest link ', 'nb_element'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Linkedin', 'nb_element'),
		            'param_name' => 'vc_linkedin',
		            'value' => '',
		            'description' => __(' Linkedin link ', 'nb_element'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Google plus', 'nb_element'),
		            'param_name' => 'vc_google_plus',
		            'value' => '',
		            'description' => __('  ', 'nb_element'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Instagram', 'nb_element'),
		            'param_name' => 'vc_instagram',
		            'value' => '',
		            'description' => __(' Instagram link ', 'nb_element'),
		            'admin_label' => true,
		        ),
		        array(
		            'type' => 'textfield',
		            'heading' => __('Rss', 'nb_element'),
		            'param_name' => 'vc_rss',
		            'value' => '',
		            'description' => __(' Rss link ', 'nb_element'),
		            'admin_label' => true,
		        ),
	      	),
	   	);
		
		return $options;
	}

	public static function content( $atts ) {
		$html = '' ;
	   	extract( shortcode_atts( array(
	      	'vc_facebook' => '',
	      	'vc_twitter' => '',
	      	'vc_pinterest' => '',
	      	'vc_linkedin' => '',
	      	'vc_google_plus' => '',
	      	'vc_instagram' => '',
	      	'vc_rss' => '',
	   	), $atts ) );

	   	$html .='<ul class="social-section">';
	   	
	   	if( $vc_facebook != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_facebook ).'"><i class="fa fa-facebook"></i></a></li>';
	   	}
	   	if( $vc_twitter != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_twitter ).'"><i class="fa fa-twitter"></i></a></li>';
	   	}
	   	if( $vc_pinterest != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_linkedin ).'"><i class="fa fa-linkedin"></i></a></li>';
	   	}
	   	if( $vc_linkedin != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_pinterest ).'"><i class="fa fa-pinterest-p"></i></a></li>';
	   	}
	   	if( $vc_google_plus != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_google_plus ).'"><i class="fa fa-google-plus"></i></a></li>';
	   	}
	   	if( $vc_instagram != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_instagram ).'"><i class="fa fa-instagram"></i></a></li>';
	   	}
	   	if( $vc_rss != '' ){
	   		$html .='<li class="social-item"><a href="'.esc_attr( $vc_rss ).'"><i class="fa fa-rss"></i></a></li>';
	   	}	
	   	
	   	$html .='</ul>';

	   	wp_reset_postdata();

        return $html;
	}
}
