<?php
//class Customize_Woocommerce{
 function woocommerce()
    {

        $attributes = array();
        if ( class_exists( 'WooCommerce' ) ) {

            $attributes_tax = wc_get_attribute_taxonomies();
            foreach ($attributes_tax as $attribute) {
                $attributes[$attribute->attribute_name] = $attribute->attribute_label;

            }
        }

        return array(
            'title' => esc_html__('Products', 'printcart'),
            'priority' => 15,
            'sections' => array(
                'product_category' => array(
                    'title' => esc_html__('Product Category', 'printcart'),
                ),
                'product_details' => array(
                    'title' => esc_html__('Product Details', 'printcart'),
                ),
                'other_wc_pages' => array(
                    'title' => esc_html__('Other Pages', 'printcart'),
                ),
            ),
            'options' => array(
                'nbcore_pa_title_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Product category title', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Heading',
                    ),
                ),
                'nbcore_shop_title' => array(
                    'settings' => array(
                        'transport' => 'postMessage',
                        'sanitize_callback' => 'wp_filter_nohtml_kses'
                    ),
                    'controls' => array(
                        'label' => esc_html__('Shop page title', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'text',
                    ),
                ),
                'nbcore_wc_breadcrumb' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show breadcrumb ?', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pa_layout_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Product category layout', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Heading',
                    ),
                ),
                'nbcore_shop_sidebar' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Sidebar Layout', 'printcart'),
                        'section' => 'product_category',
                        'description' => esc_html__('Sidebar Position for product category and shop page', 'printcart'),
                        'type' => 'Printcart_Customize_Control_Radio_Image',
                        'choices' => array(
                            'left-sidebar' => get_template_directory_uri() . '/assets/images/options/2cl.png',
                            'no-sidebar' => get_template_directory_uri() . '/assets/images/options/1c.png',
                            'right-sidebar' => get_template_directory_uri() . '/assets/images/options/2cr.png',
                        ),
                    ),
                ),
                'nbcore_shop_content_width' => array(
                    'settings' => array(
                        'transport' => 'postMessage',
                        'sanitize_callback' => 'absint'
                    ),
                    'controls' => array(
                        'label' => esc_html__('Woocommerce content width', 'printcart'),
                        'description' => esc_html__('This options also effect Cart page', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Slider',
                        'choices' => array(
                            'unit' => '%',
                            'min' => '60',
                            'max' => '80',
                            'step' => '1'
                        ),
                    ),
                ),
                'shop_sticky_sidebar' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Sticky Sidebar', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                //TODO nbcore_product_list depencies
                'nbcore_grid_product_description' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Product Description', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),

                'nbcore_show_separated_border' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show separated border', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),

                'nbcore_product_meta_align' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Choose product meta align', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'select',
                        'choices' => array(
                            'left' => esc_html__('Left', 'printcart'),
                            'center' => esc_html__('Center', 'printcart'),
                            'right' => esc_html__('Right', 'printcart'),
                        ),
                        'default' => 'horizontal'
                    ),
                ),

                'nbcore_product_hover' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Choose product hover', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'select',
                        'choices' => array(
                            'image' => esc_html__('Display box shadow only product image', 'printcart'),
                            'full_block' => esc_html__('Display box shadow whole product block', 'printcart'),
                        ),
                        'default' => 'horizontal'
                    ),
                ),

                'nbcore_loop_columns' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Products per row', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Radio_Image',
                        'choices' => array(
                            'two-columns' => get_template_directory_uri() . '/assets/images/options/2-columns.png',
                            'three-columns' => get_template_directory_uri() . '/assets/images/options/3-columns.png',
                            'four-columns' => get_template_directory_uri() . '/assets/images/options/4-columns.png',
                        ),
                    ),
                ),
                'nbcore_pa_other_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Other', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Heading',
                    ),
                ),
                'nbcore_shop_banner' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Shop Banner', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'WP_Customize_Cropped_Image_Control',
                        'flex_width'  => true,
                        'flex_height' => true,
                        'width' => 2000,
                        'height' => 1000,
                    ),
                ),
                'nbcore_shop_action' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show shop action', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch'
                    ),
                ),

                'nbcore_product_image_mask' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show opacity when hover', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch'
                    ),
                ),

                'nbcore_product_rating' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show product rating', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch'
                    ),
                ),

                'nbcore_product_action_style' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Choose product action style', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'select',
                        'choices' => array(
                            'vertical' => esc_html__('Vertical', 'printcart'),
                            'horizontal' => esc_html__('Horizontal', 'printcart'),
                            'center' => esc_html__('Center', 'printcart'),
                            'vertical_fix_wl' => esc_html__('Vertical with fixed wishlist button', 'printcart'),
                            'horizontal_fix_wl' => esc_html__('Horizontal with fixed wishlist button', 'printcart'),
                        ),
                        'default' => 'horizontal'
                    ),
                ),

                'nbcore_products_per_page' => array(
                    'settings' => array(
                        'sanitize_callback' => 'absint'
                    ),
                    'controls' => array(
                        'label' => esc_html__('Products per Page', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'number',
                        'input_attrs' => array(
                            'min'   => 1,
                            'step'  => 1,
                        ),
                    ),
                ),
                'nbcore_wc_sale' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Choose sale tag style', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'select',
                        'choices' => array(
                            ''        => esc_html__('Do not display', 'printcart'),
                            'style-1' => esc_html__('Style 1', 'printcart'),
                            'style-2' => esc_html__('Style 2', 'printcart'),
                        ),
                    ),
                ),

                'nbcore_product_image_border_color' => array(
                    'settings' => array(
                        'transport' => 'postMessage',
                        'sanitize_callback' => 'wp_filter_nohtml_kses'
                    ),
                    'controls' => array(
                        'label' => esc_html__('Product Image Border Color', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Color',
                    ),
                ),



                'product_category_compare' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Compare button', 'printcart'),
                        'description' => esc_html__('This feature need YITH Woocommerce Compare plugin to be installed and activated', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'product_category_wishlist' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Wishlist button', 'printcart'),
                        'description' => esc_html__('This feature need YITH Woocommerce Wishlist plugin to be installed and activated', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'product_category_quickview' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Quickview button', 'printcart'),
                        'description' => esc_html__('This feature need YITH Woocommerce Quick View plugin to be installed and activated', 'printcart'),
                        'section' => 'product_category',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pd_layout_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Layout', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Heading',
                    ),
                ),
                'nbcore_pd_details_title' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Enable Product title', 'printcart'),
                        'description' => esc_html__('Default product title is not display if the Page title is showing. Enable this to displaying both.', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pd_details_sidebar' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Product details sidebar', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Radio_Image',
                        'choices' => array(
                            'left-sidebar' => get_template_directory_uri() . '/assets/images/options/2cl.png',
                            'no-sidebar' => get_template_directory_uri() . '/assets/images/options/1c.png',
                            'right-sidebar' => get_template_directory_uri() . '/assets/images/options/2cr.png',
                        ),
                    ),
                ),
                'nbcore_pd_details_width' => array(
                    'settings' => array(
                        'transport' => 'postMessage',
                        'sanitize_callback' => 'absint'
                    ),
                    'controls' => array(
                        'label' => esc_html__('Product details content width', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Slider',
                        'choices' => array(
                            'unit' => '%',
                            'min' => '60',
                            'max' => '80',
                            'step' => '1'
                        ),
                    ),
                ),
                'product_sticky_sidebar' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Sticky sidebar', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pd_meta_layout' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Product meta layout', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Radio_Image',
                        'choices' => array(
                            'left-images' => get_template_directory_uri() . '/assets/images/options/left-image.png',
                            'right-images' => get_template_directory_uri() . '/assets/images/options/right-image.png',
                            'wide' => get_template_directory_uri() . '/assets/images/options/wide.png',
                        ),
                    ),
                ),
                'nbcore_add_cart_style' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Add to cart input style', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'select',
                        'choices' => array(
                            'style-1' => esc_html__('Style 1', 'printcart'),
                            'style-2' => esc_html__('Style 2', 'printcart'),
                        ),
                    ),
                ),
                'nbcore_pd_show_social' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show social share?', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pd_gallery_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Product Gallery', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Heading',
                    ),
                ),
                'nbcore_pd_images_width' => array(
                    'settings' => array(
                        'transport' => 'postMessage',
                        'sanitize_callback' => 'absint'
                    ),
                    'controls' => array(
                        'label' => esc_html__('Product images width', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Slider',
                        'choices' => array(
                            'unit' => '%',
                            'min' => '30',
                            'max' => '60',
                            'step' => '1'
                        ),
                    ),
                ),
                'nbcore_pd_featured_autoplay' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Featured Images Autoplay', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pd_thumb_pos' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Small thumb position', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Radio_Image',
                        'choices' => array(
                            'bottom-thumb' => get_template_directory_uri() . '/assets/images/options/bottom-thumb.png',
                            'left-thumb' => get_template_directory_uri() . '/assets/images/options/left-thumb.png',
                            'inside-thumb' => get_template_directory_uri() . '/assets/images/options/inside-thumb.png',
                        ),
                    ),
                ),
                'nbcore_pd_info_tab_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Information tab', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Heading',
                    ),
                ),
                'nbcore_info_style' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Tabs style', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'select',
                        'choices' => array(
                            'horizontal-tabs' => esc_html__('Horizontal', 'printcart'),
                            'accordion-tabs' => esc_html__('Accordion', 'printcart'),
                        ),
                    ),
                ),
                'nbcore_reviews_form' => array(
                    'settings' => array(
                        'transport' => 'postMessage',
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Reviews form style', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'select',
                        'choices' => array(
                            'split' => esc_html__('Split', 'printcart'),
                            'full-width' => esc_html__('Full Width', 'printcart'),
                        ),
                    ),
                ),
                'nbcore_reviews_round_avatar' => array(
                    'settings' => array(
                        'transport' => 'postMessage',
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Round reviewer avatar', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_other_products_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Related & Cross-sells products', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Heading',
                    ),
                ),
                'nbcore_show_upsells' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show upsells products?', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pd_upsells_columns' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Upsells Products per row', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'select',
                        'choices' => array(
                            '2' => esc_html__('2 Products', 'printcart'),
                            '3' => esc_html__('3 Products', 'printcart'),
                            '4' => esc_html__('4 Products', 'printcart'),
                        ),
                    ),
                ),
                'nbcore_upsells_limit' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Upsells Products limit', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'number',
                        'input_attrs' => array(
                            'min' => '2',
                            'step' => '1'
                        ),
                    ),
                ),
                'nbcore_show_related' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show related product?', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_pd_related_columns' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Related Products per row', 'printcart'),
                        'section' => 'product_details',
                        'type' => 'select',
                        'choices' => array(
                            '2' => esc_html__('2 Products', 'printcart'),
                            '3' => esc_html__('3 Products', 'printcart'),
                            '4' => esc_html__('4 Products', 'printcart'),
                        ),
                    ),
                ),
                'nbcore_cart_intro' => array(
                    'settings' => array( 'sanitize_callback' => 'absint' ),
                    'controls' => array(
                        'label' => esc_html__('Cart', 'printcart'),
                        'section' => 'other_wc_pages',
                        'type' => 'Printcart_Customize_Control_Heading'
                    ),
                ),
                'nbcore_cart_layout' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Cart page layout', 'printcart'),
                        'section' => 'other_wc_pages',
                        'type' => 'Printcart_Customize_Control_Radio_Image',
                        'choices' => array(
                            'cart-layout-1' => get_template_directory_uri() . '/assets/images/options/cart-style-1.png',
                            'cart-layout-2' => get_template_directory_uri() . '/assets/images/options/cart-style-2.png',
                        ),
                    ),
                ),
                'nbcore_show_to_shop' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show Continue shopping button', 'printcart'),
                        'section' => 'other_wc_pages',
                        'type' => 'Printcart_Customize_Control_Switch',
                    ),
                ),
                'nbcore_show_cross_sells' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_checkbox')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Show cross sells', 'printcart'),
                        'section' => 'other_wc_pages',
                        'type' => 'Printcart_Customize_Control_Switch'
                    ),
                ),
                'nbcore_cross_sells_per_row' => array(
                    'settings' => array(
                        'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                    ),
                    'controls' => array(
                        'label' => esc_html__('Products per row', 'printcart'),
                        'section' => 'other_wc_pages',
                        'type' => 'select',
                        'choices' => array(
                            '3' => esc_html__('3 products', 'printcart'),
                            '4' => esc_html__('4 products', 'printcart'),
                            '5' => esc_html__('5 products', 'printcart'),
                        ),
                    ),
                ),
                'nbcore_cross_sells_limit' => array(
                    'settings' => array(
                        'sanitize_callback' => 'absint'
                    ),
                    'controls' => array(
                        'label' => esc_html__('Cross sells Products limit', 'printcart'),
                        'section' => 'other_wc_pages',
                        'type' => 'number',
                        'input_attrs' => array(
                            'min' => '3',
                            'step' => '1'
                        ),
                    ),
                ),
            ),
        );
    }

function get_option_woocommerce($option)
    {
            $option ['product']= woocommerce();
            return $option;
    }
add_filter('core_customize_new_sections_definition','get_option_woocommerce');
//}