<?php
function onlinedesign()
{
    return array(
        'title' => esc_html__('Online Design', 'printcart'),
        'priority' => 15,
        'sections' => array(
            'online_design' => array(
                'title' => esc_html__('Online Design', 'printcart'),
            ),
        ),
        'options' => array(
            'nbcore_template_designer_style' => array(
                'settings' => array(
                    'sanitize_callback' => array('Printcart_Customize_Sanitize', 'sanitize_selection')
                ),
                'controls' => array(
                    'label' => esc_html__('Choose template designer style', 'printcart'),
                    'section' => 'online_design',
                    'type' => 'select',
                    'choices' => array(
                        'style1' => esc_html__('Style 1', 'printcart'),
                        'style2' => esc_html__('Style 2', 'printcart'),
                        'style3' => esc_html__('Style 3', 'printcart'),
                    ),
                    'default' => 'style1'
                ),
            ),
        ),
    ); 
}
function get_option_onlinedesign($options){
    $options ['onlinedesign'] =  onlinedesign();
    return $options;
}
add_filter('core_customize_new_sections_definition','get_option_onlinedesign');