import { PackageJson } from 'type-fest';
/**
 * Determines whether a node has a valid value
 *
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param value Value to validate
 * @param validValues Array of valid values to validate against
 * @return True if the node is equal to one of the valid values or is missing. False if it is not.
 */
export declare const isValidValue: <T>(packageJsonData: PackageJson | any, nodeName: string, value: T, validValues: T[]) => boolean;
/**
 * Determines whether a node matches a valid value
 *
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param value Value to validate
 * @param validRegexes Array of regex to validate against
 * @return True if the node matches one of the valid regexes or is missing. False if it is not.
 */
export declare const matchValidValue: (packageJsonData: PackageJson | any, nodeName: string, value: string, validRegexes: RegExp[]) => boolean;
