import { LintIssue } from '../lint-issue';
import { PackageJsonFileLintingResult } from '../types/package-json-linting-result';
/**
 * A result count object for a files.
 * @typedef {Object} FileResultCounts
 * @property {number} errorCount    Number of errors for a file result.
 * @property {number} warningCount  Number of warnings for a file result.
 */
export interface PackageJsonFileAggregatedResultCounts {
    errorCount: number;
    warningCount: number;
}
/**
 * Aggregates the count of errors and warning for a package.json file.
 *
 * @param issues Array of {@link LintIssue} objects from a package.json file.
 * @returns Counts object {@link PackageJsonFileAggregatedResultCounts}.
 */
export declare const aggregateCountsPerFile: (issues: LintIssue[]) => PackageJsonFileAggregatedResultCounts;
export interface OverallAggregatedResultCounts {
    /**
     * Total number of ignored files.
     */
    ignoreCount: number;
    /**
     * Total number of errors.
     */
    errorCount: number;
    /**
     * Total number of warnings.
     */
    warningCount: number;
}
/**
 * Aggregates the count of errors and warnings for all package.json files.
 *
 * @param results Array of {@link PackageJsonFileLintingResult} objects from all package.json files.
 * @returns Counts object {@link OverallAggregatedResultCounts}
 */
export declare const aggregateOverallCounts: (results: PackageJsonFileLintingResult[]) => OverallAggregatedResultCounts;
