/**
 * Validates standard rules config.
 *
 * @param {Object} ruleConfig The ruleConfig object to validate.
 * @returns {boolean} True if valid. Error if not.
 */
export declare const isStandardRuleSchemaValid: (ruleConfig: any) => any;
/**
 * Validates array rules config.
 *
 * @param {Object} ruleConfig The ruleConfig object to validate.
 * @param {number} minItems   Min number of items in the array
 * @returns {boolean} True if valid. Error if not.
 */
export declare const isArrayRuleSchemaValid: (ruleConfig: any, minItems: any) => any;
/**
 * Validates array rules config.
 *
 * @param {Object} ruleConfig The ruleConfig object to validate.
 * @returns {boolean} True if valid. Error if not.
 */
export declare const isObjectRuleSchemaValid: (ruleConfig: any) => any;
/**
 * Validates optional object exceptions config.
 *
 * @param {Object} ruleConfig The ruleConfig object to validate.
 * @returns {boolean} True if valid. Error if not.
 */
export declare const isOptionalObjExceptSchemaValid: (ruleConfig: any) => any;
/**
 * Validates the top level properties of the config object.
 *
 * @param {Object} config The config object to validate.
 * @param {string} source The name of the configuration source to report in any errors.
 * @returns {boolean} True if valid. Error if not.
 */
export declare const isConfigObjectSchemaValid: (config: any, source: any) => any;
