import { SpawndOptions, SpawndChildProcess } from 'spawnd';
import { WaitOnOptions } from 'wait-on';

type Config = {
    /**
     * Command to execute to start the port.
     * Directly passed to [`spawnd`](https://www.npmjs.com/package/spawnd).
     * @example "npm run start"
     * @example "yarn start"
     * @example "node server.js"
     * @see https://www.npmjs.com/package/spawnd#command
     */
    command: string;
    /**
     * Enable debug mode.
     * @default false
     */
    debug?: boolean;
    /**
     * Spawnd options.
     * @see https://www.npmjs.com/package/spawnd#options
     */
    options?: SpawndOptions;
    /**
     * Timeout to wait for the server to start.
     * @default 5000
     */
    launchTimeout?: number;
    /**
     * Host to use to check if the port is used.
     */
    host?: string;
    /**
     * Port to use to check if the port is used.
     */
    port?: number;
    /**
     * Path to use to check if the port is used.
     */
    path?: string;
    /**
     * Protocol to use to check if the port is used.
     * @default "tcp"
     */
    protocol?: "tcp" | "http" | "https" | "socket";
    /**
     * Action to take if the port is already used.
     * @default "ask"
     */
    usedPortAction?: "ask" | "error" | "ignore" | "kill";
    /**
     * Options to pass to [`wait-on`](https://www.npmjs.com/package/wait-on).
     * @see https://www.npmjs.com/package/wait-on#options
     */
    waitOnScheme?: WaitOnOptions;
};
declare const ERROR_TIMEOUT = "ERROR_TIMEOUT";
declare const ERROR_PORT_USED = "ERROR_PORT_USED";
declare const ERROR_NO_COMMAND = "ERROR_NO_COMMAND";
declare class JestDevServerError extends Error {
    code?: string;
    constructor(message: string, options?: {
        code?: string;
        cause?: Error;
    });
}
declare function setup(providedConfigs: Config | Config[]): Promise<SpawndChildProcess[]>;
declare function teardown(procs: SpawndChildProcess[]): Promise<void>;

export { type Config, ERROR_NO_COMMAND, ERROR_PORT_USED, ERROR_TIMEOUT, JestDevServerError, setup, teardown };
