/**
 * @fileoverview Collection of popular sites/CDNs hosting Angular.
 * @author lwe@google.com (Lukas Weichselbaum)
 *
 * @license
 * Copyright 2016 Google Inc. All rights reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * Angular libraries on commonly allowlisted origins (e.g. CDNs) that would
 * allow a CSP bypass.
 * Only most common paths are listed here. Hence there might still be other
 * paths on these domains that would allow a bypass.
 */
export const URLS: string[] = [
  '//gstatic.com/fsn/angular_js-bundle1.js',
  '//www.gstatic.com/fsn/angular_js-bundle1.js',
  '//www.googleadservices.com/pageadimg/imgad',
  '//yandex.st/angularjs/1.2.16/angular-cookies.min.js',
  '//yastatic.net/angularjs/1.2.23/angular.min.js',
  '//yuedust.yuedu.126.net/js/components/angular/angular.js',
  '//art.jobs.netease.com/script/angular.js',
  '//csu-c45.kxcdn.com/angular/angular.js',
  '//elysiumwebsite.s3.amazonaws.com/uploads/blog-media/rockstar/angular.min.js',
  '//inno.blob.core.windows.net/new/libs/AngularJS/1.2.1/angular.min.js',
  '//gift-talk.kakao.com/public/javascripts/angular.min.js',
  '//ajax.googleapis.com/ajax/libs/angularjs/1.2.0rc1/angular-route.min.js',
  '//master-sumok.ru/vendors/angular/angular-cookies.js',
  '//ayicommon-a.akamaihd.net/static/vendor/angular-1.4.2.min.js',
  '//pangxiehaitao.com/framework/angular-1.3.9/angular-animate.min.js',
  '//cdnjs.cloudflare.com/ajax/libs/angular.js/1.2.16/angular.min.js',
  '//96fe3ee995e96e922b6b-d10c35bd0a0de2c718b252bc575fdb73.ssl.cf1.rackcdn.com/angular.js',
  '//oss.maxcdn.com/angularjs/1.2.20/angular.min.js',
  '//reports.zemanta.com/smedia/common/angularjs/1.2.11/angular.js',
  '//cdn.shopify.com/s/files/1/0225/6463/t/1/assets/angular-animate.min.js',
  '//parademanagement.com.s3-website-ap-southeast-1.amazonaws.com/js/angular.min.js',
  '//cdn.jsdelivr.net/angularjs/1.1.2/angular.min.js',
  '//eb2883ede55c53e09fd5-9c145fb03d93709ea57875d307e2d82e.ssl.cf3.rackcdn.com/components/angular-resource.min.js',
  '//andors-trail.googlecode.com/git/AndorsTrailEdit/lib/angular.min.js',
  '//cdn.walkme.com/General/EnvironmentTests/angular/angular.min.js',
  '//laundrymail.com/angular/angular.js',
  '//s3-eu-west-1.amazonaws.com/staticancpa/js/angular-cookies.min.js',
  '//collade.demo.stswp.com/js/vendor/angular.min.js',
  '//mrfishie.github.io/sailor/bower_components/angular/angular.min.js',
  '//askgithub.com/static/js/angular.min.js',
  '//services.amazon.com/solution-providers/assets/vendor/angular-cookies.min.js',
  '//raw.githubusercontent.com/angular/code.angularjs.org/master/1.0.7/angular-resource.js',
  '//prb-resume.appspot.com/bower_components/angular-animate/angular-animate.js',
  '//dl.dropboxusercontent.com/u/30877786/angular.min.js',
  '//static.tumblr.com/x5qdx0r/nPOnngtff/angular-resource.min_1_.js',
  '//storage.googleapis.com/assets-prod.urbansitter.net/us-sym/assets/vendor/angular-sanitize/angular-sanitize.min.js',
  '//twitter.github.io/labella.js/bower_components/angular/angular.min.js',
  '//cdn2-casinoroom.global.ssl.fastly.net/js/lib/angular-animate.min.js',
  '//www.adobe.com/devnet-apps/flashshowcase/lib/angular/angular.1.1.5.min.js',
  '//eternal-sunset.herokuapp.com/bower_components/angular/angular.js',
  '//cdn.bootcss.com/angular.js/1.2.0/angular.min.js'
];
