// Generated by CoffeeScript 2.7.0
var json2php, make,
  hasProp = {}.hasOwnProperty;

make = function({linebreak = '', indent = '', shortArraySyntax = false} = {}) {
  var arrClose, arrOpen, nest, transform;
  arrOpen = shortArraySyntax ? '[' : 'array(';
  arrClose = shortArraySyntax ? ']' : ')';
  nest = {
    '[object Array]': function(obj, parentIndent) {
      var i, len, results, value;
      results = [];
      for (i = 0, len = obj.length; i < len; i++) {
        value = obj[i];
        results.push(transform(value, parentIndent));
      }
      return results;
    },
    '[object Object]': function(obj, parentIndent) {
      var key, results, value;
      results = [];
      for (key in obj) {
        if (!hasProp.call(obj, key)) continue;
        value = obj[key];
        results.push(transform(key, parentIndent) + ' => ' + transform(value, parentIndent));
      }
      return results;
    }
  };
  return transform = function(obj, parentIndent = '') {
    var items, nestIndent, objType, result;
    objType = Object.prototype.toString.call(obj);
    switch (objType) {
      case '[object Null]':
      case '[object Undefined]':
        result = 'null';
        break;
      case '[object String]':
        result = "'" + obj.replace(/\\/g, '\\\\').replace(/\'/g, "\\'") + "'";
        break;
      case '[object Number]':
      case '[object Boolean]':
        result = obj.toString();
        break;
      case '[object Array]':
      case '[object Object]':
        nestIndent = parentIndent + indent;
        items = nest[objType](obj, nestIndent);
        result = `${arrOpen}${linebreak + nestIndent}${items.join(',' + (linebreak === '' ? ' ' : linebreak + nestIndent))}${linebreak + parentIndent}${arrClose}`;
        break;
      default:
        result = 'null';
    }
    return result;
  };
};

json2php = make();

json2php.make = make;

if (typeof module !== 'undefined' && module.exports) {
  module.exports = json2php;
  // Not that good but useful
  global.json2php = json2php;
}
