"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Circle", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.Circle;
  }
});
Object.defineProperty(exports, "Defs", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.Defs;
  }
});
Object.defineProperty(exports, "G", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.G;
  }
});
Object.defineProperty(exports, "Line", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.Line;
  }
});
Object.defineProperty(exports, "LinearGradient", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.LinearGradient;
  }
});
Object.defineProperty(exports, "Path", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.Path;
  }
});
Object.defineProperty(exports, "Polygon", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.Polygon;
  }
});
Object.defineProperty(exports, "RadialGradient", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.RadialGradient;
  }
});
Object.defineProperty(exports, "Rect", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.Rect;
  }
});
exports.SVG = void 0;
Object.defineProperty(exports, "Stop", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.Stop;
  }
});
Object.defineProperty(exports, "SvgXml", {
  enumerable: true,
  get: function () {
    return _reactNativeSvg.SvgXml;
  }
});
var _react = require("react");
var _reactNativeSvg = require("react-native-svg");
var _reactNative = require("react-native");
var _element = require("@wordpress/element");
var _compose = require("@wordpress/compose");
var _style = _interopRequireDefault(require("./style.scss"));
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */

const AnimatedSvg = _reactNative.Animated.createAnimatedComponent((0, _element.forwardRef)((props, ref) => (0, _react.createElement)(_reactNativeSvg.Svg, {
  ref: ref,
  ...props
})));
const SVG = ({
  className = '',
  isPressed,
  animated = false,
  ...props
}) => {
  const colorScheme = (0, _compose.usePreferredColorScheme)();
  const stylesFromClasses = className.split(' ').map(element => _style.default[element]).filter(Boolean);
  const defaultStyle = isPressed ? _style.default[`is-pressed--${colorScheme}`] : _style.default['components-toolbar__control-' + colorScheme];
  const propStyle = Array.isArray(props.style) ? props.style.reduce((acc, el) => {
    return {
      ...acc,
      ...el
    };
  }, {}) : props.style;
  const styleValues = Object.assign({}, defaultStyle, propStyle, ...stylesFromClasses);
  const appliedProps = {
    ...props,
    style: styleValues
  };
  const SvgWrapper = animated ? AnimatedSvg : _reactNativeSvg.Svg;
  return (0, _react.createElement)(SvgWrapper
  // We want to re-render when style color is changed.
  , {
    key: appliedProps.style.color,
    height: "100%",
    width: "100%",
    ...appliedProps
  });
};
exports.SVG = SVG;
//# sourceMappingURL=index.native.js.map