import { createElement } from "react";
/**
 * External dependencies
 */
import { Text, View } from 'react-native';

/**
 * WordPress dependencies
 */
import { withPreferredColorScheme } from '@wordpress/compose';

/**
 * Internal dependencies
 */
import styles from './styles.scss';
const HR = ({
  getStylesFromColorScheme,
  lineStyle,
  marginLeft,
  marginRight,
  style,
  textStyle,
  text,
  ...props
}) => {
  const renderLine = key => createElement(View, {
    key: key,
    style: [getStylesFromColorScheme(styles.line, styles.lineDark), lineStyle]
  });
  const renderText = key => createElement(View, {
    key: key,
    style: styles.textContainer
  }, createElement(Text, {
    style: [styles.text, textStyle]
  }, text));
  const renderInner = () => {
    if (!text) {
      return renderLine();
    }
    return [renderLine(1), renderText(2), renderLine(3)];
  };
  return createElement(View, {
    style: [styles.container, {
      marginLeft,
      marginRight
    }, style],
    ...props
  }, renderInner());
};
export const HorizontalRule = withPreferredColorScheme(HR);
//# sourceMappingURL=index.native.js.map