# Keycodes

Keycodes utilities for WordPress, used to check the key pressed in events like `onKeyDown`. Contains keycodes constants for keyboard keys like `DOWN`, `UP`, `ENTER`, etc.

## Installation

Install the module

```bash
npm install @wordpress/keycodes --save
```

_This package assumes that your code will run in an **ES2015+** environment. If you're using an environment that has limited or no support for such language features and APIs, you should include [the polyfill shipped in `@wordpress/babel-preset-default`](https://github.com/WordPress/gutenberg/tree/HEAD/packages/babel-preset-default#polyfill) in your code._

## Usage

Check which key was used in an `onKeyDown` event:

```js
import { DOWN, ENTER } from '@wordpress/keycodes';

// [...]

onKeyDown( event ) {
	const { keyCode } = event;

	if ( keyCode === DOWN ) {
		alert( 'You pressed the down arrow!' );
	} else if ( keyCode === ENTER ) {
		alert( 'You pressed the enter key!' );
	} else {
		alert( 'You pressed another key.' );
	}
}
```

## API

<!-- START TOKEN(Autogenerated API docs) -->

### ALT

Keycode for ALT key.

### BACKSPACE

Keycode for BACKSPACE key.

### COMMAND

Keycode for COMMAND/META key.

### CTRL

Keycode for CTRL key.

### DELETE

Keycode for DELETE key.

### displayShortcut

An object that contains functions to display shortcuts.

_Usage_

```js
// Assuming macOS:
displayShortcut.primary( 'm' );
// "⌘M"
```

_Type_

-   `WPModifierHandler<WPKeyHandler<string>>`Keyed map of functions to display shortcuts.

### displayShortcutList

Return an array of the parts of a keyboard shortcut chord for display.

_Usage_

```js
// Assuming macOS:
displayShortcutList.primary( 'm' );
// [ "⌘", "M" ]
```

_Type_

-   `WPModifierHandler<WPKeyHandler<string[]>>`Keyed map of functions to shortcut sequences.

### DOWN

Keycode for DOWN key.

### END

Keycode for END key.

### ENTER

Keycode for ENTER key.

### ESCAPE

Keycode for ESCAPE key.

### F10

Keycode for F10 key.

### HOME

Keycode for HOME key.

### isAppleOS

Return true if platform is MacOS.

_Parameters_

-   _\_window_ `Window?`: window object by default; used for DI testing.

_Returns_

-   `boolean`: True if MacOS; false otherwise.

### isKeyboardEvent

An object that contains functions to check if a keyboard event matches a predefined shortcut combination.

_Usage_

```js
// Assuming an event for ⌘M key press:
isKeyboardEvent.primary( event, 'm' );
// true
```

_Type_

-   `WPModifierHandler<WPEventKeyHandler>`Keyed map of functions to match events.

### LEFT

Keycode for LEFT key.

### modifiers

Object that contains functions that return the available modifier depending on platform.

_Type_

-   `WPModifierHandler< ( isApple: () => boolean ) => WPModifierPart[]>`

### PAGEDOWN

Keycode for PAGEDOWN key.

### PAGEUP

Keycode for PAGEUP key.

### rawShortcut

An object that contains functions to get raw shortcuts.

These are intended for user with the KeyboardShortcuts.

_Usage_

```js
// Assuming macOS:
rawShortcut.primary( 'm' );
// "meta+m""
```

_Type_

-   `WPModifierHandler<WPKeyHandler<string>>`Keyed map of functions to raw shortcuts.

### RIGHT

Keycode for RIGHT key.

### SHIFT

Keycode for SHIFT key.

### shortcutAriaLabel

An object that contains functions to return an aria label for a keyboard shortcut.

_Usage_

```js
// Assuming macOS:
shortcutAriaLabel.primary( '.' );
// "Command + Period"
```

_Type_

-   `WPModifierHandler<WPKeyHandler<string>>`Keyed map of functions to shortcut ARIA labels.

### SPACE

Keycode for SPACE key.

### TAB

Keycode for TAB key.

### UP

Keycode for UP key.

### ZERO

Keycode for ZERO key.

<!-- END TOKEN(Autogenerated API docs) -->

## Contributing to this package

This is an individual package that's part of the Gutenberg project. The project is organized as a monorepo. It's made up of multiple self-contained software packages, each with a specific purpose. The packages in this monorepo are published to [npm](https://www.npmjs.com/) and used by [WordPress](https://make.wordpress.org/core/) as well as other software projects.

To find out more about contributing to this package or Gutenberg as a whole, please read the project's main [contributor guide](https://github.com/WordPress/gutenberg/tree/HEAD/CONTRIBUTING.md).

<br /><br /><p align="center"><img src="https://s.w.org/style/images/codeispoetry.png?1" alt="Code is Poetry." /></p>
