# Escape HTML

Escape HTML utils.

## Installation

Install the module

```bash
npm install @wordpress/escape-html
```

_This package assumes that your code will run in an **ES2015+** environment. If you're using an environment that has limited or no support for such language features and APIs, you should include [the polyfill shipped in `@wordpress/babel-preset-default`](https://github.com/WordPress/gutenberg/tree/HEAD/packages/babel-preset-default#polyfill) in your code._

## API

<!-- START TOKEN(Autogenerated API docs) -->

### escapeAmpersand

Returns a string with ampersands escaped. Note that this is an imperfect implementation, where only ampersands which do not appear as a pattern of named, decimal, or hexadecimal character references are escaped. Invalid named references (i.e. ambiguous ampersand) are still permitted.

_Related_

-   <https://w3c.github.io/html/syntax.html#character-references>
-   <https://w3c.github.io/html/syntax.html#ambiguous-ampersand>
-   <https://w3c.github.io/html/syntax.html#named-character-references>

_Parameters_

-   _value_ `string`: Original string.

_Returns_

-   `string`: Escaped string.

### escapeAttribute

Returns an escaped attribute value.

_Related_

-   <https://w3c.github.io/html/syntax.html#elements-attributes> "[...] the text cannot contain an ambiguous ampersand [...] must not contain
    any literal U+0022 QUOTATION MARK characters (")"

Note we also escape the greater than symbol, as this is used by wptexturize to
split HTML strings. This is a WordPress specific fix

Note that if a resolution for Trac#45387 comes to fruition, it is no longer
necessary for `__unstableEscapeGreaterThan` to be used.

See: <https://core.trac.wordpress.org/ticket/45387>

_Parameters_

-   _value_ `string`: Attribute value.

_Returns_

-   `string`: Escaped attribute value.

### escapeEditableHTML

Returns an escaped Editable HTML element value. This is different from `escapeHTML`, because for editable HTML, ALL ampersands must be escaped in order to render the content correctly on the page.

_Parameters_

-   _value_ `string`: Element value.

_Returns_

-   `string`: Escaped HTML element value.

### escapeHTML

Returns an escaped HTML element value.

_Related_

-   <https://w3c.github.io/html/syntax.html#writing-html-documents-elements> "the text must not contain the character U+003C LESS-THAN SIGN (\<) or an
    ambiguous ampersand."

_Parameters_

-   _value_ `string`: Element value.

_Returns_

-   `string`: Escaped HTML element value.

### escapeLessThan

Returns a string with less-than sign replaced.

_Parameters_

-   _value_ `string`: Original string.

_Returns_

-   `string`: Escaped string.

### escapeQuotationMark

Returns a string with quotation marks replaced.

_Parameters_

-   _value_ `string`: Original string.

_Returns_

-   `string`: Escaped string.

### isValidAttributeName

Returns true if the given attribute name is valid, or false otherwise.

_Parameters_

-   _name_ `string`: Attribute name to test.

_Returns_

-   `boolean`: Whether attribute is valid.

<!-- END TOKEN(Autogenerated API docs) -->

## Contributing to this package

This is an individual package that's part of the Gutenberg project. The project is organized as a monorepo. It's made up of multiple self-contained software packages, each with a specific purpose. The packages in this monorepo are published to [npm](https://www.npmjs.com/) and used by [WordPress](https://make.wordpress.org/core/) as well as other software projects.

To find out more about contributing to this package or Gutenberg as a whole, please read the project's main [contributor guide](https://github.com/WordPress/gutenberg/tree/HEAD/CONTRIBUTING.md).

<br /><br /><p align="center"><img src="https://s.w.org/style/images/codeispoetry.png?1" alt="Code is Poetry." /></p>
