"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.saveSiteEditorEntities = void 0;
/**
 * Save entities in the site editor. Assumes the editor is in a dirty state.
 *
 * @param this
 */
async function saveSiteEditorEntities() {
    const editorTopBar = this.page.getByRole('region', {
        name: 'Editor top bar',
    });
    const savePanel = this.page.getByRole('region', { name: 'Save panel' });
    // First Save button in the top bar.
    await editorTopBar
        .getByRole('button', { name: 'Save', exact: true })
        .click();
    // Second Save button in the entities panel.
    await savePanel
        .getByRole('button', { name: 'Save', exact: true })
        .click();
    await this.page
        .getByRole('button', { name: 'Dismiss this notice' })
        .getByText('Site updated.')
        .waitFor();
}
exports.saveSiteEditorEntities = saveSiteEditorEntities;
//# sourceMappingURL=site-editor.js.map