"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNewPost = void 0;
/**
 * Creates new post.
 *
 * @param this
 * @param options Options to create new post.
 */
async function createNewPost(options = {}) {
    const query = new URLSearchParams();
    const { postType, title, content, excerpt } = options;
    if (postType)
        query.set('post_type', postType);
    if (title)
        query.set('post_title', title);
    if (content)
        query.set('content', content);
    if (excerpt)
        query.set('excerpt', excerpt);
    await this.visitAdminPage('post-new.php', query.toString());
    await this.editor.setPreferences('core/edit-post', {
        welcomeGuide: options.showWelcomeGuide ?? false,
        fullscreenMode: false,
    });
}
exports.createNewPost = createNewPost;
//# sourceMappingURL=create-new-post.js.map