<?php
$tab = isset($_GET['tab']) ? $_GET['tab'] : "general";
?>
<div class="wrap">
	<h1><?php _e('Dashboard Settings', 'nb-dashboard');?></h1>

	<form action="" method="POST">
		<nav class="nav-tab-wrapper woo-nav-tab-wrapper">
				<a href="<?php echo home_url();?>/wp-admin/options-general.php?page=nb-dashboard&amp;tab=general" class="nav-tab<?php if ( $tab == 'general' ) echo ' nav-tab-active'; ?>"><?php _e('General', 'nb-dashboard');?></a>
				<a href="<?php echo home_url();?>/wp-admin/options-general.php?page=nb-dashboard&amp;tab=notifications" class="nav-tab<?php if ( $tab == 'notifications' ) echo ' nav-tab-active'; ?>"><?php _e('Notifications', 'nb-dashboard');?></a>
		</nav>
		<?php echo $notice_msg;?>
		<table class="form-table">
			<tbody>
				<?php if( $tab == 'general' ) {?>
				<tr data-src="<?php echo NBDB_ABSURL . 'assets/images/placeholder.png';?>">
					<th scope="row"><label for="site_name"><?php _e('Dashboard Logo for Desktop', 'nb-dashboard');?></label></th>
					<td>
						<?php nb_image_upload(get_option( 'nb_dashboard_logo' ), 'nb_dashboard[logo]', 'nb_dashboard[url]');?>
					</td>
				</tr>

				<tr data-src="<?php echo NBDB_ABSURL . 'assets/images/placeholder.png';?>">
					<th scope="row"><label for="site_name"><?php _e('Dashboard Logo for Mobile', 'nb-dashboard');?></label></th>
					<td>
						<?php nb_image_upload(get_option( 'nb_dashboard_logo_mobile' ), 'nb_dashboard[logo_mobile]', 'nb_dashboard[url]');?>
					</td>
				</tr>

				<?php
				if( !empty($authorize_code) ) {
					$account_summaries = Google_Analytics_Admin::api_client()->call( 'ga_api_account_summaries' );
					$selector = Google_Analytics_Admin::save_ga_account_summaries( $account_summaries->getData() );

					$selected = get_option( Google_Analytics_Admin::ALT_GA_WEB_PROPERTY_ID_OPTION_NAME );
					?>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Your Google Analytics', 'nb-dashboard');?></label></th>
					<td>
						<input type="hidden" name="<?php echo esc_attr( Google_Analytics_Admin::ALT_GA_SELECTED_ACCOUNT ); ?>"
							   value="<?php echo esc_attr( $selected ); ?>">
						<select id="ga_account_selector"
								name="<?php echo esc_attr( Google_Analytics_Admin::ALT_GA_SELECTED_ACCOUNT ); ?>">
							<option><?php _e( 'Please select your Google Analytics account:' ); ?></option>
							<?php
							if ( ! empty( $selector ) ) {
								foreach ( $selector as $account ) {
									?>
									<optgroup label="<?php echo $account['name']; ?>">
										<?php foreach ( $account['webProperties'] as $property ): ?>
											<?php foreach ( $property['profiles'] as $profile ): ?>
												<option
														value="<?php echo esc_attr( $account['id'] . "_" . $property['webPropertyId'] . "_" . $profile['id'] ) ?>"
													<?php echo( $selected === $property['webPropertyId'] ? 'selected="selected"' : '' ); ?>><?php echo esc_html( $property['name'] . "&nbsp;[" . $property['webPropertyId'] . "][" . $profile['id'] . "]" ) ?></option>
											<?php endforeach; ?>
										<?php endforeach; ?>
									</optgroup>
									<?php
								}
							}
							?>
						</select>
					</td>
				</tr>
				<?php }else {?>
					<tr>
						<th scope="row"><label for="site_name"><?php _e('Authorize Request', 'nb-dashboard');?></label></th>
						<td><button id="alt_ga_authorize_google" class="button-primary">Authenticate with Google</button></td>
					</tr>
					
					<tr>
						<th scope="row"><label for="site_name"><?php _e('Authorize Code', 'nb-dashboard');?></label></th>
						<td><input type="text" name="ga_authorize_code" value="<?php echo $ga_authorize_code;?>" style="width: 100%;" /></td>
					</tr>
				<?php }?>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Admin Color Scheme', 'nb-dashboard');?></label></th>
					<td>
						<?php
						$admin_color = get_option('nb_dashboard_admin_color');
						$color_scheme = get_option('nb_dashboard_color_scheme');
						?>
						<div class="color-option <?php if ( $admin_color == 'fresh' ) echo 'selected'; ?>">
							<input name="nb_dashboard[admin_color]" id="admin_color_fresh" type="radio" value="fresh" class="tog"<?php if ( $admin_color == 'fresh' ) echo ' checked="checked"'; ?>>
							<input type="hidden" name="nb_dashboard[color_scheme]" value="<?php echo base64_encode(serialize(array(
								'left_primary' => '#323945',
								'left_primary_hover' => '#3b4351',
								'top_primary' => '#4285f4',
								'top_primary_hover' => '#518ff5',
								'top_primary_color' => '#fff'
							)));?>" />
							<label for="admin_color_fresh">Default</label>
							<table class="color-palette">
								<tbody>
									<tr>
										<td style="background-color: #323945">&nbsp;</td>
										<td style="background-color: #3b4351">&nbsp;</td>
										<td style="background-color: #4285f4">&nbsp;</td>
										<td style="background-color: #518ff5">&nbsp;</td>
									</tr>
								</tbody>
							</table>
						</div>
					
					</td>
				</tr>
				<?php
				if( is_plugin_active( 'contact-form-7/wp-contact-form-7.php' ) ) {?>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Contact Form', 'nb-dashboard');?></label></th>
					<td>
						<select id="nb_dashboard_cf7" name="nb_dashboard[contact_page]">
							<option value="">(Select a contact form)</option>
							<?php
							$contact_page_id = get_option('nb_dashboard_contact_page');
							$posts = get_posts(array(
								'post_type'     => 'wpcf7_contact_form',
								'numberposts'   => -1
							));
							foreach ( $posts as $p ) {?>
							<option value="<?php echo $p->ID;?>" <?php selected( $contact_page_id, $p->ID ); ?>><?php echo $p->post_title;?> [<?php echo $p->ID;?>]</option>
							<?php }?>
						</select>
					</td>
				</tr>
				
				<!--<tr id="nb_dashboard_cf7_field"<?php if(get_option('nb_dashboard_contact_page')) { echo ' style="display: table-row"';}?>>
					<th scope="row"><label for="site_name"><?php _e('Contact Field', 'nb-dashboard');?></label></th>
					<td>
						<select name="nb_dashboard[cf7_field]">
							<option value=""><?php _e('Select a field', 'nb-dashboard');?></option>
							<?php
							if( $contact_page_id ) {
								$cf7_field = get_option('nb_dashboard_cf7_field');
								$contact_form = wpcf7_contact_form( $contact_page_id );
								
								$tags = $contact_form->scan_form_tags();
								$all_tags_name = '<option value="">'.__('Select a field', 'nb-dashboard').'</option>';
								foreach ($tags as $tag_inner):
									if( $tag_inner['name'] ) {?>
									<option value="<?php echo $tag_inner['name'];?>" <?php selected( $cf7_field, $tag_inner['name'] ); ?>><?php echo $tag_inner['name'];?></option>
									<?php }
								endforeach;
							}?>
						</select>
					</td>
				</tr>-->
				<?php }
				}else {?>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification Contact Title Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[contact_title_message]" value="<?php echo get_option('nb_dashboard_contact_title_message');?>" style="width: 100%;" /></td>
				</tr>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification Contact Content Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[contact_content_message]" value="<?php echo get_option('nb_dashboard_contact_content_message');?>" style="width: 100%;" /></td>
				</tr>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification Order Title Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[order_title_message]" value="<?php echo get_option('nb_dashboard_order_title_message');?>" style="width: 100%;" /></td>
				</tr>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification Order Content Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[order_content_message]" value="<?php echo get_option('nb_dashboard_order_content_message');?>" style="width: 100%;" /></td>
				</tr>
				
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification User Title Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[user_title_message]" value="<?php echo get_option('nb_dashboard_user_title_message');?>" style="width: 100%;" /></td>
				</tr>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification User Content Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[user_content_message]" value="<?php echo get_option('nb_dashboard_user_content_message');?>" style="width: 100%;" /></td>
				</tr>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification Comment Title Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[comment_title_message]" value="<?php echo get_option('nb_dashboard_comment_title_message');?>" style="width: 100%;" /></td>
				</tr>
				<tr>
					<th scope="row"><label for="site_name"><?php _e('Notification Comment Content Message', 'nb-dashboard');?></label></th>
					<td><input type="text" name="nb_dashboard[comment_content_message]" value="<?php echo get_option('nb_dashboard_comment_content_message');?>" style="width: 100%;" /></td>
				</tr>
			<?php }?>
			</tbody>
		</table>
		<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php _e('Save Changes');?>"></p>
	</form>
</div>