<div class="admin-heading"><h1 class="page-section"><?php echo _e('Dashboard');?></h1></div>
<div id="admin-dashboard">
	<div class="admin-dashboard-row clearfix">
		<div class="admin-dashboard-box">
			<div class="admin-dashboard-statistics">
				<h3><?php echo wc_price( nbd_get_total_rev() );?></h3>
				<p><?php echo _e('Total Revenue', 'nb-dashboard');?></p>
				<i class="adminpanel-icon-profits"></i>
			</div>
		</div>
		
		<div class="admin-dashboard-box">
			<div class="admin-dashboard-statistics">
				<h3><?php echo nbd_get_total_products();?></h3>
				<p><?php echo _e('All Products', 'nb-dashboard');?></p>
				<i class="adminpanel-icon-monitor"></i>
			</div>
		</div>

		<div class="admin-dashboard-box">
			<div class="admin-dashboard-statistics">
				<h3><?php echo nbd_get_total_orders();?></h3>
				<p><?php echo _e('Total Orders', 'nb-dashboard');?></p>
				<i class="adminpanel-icon-supermarket"></i>
			</div>
		</div>
		
		<div class="admin-dashboard-box">
			<div class="admin-dashboard-statistics">
				<h3><?php echo nbd_get_total_user();?></h3>
				<p><?php echo _e('Total User', 'nb-dashboard');?></p>
				<i class="adminpanel-icon-group"></i>
			</div>
		</div>
	</div><!-- .admin-dashboard-row -->

	<div class="admin-dashboard-row admin-dashboard-main">
		<div class="admin-dashboard-col admin-dashboard-left clearfix">


			<div class="admin-dashboard-boxed admin-dashboard-chartorder flex-wrap">
				<h3 class="heading-title"><?php _e('Orders', 'nb-dashboard');?></h3>

				<div class="admin-chart-option">
					<div class="admin-chart-range admin-order-status-filter">
						<span class="admin-order-status"><?php _e('Order Status', 'nb-dashboard');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<?php foreach( $lists_order_status as $k_status => $status_name ) {?>
							<span data-value="<?php echo esc_attr(str_replace('wc-', '', $k_status));?>"><?php echo esc_attr($status_name);?></span>
							<?php }?>
						</div>
					</div>
					<span class="admin-price"><?php echo $chartorder['total'];?></span>
					<div class="admin-chart-range admin-order-filter">
						<span class="value"><?php esc_html_e('Filter Range', 'printcart');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<span data-value="chartorder-this-week">This Week</span>
							<span data-value="chartorder-last-week">Last Week</span>
							<span data-value="chartorder-this-month">This Month</span>
							<span data-value="chartorder-last-month">Last Month</span>
							<span class="productsale-custom-range">Custom Range</span>
						</div>
						<input type="text" name="datefilter" value="" />
					</div>
				</div>

				<div class="admin-dashboard-canvas">
					<canvas id="chartorder-this-week" height="285" style="width: 100%; height: 285px;"></canvas>
				</div>
			</div>

			<div class="admin-dashboard-boxed admin-dashboard-chartsales flex-wrap">
				<h3 class="heading-title"><?php _e('Amount', 'nb-dashboard');?></h3>

				<div class="admin-chart-option">
					<div class="admin-chart-range admin-order-status-filter">
						<span class="admin-order-status"><?php _e('Order Status', 'nb-dashboard');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<?php foreach( $lists_order_status as $k_status => $status_name ) {?>
								<span data-value="<?php echo esc_attr(str_replace('wc-', '', $k_status));?>"><?php echo esc_attr($status_name);?></span>
							<?php }?>
						</div>
					</div>
					<span class="admin-price"><?php echo $chartamount['total'];?></span>
					<div class="admin-chart-range admin-order-filter">
						<span class="value"><?php esc_html_e('Filter Range', 'printcart');?> <i class="adminpanel-icon-arrow-down"></i></span>
						<div class="admin-range-option">
							<span data-value="this-week">This Week</span>
							<span data-value="last-week">Last Week</span>
							<span data-value="this-month">This Month</span>
							<span data-value="last-month">Last Month</span>
							<span class="productsale-custom-range">Custom Range</span>
						</div>
						<input type="text" name="datefilter" value="" />
					</div>
				</div>
				
				<div class="admin-dashboard-canvas">
					<canvas id="this-week" height="285" style="width: 100%; height: 285px;"></canvas>
				</div>
			</div><!-- .admin-dashboard-chartsales -->
			
			<?php if( isset($query_recent_orders) && $query_recent_orders->found_posts ) {?> 
			<div class="admin-dashboard-boxed admin-recent-orders flex-wrap">
				<h3 class="heading-title"><?php _e('Recent Orders', 'printcart');?></h3>
				<p>Total paid invoices <?php echo $query_recent_orders->found_posts;?>, unpaid <?php echo $query_recent_orders_unpaid->found_posts;?></p>
				
				<div class="admin-chart-option">
					<span><a href="<?php echo home_url();?>/wp-admin/edit.php?post_type=shop_order"><?php esc_html_e('View all', 'printcart');?></a></span>
					<!--<div class="admin-chart-range">
						<span class="value"><?php esc_html_e('Filter Range', 'printcart');?> <i class="adminpanel-icon-arrow-down"></i></span>
					</div>-->
				</div>
				
				<div class="recent-orders-wrap">
					<?php
					if ( $query_recent_orders->have_posts() ) {?>
					<div class="table-responsive">
						<table class="table">
							<thead>
								<tr>
									<th><?php _e('Invoice');?> #</th>
									<th><?php _e('Date');?></th>
									<th><?php _e('Customer Name');?></th>
									<th><?php _e('Status');?></th>
									<th><?php _e('Amount');?></th>
								</tr>
							</thead>
							<tbody>
								<?php
								global $post;
								while ( $query_recent_orders->have_posts() ) {
								$query_recent_orders->the_post();
								
								$order = wc_get_order($post->ID);
								$order_data = $order->get_data();
								?>
								<tr>
									<td>#<?php echo $order->get_id();?></td>
									<td><?php echo date_i18n( get_option( 'date_format' ), strtotime($post->post_date));?></td>
									<td>
										<?php
										if( method_exists($order,'get_formatted_billing_full_name') ) {
											echo $order->get_formatted_billing_full_name();
										}
										?>
									</td>
									<td><span class="<?php echo $order_data['status'];?>"><?php echo nbd_get_order_status($order_data['status']);?></span></td>
									<td><?php echo $order->get_formatted_order_total();?></td>
								</tr>
								<?php }
								wp_reset_postdata();?>
							</tbody>
						</table>
					</div>
					<?php }else {
						echo 'a';
					}?>
				</div>
			</div><!-- .admin-recent-orders -->
			<?php }
			if ( Google_Analytics_Helper::is_authorized() && Google_Analytics_Helper::is_account_selected() ) {?>
			<div class="admin-dashboard-boxed admin-dashboard-visitor flex-wrap">
				<h3 class="heading-title"><?php _e('Visitor', 'nb-dashboard');?></h3>
				<p><?php _e('monthly stats', 'nb-dashboard');?></p>
				
				<div class="admin-dashboard-canvas">
					<canvas id="visitor-new" height="285" style="width: 100%; height: 285px;"></canvas>
				</div>
			</div><!-- .admin-dashboard-chartsales -->
			<?php }?>
			
			<div class="admin-dashboard-half-row">
				
				<?php
				if( $usernames ) {?>
				<div class="admin-dashboard-half">
					<div class="admin-dashboard-boxed admin-dashboard-users flex-wrap">
						<h3 class="heading-title"><?php _e('Users', 'nb-dashboard');?></h3>
						<a class="view-all" href="<?php echo home_url('wp-admin/users.php');?>">View all</a>
						
						<div class="admin-dashboard-wrapper">
							<div class="admin-dashboard-wrap-scroll">
								<ul>
									<?php
										foreach( $usernames as $user) { ?>
										<li class="clearfix">
											<a href="javascript:;"><?php echo get_avatar( $user->ID, 32 ); ?></a>
											<div class="users-info">
												<h4><a href="<?php echo admin_url( 'user-edit.php?user_id=' . $user->ID, 'http' ); ?>" style="text-decoration: none;"><?php echo $user->display_name;?></a></h4>
												<p><?php if( !$description = strip_tags( get_user_meta( $user->ID, 'description', true ) ) ) {
													$description = $user->user_email;
												};

												if( strlen( $description ) > 15) {
													echo substr($description, 0, 15) . '...';
												}else {
													echo $description;
												}
												?></p>
												<span><?php echo nbd_get_time_ago( strtotime($user->user_registered) );?></span>
											</div>
											
										</li>
									<?php }?>
								</ul>
							</div>
						</div>
					</div>
				</div><!-- .admin-dashboard-half -->
				<?php }?>
				
				<div class="admin-dashboard-half<?php if( ! $usernames ) { echo ' video-left';}?>">
					<?php
					if( $videos ) {
						$video_count = count($videos);
						include NBDB_ABSPATH . 'templates/tpl-video.php';
					}?>
				</div><!-- .admin-dashboard-half -->
			</div><!-- .admin-dashboard-half-row -->
		</div>

		<div class="admin-dashboard-col clearfix">
			<?php if( isset($query_seller) && $query_seller->found_posts ) {?>
			<div class="admin-dashboard-boxed admin-dashboard-bestsell flex-wrap">
				<h3 class="heading-title"><?php _e('Best Selling Products', 'nb-dashboard');?></h3>
				<a href="#" class="bestseller-refresh"><i class="adminpanel-icon-loop2"></i></a>
				<?php
				global $post;
				if ( $query_seller->have_posts() ) {?>
				<ul>
					<?php
					while ( $query_seller->have_posts() ) {
						$query_seller->the_post();
						$product = wc_get_product($post->ID);
						$thumbnail = wp_get_attachment_url( get_post_thumbnail_id( $product->get_id() ) );
						?>
						<li class="clearfix">
							<a href="<?php echo get_permalink($product->get_id());?>" class="selling-product-thumb" target="_blank">
								<img src="<?php echo $thumbnail;?>" />
							</a>
							
							<div class="selling-product-right">
								<div class="selling-product-detail">
									<h4><a href="<?php echo get_permalink($product->get_id());?>" title="<?php echo $product->get_title();?>" target="_blank"><?php echo $product->get_title();?></a></h4>
									<p><?php echo wp_trim_words( get_the_excerpt( $product->get_id() ), 20, '...' );?></p>
								</div>
								<span class="price"><?php echo $product->get_price_html();?></span>
							</div>
							
						</li>
						<?php }
					wp_reset_postdata();?>
				</ul>
				<?php }?>
			</div><!-- .admin-dashboard-bestsell -->

			<?php
			if( $get_best_buyer ) {?>
			<div class="admin-dashboard-boxed admin-dashboard-recentbuyers flex-wrap">
				<h3 class="heading-title"><?php _e('Recent Buyers', 'nb-dashboard');?></h3>
				<div class="admin-dashboard-wrap">
					<div class="admin-dashboard-timeline">
						<?php foreach ($get_best_buyer as $key => $buyer) {
							$user = get_user_by( 'ID', $buyer->customer_user );?>
						<div class="recent-buyers-item clearfix">
							<span class="badge"><?php echo ($key+1);?></span>
							
							<div class="recent-buyers-detail">
								<a href="#" class="name"><?php echo $user->display_name;?></a>
								<p><a href="mailto:<?php echo $user->user_email;?>"><?php echo $user->user_email;?></a></p>
								<span class="price"><?php echo wc_price($buyer->price);?></span>
							</div>
						</div><!-- .recent-buyers-item -->
						<?php }?>
					</div>
				</div>
			</div><!-- .admin-dashboard-recentbuyers -->
			<?php }
			}?>

			<?php

			if( $comments && is_plugin_active( 'woocommerce/woocommerce.php' ) ) {?>
			<div id="admin-reviews" class="admin-dashboard-boxed admin-dashboard-bestsell admin-dashboard-reviews flex-wrap">
				<h3 class="heading-title"><?php _e('Recent Reviews', 'nb-dashboard');?></h3>
				
				<div class="admin-dashboard-wrap">
					<div class="admin-dashboard-wrap-scroll">
						<ul>
							<?php foreach ($comments as $key => $comment) {
								$product = wc_get_product($comment->comment_post_ID);
								?>
							<li class="clearfix">
								<a href="<?php echo get_permalink( $product->get_id() );?>" class="selling-product-thumb">
									<?php echo $product->get_image( 'thumbnail' );?>
								</a>
								<div class="selling-product-right">
									<div class="selling-product-detail">
										<h4><a href="<?php echo get_permalink( $product->get_id() );?>" title="<?php echo $product->get_title();?>"><?php echo $product->get_title();?></a></h4>
										<p><?php echo wp_trim_words($comment->comment_content, 10, '...');?></p>
										<span class="hour"><?php echo nbd_get_time_ago( strtotime($comment->comment_date) );?></span>
									</div>
									
									
								</div>
							</li>
							<?php } ?>
						</ul>
					</div>
				</div>
			</div><!-- .admin-dashboard-bestsell -->
			<?php }?>
			
			<?php
			if( $changelogs ) {?>
			<div class="admin-dashboard-boxed admin-dashboard-bestsell admin-dashboard-changelog flex-wrap">
				<h3 class="heading-title"><?php _e('Changelog', 'nb-dashboard');?></h3>
				
				<div class="admin-dashboard-wrap">
					<div class="admin-dashboard-wrap-scroll">
						<?php
						foreach ($changelogs as $key => $log) {?>
						<div class="admin-dashboard-heading clearfix">
							<h4><?php _e('Version', 'nb-dashboard');?> <?php echo $log['version_number'];?></h4>
							<p>Updated: <?php echo date_i18n( get_option( 'date_format' ), strtotime($log['created']) ); ?></p>
						</div>
						
						<div class="admin-dashboard-changetime">
							<?php echo wpautop( str_replace('+ ', '', $log['descriptions']));?>
						</div>
						<?php }?>
					</div>
				</div>
			</div>
			<?php }?>
		</div>
	</div><!-- .admin-dashboard-row -->
</div>

<script type="text/javascript">
/* ChartOrder */
var canvas_chartorder = document.getElementById("chartorder-this-week");
var ctx_chartorder = canvas_chartorder.getContext("2d");
var lineChartData_order = {
    labels : <?php echo json_encode($chartorder['horizontal']); ?>,
    datasets : [
        {
            label: "My Second dataset",
            backgroundColor: "rgb(154, 203, 232, 0.3)",
            borderColor: "rgb(154, 203, 232, 1)",
            borderWidth: 2,
			pointBackgroundColor: "rgb(154, 203, 232, 1)",
			pointBorderColor: "#fff",
			pointBorderWidth: 1,
			pointHoverRadius: 5,
			pointHoverBackgroundColor: "#fff",
			pointHoverBorderColor: "rgb(154, 203, 232, 1)",
			pointHoverBorderWidth: 1,
			pointRadius: 4,
			pointHitRadius: 10,
            data: <?php echo json_encode($chartorder['vertical']); ?>
        }
    ]
}

new Chart(ctx_chartorder , {
    type: "line",
    data: lineChartData_order,
    responsive: true,
    scaleFontFamily: "'Open Sans'",
    tooltipTitleFontFamily: "'Open Sans'",
    options: {
    	responsive: true,
        legend: {
            display: false,
        },
        tooltips: {
            callbacks: {
                label: function(tooltipItem, data) {
					price = data['datasets'][0]['data'][tooltipItem['index']];
					
					var label_order = nbdashboard.label.items;
					if( price == 1) {
						label_order = nbdashboard.label.item;
					}
					return ' ' + tooltipItem.xLabel + ': ' + price + ' ' + label_order;
                },
                title: () => null,
            }
        },
		scales: {
			yAxes: [{
				ticks: {
					beginAtZero: true
				}
			}]
		}
    },
});

/* ChartAmount */
var canvas = document.getElementById("this-week");
var ctx = canvas.getContext("2d");

var lineChartData = {
    labels : <?php echo json_encode($chartamount['horizontal']); ?>,
    datasets : [
        {
            label: "My Second dataset",
            backgroundColor: "rgb(154, 203, 232, 0.3)",
            borderColor: "rgb(154, 203, 232, 1)",
            borderWidth: 2,
			pointBackgroundColor: "rgb(154, 203, 232, 1)",
			pointBorderColor: "#fff",
			pointBorderWidth: 1,
			pointHoverRadius: 5,
			pointHoverBackgroundColor: "#fff",
			pointHoverBorderColor: "rgb(154, 203, 232, 1)",
			pointHoverBorderWidth: 1,
			pointRadius: 4,
			pointHitRadius: 10,
            data: <?php echo json_encode($chartamount['vertical']); ?>

        }
    ]
}

var myNewChart = new Chart(ctx , {
    type: "line",
    data: lineChartData,
    responsive: true,
    scaleFontFamily: "'Open Sans'",
    tooltipTitleFontFamily: "'Open Sans'",
    options: {
    	responsive: true,
        legend: {
            display: false,
        },
        tooltips: {
            callbacks: {
                label: function(tooltipItem, data) {
                	price = data['datasets'][0]['data'][tooltipItem['index']];
                	price = number_format(price, nbdashboard.decimals, nbdashboard.decimal_separator, nbdashboard.thousand_separator);
					return ' ' + tooltipItem.xLabel + ': ' + nbdashboard.format_money.replace("number", price);
                },
                title: () => null,
            }
        },
		scales: {
			yAxes: [{
				ticks: {
					beginAtZero: true
				}
			}]
		}
    },
});

<?php if( isset($analytics_stats['horizontal']) ) {?>
/* New */
var canvas_visitor = document.getElementById("visitor-new");
var ctx_visitor = canvas_visitor.getContext("2d");
var lineChartData_visitor = {
    labels : <?php echo json_encode($analytics_stats['horizontal']); ?>,
    datasets : [
        {
            label: "My Second dataset",
			backgroundColor: "rgba(248,159,159,0.8)",
			borderColor: "rgba(248,159,159,1)",
			borderWidth: 2,

			pointBackgroundColor: "rgba(248,159,159,1)",
			pointBorderColor: "#fff",
			pointBorderWidth: 1,
			pointHoverRadius: 5,
			pointHoverBackgroundColor: "#fff",
			pointHoverBorderColor: "rgba(248,159,159,1)",
			pointHoverBorderWidth: 1,
			pointRadius: 4,
			pointHitRadius: 10,


			data : <?php echo json_encode($analytics_stats['vertical']); ?>
        }
    ]
}

new Chart(ctx_visitor , {
    type: "line",
    data: lineChartData_visitor,
    responsive: true,
    scaleFontFamily: "'Open Sans'",
    tooltipTitleFontFamily: "'Open Sans'",
    options: {
        responsive: true,
        legend: {
            display: false,
        },
        tooltips: {
            callbacks: {
                label: function(tooltipItem, data) {
                    num = data['datasets'][0]['data'][tooltipItem['index']];
                    return ' ' + tooltipItem.xLabel + ': ' + num + ' Visitors';
                    //return ' ' + num;
                },
                title: () => null,
            }
        },
		scales: {
			yAxes: [{
				ticks: {
					beginAtZero: true
				}
			}]
		}
    },
});
<?php }?>
function number_format(number, decimals, dec_point, thousands_point) {

    if (number == null || !isFinite(number)) {
        throw new TypeError("number is not valid");
    }

    if (!decimals) {
        var len = number.toString().split('.').length;
        decimals = len > 1 ? len : 0;
    }

    if (!dec_point) {
        dec_point = '.';
    }

    if (!thousands_point) {
        thousands_point = ',';
    }

    number = parseFloat(number).toFixed(decimals);

    number = number.replace(".", dec_point);

    var splitNum = number.split(dec_point);
    splitNum[0] = splitNum[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousands_point);
    number = splitNum.join(dec_point);

    return number;
}
</script>