var gulp = require('gulp');

var sass = require('gulp-sass');

var autoprefixer = require('autoprefixer');

var postcss = require('gulp-postcss');

//var rtlcss = require('gulp-rtlcss');

var rename = require('gulp-rename');

var plumber = require('gulp-plumber');

var gutil = require('gulp-util');

var cssnano = require('gulp-cssnano');

var gcmq = require('gulp-group-css-media-queries');

var jshint = require('gulp-jshint');

var uglify = require('gulp-uglify');

var concat = require('gulp-concat');

var sourcemaps = require('gulp-sourcemaps');

var browserSync = require('browser-sync').create();

var reload = browserSync.reload;



var onError = function (err) {

    console.log('An error occurred:', gutil.colors.magenta(err.message));

    gutil.beep();

    this.emit('end');

};



gulp.task('frontcss', function() {

    return gulp.src('./sass/*.scss')

        .pipe(plumber({ errorHandler: onError }))

        // .pipe(sourcemaps.init())

        .pipe(sass())

        .pipe(postcss([ autoprefixer() ]))

        // .pipe(autoprefixer())

        .pipe(gcmq())

        // .pipe(sourcemaps.write())

        .pipe(gulp.dest('./assets/css'))

        .pipe(cssnano({zindex:false}))

        .pipe(rename({ suffix: '.min' }))

        .pipe(gulp.dest('./assets/css'));

});





gulp.task('frontjs', function() {

    return gulp.src(['./assets/js/*.js'])

        // .pipe(jshint())

        // .pipe(jshint.reporter('default'))

        .pipe(concat('frontend.js'))

        .pipe(gulp.dest('./assets/js'))

        .pipe(uglify())

        .pipe(rename({suffix: '.min'}))

        .pipe(gulp.dest('./assets/js'))

});





gulp.task('watch', function() {

    // browserSync.init({

    //     files: ['../**/*.php'],

    //     proxy: 'http://localhost/core-wp/wp-admin/customize.php?return=%2Fcore-wp%2Fwp-admin%2F&changeset_uuid=70e6fbd5-c56f-4fdf-b1d7-95120898c71a',

    // });

    gulp.watch('sass/**/*.scss', ['frontcss']);

});

