<?php
class NB_Dashboard_Template {
	public function __construct() {
		add_action( 'admin_head', array( $this, 'render_admin_head'));
		add_action( 'admin_footer', array($this, 'render_html_dashboard'), 100 );
		add_action( 'admin_print_scripts', array( $this, 'enqueue_scripts' ) );
		add_filter( 'admin_footer_text', '__return_false' );
	}

	public function render_admin_head() {
		$color_scheme = @unserialize( base64_decode(get_option('nb_dashboard_color_scheme')) );

		if($color_scheme) {
			echo '<style>
			html.wp-toolbar #wpadminbar {
				background-color: ' . $color_scheme['top_primary'] . ' !important;
				border-bottom: 1px solid ' . $color_scheme['top_primary'] . ' !important;
			}
			
			#wpadminbar .adminpanel-hamburger {
				border-top: 3px solid ' . $color_scheme['top_primary_color'] . ' !important;
				border-bottom: 3px solid ' . $color_scheme['top_primary_color'] . ' !important;
			}
			#wpadminbar .adminpanel-hamburger:before {
				border-top: 3px solid ' . $color_scheme['top_primary_color'] . ' !important;
			}
			html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li>a>i,
			html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name a,
			html.wp-toolbar #wpadminbar .pc-admin-header-row .pc-admin-header-nav>ul>li.pc-admin-header-avatar .pc-admin-header-name p {
				color: ' . $color_scheme['top_primary_color'] . ' !important;
			}
			
			</style>';
		}
	}

	public function render_html_dashboard() {
		echo '<div class="nbd-loading"><div><div class="c1"></div><div class="c2"></div><div class="c3"></div><div class="c4"></div></div></div>';



		/* Recent Orders */
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			$query_recent_orders = new WP_Query( array(
				'posts_per_page' => 6,
				'post_type'   => wc_get_order_types(),
				'post_status' => array_keys( wc_get_order_statuses() )
			) );
			
			$unpaid_status = wc_get_order_statuses();
			$unpaid_status = array(
				'wc-on-hold' => $unpaid_status['wc-on-hold'],
				'wc-processing' => $unpaid_status['wc-processing'],
				'wc-pending' => $unpaid_status['wc-pending'],
				
			);
			$query_recent_orders_unpaid = new WP_Query( array(
				'posts_per_page' => 6,
				'post_type'   => wc_get_order_types(),
				'post_status' => array_keys( $unpaid_status )
			) );
			
			$sell_product_args = array(
				'post_type' => 'product',
				'meta_key' => 'total_sales',
				'orderby' => 'meta_value_num',
				'posts_per_page' => 5,
			);
			$query_seller = new WP_Query( $sell_product_args );
		}else {
			$query_seller = $query_recent_orders = $query_recent_orders_unpaid = '';
		}
		
		/* Comments */
		$comment_args = array( 
			'number'      => 10, 
			'status'      => 'approve', 
			'post_status' => 'publish', 
			'post_type'   => 'product' 
		);

		$comments = get_comments( $comment_args );
		


		$this->render_script_template( 'nb-dashboard', 'dashboard.php', array(
			'query_seller' => $query_seller,
			'get_best_buyer' => nbd_get_best_buyer(),
			'comments' => $comments,
			'analytics_stats' => Google_Analytics_Admin::generate_stats_data(),
			'query_recent_orders' => $query_recent_orders,
			'query_recent_orders_unpaid' => $query_recent_orders_unpaid,
			'usernames' => nbd_get_lists_user(),
			'changelogs' => nbd_get_changelog(),
			'videos' => nbd_get_video(),
			'lists_order_status' => wc_get_order_statuses(),
			'chartorder' => nbd_get_chartorder_default(),
			'chartamount' => nbd_get_chartamount_default()
		) );
		
		
		
		/* Menu bar */
		$current_user = wp_get_current_user();
		$screen = nbd_get_screen();
		

		
		$this->render_script_template('nb-dashboard-menubar', 'dashboard-menu-bar.php', array(
			'current_user' => $current_user,
			'notification_lists' => get_option('nb_notification_lists')
		));
		
		$this->render_script_template('nb-dashboard-menumain', 'dashboard-menu-main.php');
	}
	
	public function render_script_template( $id, $file, $args = array() ) {
		$inc = NBDB_ABSPATH . 'templates/' . $file;
		
		if( file_exists($inc) ) {
			extract($args);
			
			echo '<script id="tpl-'. $id .'" type="text/template">';
			include_once $inc;
			echo '</script>';
		}		
	}
	
	public function enqueue_scripts() {
		$screen = get_current_screen();
		
		$extra = array();
		if( $screen->base == 'dashboard' ) {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
				$price = str_replace('%2$s', 'number', get_woocommerce_price_format());
				$price = str_replace('%1$s', get_woocommerce_currency_symbol(), $price);
				$decimals = wc_get_price_decimals();
				$decimal_separator = wc_get_price_decimal_separator();
				$thousand_separator = wc_get_price_thousand_separator();
			}else {
				$price = str_replace('%1$s', '', $price);
				$price = str_replace('%2$s', '', $price);
				$decimals = 2;
				$decimal_separator = '.';
				$thousand_separator = ',';
			}
			
			$extra = array(
				'format_money' => $price,
				'decimals' => $decimals,
				'decimal_separator' => $decimal_separator,
				'thousand_separator' => $thousand_separator
			);
			
			wp_enqueue_style( 'admin-daterangepicker', NBDB_ABSURL . 'assets/css/daterangepicker.css' );
			
			wp_enqueue_script( 'admin-moment', NBDB_ABSURL . 'assets/js/moment.min.js' , array() );
			wp_enqueue_script( 'admin-daterangepicker', NBDB_ABSURL . 'assets/js/daterangepicker.js' , array() );
			wp_enqueue_script( 'admin-chart', 'https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.2/Chart.js' , array() );
			wp_enqueue_script( 'nb-dashboard', NBDB_ABSURL . 'assets/js/dashboard.js', array(  ));
		}
		
		if( $screen->base == 'settings_page_nb-dashboard') {
			wp_enqueue_media();
		}
		wp_enqueue_style( 'nb-dashboard', NBDB_ABSURL . 'assets/css/dashboard.min.css', array( )  );
		wp_enqueue_script( 'nb-dashboard-slimscroll', NBDB_ABSURL . 'assets/js/jquery.slimscroll.min.js', array(  ));

		
		wp_enqueue_script( 'nb-dashboard-blockUI', NBDB_ABSURL . 'assets/js/jquery.blockUI.js', array(  ));
		wp_enqueue_script( 'nb-dashboard-cookie', NBDB_ABSURL . 'assets/js/js.cookie.js', array(  ));
		
		

		wp_enqueue_script( 'nb-dashboard-admin', NBDB_ABSURL . 'assets/js/admin.js', array(  ));

		$img_src = '';
		if( $dashboard_logo = get_option('nb_dashboard_logo') ) {
			$img_src = wp_get_attachment_image_src($dashboard_logo, 'full');
			$img_src = $img_src[0];
		}

		$img_src_short = '';
		if( $dashboard_logo_mobile = get_option('nb_dashboard_logo_mobile') ) {
			$img_src_mobile = wp_get_attachment_image_src($dashboard_logo_mobile, 'full');
			$img_src_short = $img_src_mobile[0];
		}

		wp_localize_script( 'nb-dashboard-admin', 'nbdashboard', array_merge(array(
			'i18n'        => array(
				'mediaTitle'  => esc_html__( 'Choose an image', 'nb-dashboard' ),
				'mediaButton' => esc_html__( 'Use image', 'nb-dashboard' ),
			),
			'authorize' => admin_url('options-general.php?page=nb-dashboard&alt_action=ga_action_auth'),
			'json_url' => home_url() . '/wp-json/nbdash/v1/%action%',
			'label' => array(
				'item' => __('order', 'nb-dashboard'),
				'items' => __('orders', 'nb-dashboard')
			),
			'admin_url' => admin_url('/admin-ajax.php'),
			'link_logo' => '<div class="admin-header-logo nbd-header-full"><a href="' . home_url("/wp-admin") .'"><img src="' . $img_src .'"></a></div><div class="admin-header-logo nbd-header-short"><a href="' . home_url("/wp-admin") .'"><img src="' . $img_src_short .'"></a></div>'
		), $extra) );
	}
}

new NB_Dashboard_Template();
