<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists('NBD_Notification') ) {
	class NBD_Notification extends NBD_Singleton {

	    /**
	     * NPC_Register constructor.
	     *
	     * @since 0.1.0
	     */
	    public function __construct() {
			add_action( 'wpcf7_mail_sent', array($this, 'cf7_push'), 99, 1 );
			add_action( 'woocommerce_thankyou', array($this, 'wc_push'), 10, 1);
			add_action( 'user_register', array($this, 'register_push') );
			add_action( 'wp_insert_comment', array( $this, 'comment_push' ), 10, 2 );
	    }
		
		public function comment_push($id, $comment) {
			$title_message = get_option('nb_dashboard_comment_title_message');
			$content_message = get_option('nb_dashboard_comment_content_message');
			
			$content_message = str_replace('{username}', $comment->comment_author, $content_message);
			
			$this->push_notification('comment', admin_url('comment.php?action=editcomment&c=8'), $title_message, $content_message);

		}
		
		public function cf7_push($cf7) {
			if( get_option('nb_dashboard_contact_page') == $cf7->id() ) {
				$title_message = get_option('nb_dashboard_contact_title_message');
				$content_message = get_option('nb_dashboard_contact_content_message');
				
				$this->push_notification('mail', admin_url('admin.php?page=cfdb7-list.php&fid=19'), $title_message, $content_message);
			}
		}
		
		public function register_push( $user_id ) {
			$title_message = get_option('nb_dashboard_user_title_message');
			$content_message = get_option('nb_dashboard_user_content_message');
			$content_message = str_replace('{user_name}', $_POST['user_login'], $content_message);
			
			$this->push_notification('user', admin_url('user-edit.php?user_id='.$user_id), $title_message, $content_message);
		}
		
		public function wc_push($order_id) {
			if ( ! $order_id )
				return;

			// Getting an instance of the order object
			// $order = new WC_Order($order_id);
			
			// $fullname_order = get_post_meta($order_id, '_billing_first_name', true). ' ' .get_post_meta($order_id, '_billing_last_name', true);
			
			$title_message = get_option('nb_dashboard_order_title_message');
			$content_message = get_option('nb_dashboard_order_content_message');
			
			$this->push_notification('order', admin_url('post.php?post='. $order_id .'&action=edit'), $title_message, $content_message);
		}
		
		public function push_notification($type, $link, $title, $msg) {
			
			switch($type) {
				case 'mail':
					$icon = 'adminpanel-icon-mail';
					break;
				case 'order':
					$icon = 'adminpanel-icon-shopping-cart';
					break;
				case 'comment':
					$icon = 'adminpanel-icon-comment';
					break;
				default:
					$icon = 'adminpanel-icon-user-pt';
					break;
			}
			$nb_notification_lists = get_option('nb_notification_lists');
			if( !$nb_notification_lists || ! is_array($nb_notification_lists)) {
				$nb_notification_lists = array();
			}
			
			$new_notification = array(array(
				'id' => md5(time()),
				'icon' => $icon,
				'link' => $link,
				'title' => $title,
				'desc' => $msg,
				'read' => false
			));
			
			$nb_notification_lists = array_merge($new_notification, $nb_notification_lists);
			update_option('nb_notification_lists', $nb_notification_lists);
			
			$nb_notification = get_option('nb_notification');
			if( ! $nb_notification ) {
				$nb_notification = 0;
			}
			update_option('nb_notification', ($nb_notification + 1) );
			
			$nb_notification_unread = get_option('nb_notification_unread');
			if( ! $nb_notification_unread ) {
				$nb_notification_unread = 0;
			}
			update_option('nb_notification_unread', ($nb_notification_unread + 1) );
		}
		
	}
	
	new NBD_Notification();

}





