<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists('NBD_Cache') ) {
	class NBD_Cache extends NBD_Singleton {

	    /**
	     * NPC_Register constructor.
	     *
	     * @since 0.1.0
	     */
	    public function __construct() {
			$this->clear_cache_product();
			$this->clear_cache_order();
			$this->clear_cache_customer();
		}

		public function clear_cache_customer() {
			add_action( 'user_register', array($this, 'clear_cache_create_user'), 10, 1 );
			add_action( 'profile_update', array($this, 'clear_cache_create_user'), 10, 2 );
			add_action( 'deleted_user',  array($this, 'clear_cache_delete_user') );
		}

		public function clear_cache_product() {
			add_action('save_post_product', array($this, 'clear_cache_save_product'), 10, 3);
		}

		public function clear_cache_order() {
			add_action( 'woocommerce_process_shop_order_meta', array($this, 'clear_cache_update_order'), 10, 2 );
		}

		public function clear_cache_save_product() {
			if( isset($_POST['post_status']) && $_POST['post_status'] == 'publish') {
				delete_transient( 'nbd_get_total_products' );
			}
		}
		
		public function clear_cache_update_order ( $post_id, $post ) {
			if( isset($_POST['order_status']) ) {
				delete_transient( 'nbd_get_total_orders' );

				if( $_POST['order_status'] == 'wc-completed') {
					delete_transient( 'nbd_get_total_rev' );
				}
			}
		}

		public function clear_cache_create_user( $user_id, $old_user_data = null ) {
			if( isset($_POST['role']) && $_POST['role'] == 'customer' && ! empty($user_id) ) {
				delete_transient( 'nbd_get_total_user' );
			}
		}

		public function clear_cache_delete_user() {
			delete_transient( 'nbd_get_total_user' );
		}

	}
	
	new NBD_Cache();

}





