jQuery( function( $ ) {
	var NBD_BlockUI = {
		/**
		 * Init jQuery.BlockUI
		 */
		block: function($el) {
			$el.block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			});
		},

		/**
		 * Remove jQuery.BlockUI
		 */
		unblock: function($el) {
			$el.unblock();
		}
	}
	/**
	 * NBCustomHandler class.
	 */
	var NBD_Dashboard = {
		init: function() {
			$(window).load(function() {
				NBD_Dashboard.render_dashboard();
				NBD_Dashboard.call_daterange();
				NBD_Dashboard.call_slimscroll();
			});

			$(document).on('click', '.admin-chart-range .value', this.admin_chart_range);
			$(document).on('click', '.admin-dashboard-chartsales .admin-range-option span', this.admin_amount_option);
			$(document).on('click', '.admin-dashboard-chartorder .admin-range-option span', this.admin_order_option);
			$(document).on('click', '.productsale-custom-range', this.admin_range_show);
			$(document).on('click', '.player-online .player-thumb', this.play_video);
			$(document).on('click', '.admin-dashboard-video ul li', this.play_video_lists);
			$(document).on('click', '.bestseller-refresh', this.bestseller_refresh);
			
			$(document).on('click', '.admin-chart-range .admin-order-status', this.admin_order_status);

			$(window).load(function() {
				var $height = $('.player-online .player-thumb').height();
				if($height < 180) {
					$height = 180;
				}

				$('.player-online .player-thumb').attr('data-height', $height);
			});
		},

		bestseller_refresh: function(e) {
			e.preventDefault();

			var $wrapper = $(this).closest('.admin-dashboard-boxed');

			NBD_BlockUI.block($wrapper);

			$.ajax({
				url: nbdashboard.admin_url,
				data: 'action=refresh_selling',
				type: 'POST',
				datatype: 'json',
				success: function( response ) {
					NBD_BlockUI.unblock($wrapper);
					$wrapper.find('ul').html(response);
				},
				error:function(){
					NBD_BlockUI.unblock($wrapper);
					alert('There was an error when processing data, please try again !');
				}
			});
		},
		
		play_video_lists: function(e) {
			e.preventDefault();

			
			var $height = $('.player-online .player-thumb').attr('data-height');
			var $play_video = $(this).find('.player-thumb');
			NBD_Dashboard.embed_video($play_video, $height);
		},
		
		play_video: function() {
			var $height = $('.player-online .player-thumb').attr('data-height');
			NBD_Dashboard.embed_video($(this), $height);
		},
		
		embed_video: function($element, $height) {
			var $li = $element.closest('li');
			$('.admin-dashboard-video ul li').removeClass('nbd-playing');
			$li.addClass('nbd-playing');
			var $video_id = $element.attr('data-id');
			var $type = $element.attr('data-type');
			var title = $li.find('h4 > a').text();
			var desc = $li.find('.player-info > p').html();

			$('.player-online .player-info h4 > a').text(title);
			$('.player-online .player-info > p').text(desc);

			
			if($type == 'youtube') {
				$html = '<iframe width="100%" height="' + $height + '" src="https://www.youtube.com/embed/' + $video_id + '" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>';
			}else {
				$html = '<iframe width="100%" height="' + $height + '" src="https://player.vimeo.com/video/' + $video_id + '?autoplay=1" frameborder="0" title="How to set NBT Solution plugin for Prinshop Solution?" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
			}
			
			$('.player-online .player-thumb').html($html);
		},
		
		call_slimscroll: function() {
			
			if(jQuery().slimScroll) {
				$('.admin-dashboard-changelog .admin-dashboard-wrap-scroll').slimScroll({
					height: 595
				});
				
				$('.admin-dashboard-video:not(.no-scroll) .admin-dashboard-wrap-scroll').slimScroll({
					height: 474
				});
				
				$('#admin-reviews .admin-dashboard-wrap-scroll').slimScroll({
					height: 465
				});

				$('.admin-dashboard-users .admin-dashboard-wrap-scroll').slimScroll({
					height: 518
				});	
			}				
		},
		call_daterange: function() {
			if( jQuery().daterangepicker ) {
				$('.admin-dashboard-chartorder input[name="datefilter"]').on('apply.daterangepicker', function(ev, picker) {
					var $wrapper = $(this).closest('.admin-dashboard-boxed');
					var $val = picker.startDate.format('YYYY/MM/DD') + '-' + picker.endDate.format('YYYY/MM/DD');
					
					$(this).val($val);
					
					$(this).closest('.admin-chart-range').find('.value').html(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('DD/MM/YYYY') + '<i class="adminpanel-icon-arrow-down"></i>');
					var w = $(this).closest('.admin-chart-range').find('.value').outerWidth();

					$wrapper.find('input[name="datefilter"]').css("width", w);
					$wrapper.find('.productsale-custom-range').addClass('selected');
					$wrapper.find('.productsale-custom-range').attr('data-value', picker.startDate.format('YYYY/MM/DD') + '-' + picker.endDate.format('YYYY/MM/DD'));

					NBD_Dashboard.admin_order_option($val);
				});

				$('.admin-dashboard-chartorder input[name="datefilter"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
				});
				
				$('.admin-dashboard-chartorder input[name="datefilter"]').daterangepicker({
					autoUpdateInput: false,
					locale: {
					  cancelLabel: 'Clear'
					}
				});
			}			
		},

		
		admin_range_show: function() {
			$('input[name="datefilter"]').trigger('click');
			$('.admin-range-option').hide();
		},

		admin_amount_option: function( $date ) {
			var $this = $(this);
			var $wrapper_box = $this.closest('.admin-dashboard-boxed');
			var $wrapper_option = $(this).closest('.admin-chart-range');

			/* Get value filter range */
			if( $wrapper_option.hasClass('admin-order-filter') ) {
				$wrapper_box.find('.admin-order-filter .admin-range-option span').removeClass('selected');
				$wrapper_box.find('.admin-order-filter .value').html( $(this).text() + '<i class="adminpanel-icon-arrow-down"></i>');
			}else {
				$wrapper_box.find('.admin-order-status-filter .admin-range-option span').removeClass('selected');
				$wrapper_box.find('.admin-order-status-filter .admin-order-status').html( $(this).text() + '<i class="adminpanel-icon-arrow-down"></i>');
			}

			$(this).addClass('selected');
			$wrapper_box.find('.admin-range-option').hide();

			var filter_status = $wrapper_box.find('.admin-order-filter .admin-range-option span.selected').attr('data-value');
			var order_status = $wrapper_box.find('.admin-order-status-filter .admin-range-option span.selected').attr('data-value');

			if( typeof filter_status == 'undefined') {
				filter_status = 'this-week';
			}

			if( typeof order_status == 'undefined') {
				order_status = '';
			}

			if( typeof $date != 'string') {
				var $date = '';
			}

			if( $wrapper_box.find('.productsale-custom-range.selected').length > 0 ) {
				var $date = $wrapper_box.find('.productsale-custom-range.selected').val();
			}else {
				NBD_BlockUI.block($wrapper_box);
			}

			if( $wrapper_box.find('.productsale-custom-range.selected').length <= 0 ) {

				var action_json = nbdashboard.json_url.replace("%action%", "product_order_filter");

				$.ajax({
					url: action_json,
					data: 'filter=' + filter_status + '&status=' + order_status + '&range=' + $date,
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						NBD_BlockUI.unblock($wrapper_box);

						$('.admin-dashboard-chartsales .admin-price').html(response.total);
						$('.admin-dashboard-chartsales .admin-dashboard-canvas').html('<canvas id="' + filter_status + '" height="285" style="width: 100%; height: 285px;"></canvas>');

						var canvas = document.getElementById(filter_status);
						var ctx = canvas.getContext("2d");

						var lineChartData = {
							labels : response.horizontal,
							datasets : [
								{
									label: "My Second dataset",
									backgroundColor: "rgb(154, 203, 232, 0.3)",
									borderColor: "rgb(154, 203, 232, 1)",
									borderWidth: 2,
									pointBackgroundColor: "rgb(154, 203, 232, 1)",
									pointBorderColor: "#fff",
									pointBorderWidth: 1,
									pointHoverRadius: 5,
									pointHoverBackgroundColor: "#fff",
									pointHoverBorderColor: "rgb(154, 203, 232, 1)",
									pointHoverBorderWidth: 1,
									pointRadius: 4,
									pointHitRadius: 10,
									data: response.vertical

								}
							]
						}

						var myNewChart = new Chart(ctx , {
							type: "line",
							data: lineChartData,
							responsive: true,
							scaleFontFamily: "'Open Sans'",
							tooltipTitleFontFamily: "'Open Sans'",
							options: {
								responsive: true,
								legend: {
									display: false,
								},
								tooltips: {
									callbacks: {
										label: function(tooltipItem, data) {
											//console.log(tooltipItem);
											price = data['datasets'][0]['data'][tooltipItem['index']];
											price = number_format(price, nbdashboard.decimals, nbdashboard.decimal_separator, nbdashboard.thousand_separator);
											return ' ' + tooltipItem.xLabel + ': ' + nbdashboard.format_money.replace("number", price);	
										},
										title: () => null,
									}
								},
								scales: {
									yAxes: [{
										ticks: {
											beginAtZero: true
										}
									}]
								}
							},
						});

					},
					error:function(){
						alert('There was an error when processing data, please try again !');
					}
				});
			}

		},

		admin_order_option: function( $date ) {
			
			var $this = $(this);
			var $wrapper_box = $this.closest('.admin-dashboard-boxed');
			var $wrapper_option = $(this).closest('.admin-chart-range');

			/* Get value filter range */
			if( $wrapper_option.hasClass('admin-order-filter') ) {
				$('.admin-order-filter .admin-range-option span').removeClass('selected');
				$wrapper_box.find('.admin-order-filter .value').html( $(this).text() + '<i class="adminpanel-icon-arrow-down"></i>');
			}else {
				$('.admin-order-status-filter .admin-range-option span').removeClass('selected');
				$wrapper_box.find('.admin-order-status-filter .admin-order-status').html( $(this).text() + '<i class="adminpanel-icon-arrow-down"></i>');
			}

			$(this).addClass('selected');
			$wrapper_box.find('.admin-range-option').hide();
	
			var filter_status = $('.admin-order-filter .admin-range-option span.selected').attr('data-value');
			var order_status = $('.admin-order-status-filter .admin-range-option span.selected').attr('data-value');

			if( typeof filter_status == 'undefined') {
				filter_status = 'chartorder-this-week';
			}

			if( typeof order_status == 'undefined') {
				order_status = '';
			}

			if( typeof $date != 'string') {
				var $date = '';
			}

			if( $wrapper_box.find('.productsale-custom-range.selected').length > 0 ) {
				var $date = $wrapper_box.find('.productsale-custom-range.selected').val();
			}else {
				NBD_BlockUI.block($wrapper_box);
			}


			if( $wrapper_box.find('.productsale-custom-range.selected').length <= 0 ) {

				var action_json = nbdashboard.json_url.replace("%action%", "product_order_status");

				$.ajax({
					url: action_json,
					data: 'filter=' + filter_status + '&status=' + order_status + '&range=' + $date,
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						NBD_BlockUI.unblock($wrapper_box);

						$('.admin-dashboard-chartorder .admin-price').html(response.total);
						$('.admin-dashboard-chartorder .admin-dashboard-canvas').html('<canvas id="' + filter_status + '" height="285" style="width: 100%; height: 285px;"></canvas>');

						var canvas = document.getElementById(filter_status);
						var ctx = canvas.getContext("2d");

						var lineChartData = {
							labels : response.horizontal,
							datasets : [
								{
									label: "My Second dataset",
									backgroundColor: "rgb(154, 203, 232, 0.3)",
									borderColor: "rgb(154, 203, 232, 1)",
									borderWidth: 2,
									pointBackgroundColor: "rgb(154, 203, 232, 1)",
									pointBorderColor: "#fff",
									pointBorderWidth: 1,
									pointHoverRadius: 5,
									pointHoverBackgroundColor: "#fff",
									pointHoverBorderColor: "rgb(154, 203, 232, 1)",
									pointHoverBorderWidth: 1,
									pointRadius: 4,
									pointHitRadius: 10,
									data: response.vertical

								}
							]
						}

						var myNewChart = new Chart(ctx , {
							type: "line",
							data: lineChartData,
							responsive: true,
							scaleFontFamily: "'Open Sans'",
							tooltipTitleFontFamily: "'Open Sans'",
							options: {
								responsive: true,
								legend: {
									display: false,
								},
								tooltips: {
									callbacks: {
										label: function(tooltipItem, data) {
											//console.log(tooltipItem);
											price = data['datasets'][0]['data'][tooltipItem['index']];
											var label_order = nbdashboard.label.items;
											if( price == 1) {
												label_order = nbdashboard.label.item;
											}
											return ' ' + tooltipItem.xLabel + ': ' + price + ' ' + label_order;
										},
										title: () => null,
									}
								},
								scales: {
									yAxes: [{
										ticks: {
											beginAtZero: true
										}
									}]
								}
							},
						});

					},
					error:function(){
						alert('There was an error when processing data, please try again !');
					}
				});
			}
		},
		
		admin_order_status: function() {
			var $this = $(this).closest('.admin-chart-range');
			
			if( $this.hasClass('active') ) {
				$this.find('.admin-range-option').hide();
				$this.removeClass('active');
			}else {
				$this.find('.admin-range-option').show();
				$this.addClass('active');
			}
		},
		
		admin_chart_range: function() {
			if( $(this).hasClass('active') ) {
				$(this).removeClass('active');
				$(this).closest('.admin-chart-range').find('.admin-range-option').hide();
			}else {
				$(this).addClass('active');
				$(this).closest('.admin-chart-range').find('.admin-range-option').show();
			}
		},
		
		render_dashboard: function() {
			var $wrap = $('#dashboard-widgets-wrap').closest('.wrap');
			var $tpl = $('#tpl-nb-dashboard').html();
			
			$wrap.attr('id', 'nb-dashboard-wrap');
			$wrap.html($tpl);
			
			$('.notice, .woocommerce-message').remove();
		}
	}
	
	NBD_Dashboard.init();
	
});