jQuery( function( $ ) {
	
	var ajax_notification = false;

	/**
	 * NBCustomHandler class.
	 */
	var NBD_Admin = {
		init: function() {
			
			this.render_menubar();
			this.render_menumain();
			this.render_menubar_scroll();

			
			$(document).on( 'click', 'body.wp-admin:not(.folded) #adminmenu > li.wp-has-submenu > a:not(.toplevel_page_dashboard)', this.click_menu_left);
			$(document).on('click', '.nb-upload-image-button', this.upload_image);
			$(document).on( 'click', '.nb-remove-image-button', this.remove_upload_image);
			$(document).on('click', '#alt_ga_authorize_google', this.authorize);
			$(document).on('click', '.pc-admin-header-avatar .pc-has-sublink', this.show_profiles_menu);
			$(document).on('click', '.pc-notifications a', this.show_notifications_menu);
			$(document).on('click', '.link-logout', this.link_logout);
			$(document).on('change', '#nb_dashboard_cf7', this.change_wpcf7);

			$(document).on('click', '.pc-notifications', this.read_notification);
			$(document).on('click', '.pc-menu-toggle', this.menu_toggle_left);
			$(document).on('mouseenter', '#adminmenuwrap.nbd-toggle', this.menu_toggle_menu_open);
			$(document).on('mouseleave', '#adminmenuwrap.nbd-toggle', this.menu_toggle_menu_close);

			$(window).load(function() {
				NBD_Admin.heading();
				$('.nbd-loading').remove();
			});

			
			$( window ).resize(function() {
				NBD_Admin.render_menubar_scroll();
				NBD_Admin.menu_responsive();
			});
			
			$('#admin-search').keyup(function(e) {
				clearTimeout($.data(this, 'timer'));
				if (e.keyCode == 13)
				  search(true);
				else
				  $(this).data('timer', setTimeout(NBD_Admin.trigger_search, 500));
			});
			
			$(document).mouseup(function(e) 
			{
				if($(".nbd-search-rs").length){
				    var container = $(".nbd-search-rs");

				    if ( ! container.is(e.target) && container.has(e.target).length === 0 ) 
				    {
						container.hide();
						$('#admin-search').val('');
				    }
				}

				if( $(".pc-admin-header-avatar .pc-admin-header-wrapper").length ){
					var container = $(".pc-admin-header-avatar .pc-admin-header-wrapper");
					var main = $(".pc-admin-header-avatar .pc-avatar-main");
					
				    if ( ! container.is(e.target) && container.has(e.target).length === 0 && ! main.is(e.target) && main.has(e.target).length === 0) 
				    {
						container.hide();
						$('.pc-admin-header-avatar .pc-admin-header-name').removeClass('active');
				    }
				}

				if( $(".pc-notifications .pc-notifications-submenu").length ){
					var container = $(".pc-notifications .pc-notifications-submenu");
					var icon = $(".pc-notifications > a");
				    if ( ! container.is(e.target) && container.has(e.target).length === 0 && ! icon.is(e.target) && icon.has(e.target).length === 0 ) 
				    {
						container.hide();
						$('.pc-notifications').removeClass('nbd-active');
				    }
				}
			});
			
			$('#adminmenuback').html(nbdashboard.link_logo);

			if( Cookies.get('menu_toggle') ) {
				NBD_Admin.menu_toggle_left();
				$('.pc-menu-toggle').addClass('active');
				
			}

			NBD_Admin.menu_responsive();
		},

		menu_responsive: function() {
			var w= $(window).width();
			if(w <= 768) {
				$('.pc-menu-toggle').addClass('flyout-hamburger');
				$('html.wp-toolbar #wpcontent, html.wp-toolbar #wpfooter').css("margin-left", "0");
				$('#adminmenuwrap').removeAttr('style');
				$('#adminmenuwrap').removeClass('nbd-toggle');
				$('#wpadminbar.mobile').removeClass('active');
			}else {
				$('.pc-menu-toggle').removeClass('flyout-hamburger');
				$('html.wp-toolbar #wpcontent, html.wp-toolbar #wpfooter').removeAttr('style');
			}

			if(w > 768 && w <= 1024) {
				NBD_Admin.menu_toggle_left();
				$('.pc-menu-toggle').addClass('active');
				$('#adminmenuwrap').show();
			}
		},
		

		menu_toggle_left: function() {
			var w = $(window).width();

			if(w > 768) {
				if( $(this).hasClass('active') ) {
					$(this).removeClass('active');

					$('#adminmenuback, #adminmenuwrap').removeClass('nbd-toggle');

					$('html.wp-toolbar #adminmenuwrap, html.wp-toolbar #adminmenuback').animate({
						width: '220px',
					});

					$('html.wp-toolbar #wpcontent').animate({
						marginLeft: '220px',
					});

			
					$('html.wp-toolbar #wpadminbar').animate({
						left: '220px'
					});
					Cookies.remove('menu_toggle');
				}else {
					$(this).addClass('active');

					$('#adminmenuback, #adminmenuwrap').addClass('nbd-toggle', 5000, 'swing');

					$('#adminmenuwrap, html.wp-toolbar #adminmenuback').animate({
						width: '70px',
					});

					$('html.wp-toolbar #wpcontent').animate({
						marginLeft: '70px',
					});

					$('html.wp-toolbar #wpadminbar').animate({
						left: '70px'
					});

					Cookies.set('menu_toggle', true);
				}
			}else {
				if( $(this).hasClass('active') ) {
					$(this).removeClass('active');
					Cookies.remove('menu_toggle');

					$('html.wp-toolbar .auto-fold #adminmenuwrap').slideUp();
				}else {
					$(this).addClass('active');
					Cookies.set('menu_toggle', true);

					$('html.wp-toolbar .auto-fold #adminmenuwrap').slideDown();
				}
			}
		},

		menu_toggle_menu_open: function() {
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).addClass('active');
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).animate({
				width: '220px',
			});

		},
		
		menu_toggle_menu_close: function() {
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).removeClass('active');
			$('html.wp-toolbar #adminmenuwrap').stop(true,false).animate({
				width: '70px',
			});
		},

		trigger_search: function(force) {
			$('.adminpanel-icon-search').hide();
			$('.adminpanel-icon-sloading').show();
			var action_json = nbdashboard.json_url.replace("%action%", "live_search");
			var existingString = $("#admin-search").val();
			if (!force && existingString.length < 3) return; //wasn't enter, not > 2 char
				$.ajax({
					url: action_json,
					data: { search: existingString },
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						$('.adminpanel-icon-search').show();
						$('.adminpanel-icon-sloading').hide();
						if( response.complete != undefined ) {		
							$('.pc-admin-header-search .nbd-search-rs ul').html(response.html);
							$('.pc-admin-header-search .nbd-search-rs').show();
						}
					},
					error: function() {
						//alert('There was an error when processing data, please try again !');
					}
				});
		},
		
		read_notification: function() {
			var count = $(this).attr('data-count');

			if( ! ajax_notification ) {
				ajax_notification = true;
				
				var action_json = nbdashboard.json_url.replace("%action%", "read_notification");

				$.ajax({
					url: action_json,
					data: {},
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						if( response.complete != undefined ) {
							$('.pc-notifications-count').text(response.count);
						}
					},
					error: function() {
						//alert('There was an error when processing data, please try again !');
					}
				});
				
			}
		},
		
		change_wpcf7: function(e) {
			e.preventDefault();
			
			var $cf7id = $(this).val();
			
			if( $cf7id ) {
				
				var action_json = nbdashboard.json_url.replace("%action%", "cf7field");

				$.ajax({
					url: action_json,
					data: { id: $cf7id},
					type: 'POST',
					datatype: 'json',
					success: function( response ) {
						if( response.complete != undefined ) {
							$('#nb_dashboard_cf7_field').find('select').html(response.fields);
							$('#nb_dashboard_cf7_field').show();
						}
					},
					error: function() {
						alert('There was an error when processing data, please try again !');
					}
				});
			}else{
				$('#nb_dashboard_cf7_field').hide();
			}
		},
		
        link_logout: function(event) {
            event.isDefaultPrevented();

            var action_json = nbdashboard.json_url.replace("%action%", "logout");

            $.ajax({
                url: action_json,
                data: {},
                type: 'POST',
                datatype: 'json',
                success: function( response ) {
					if( response.complete != undefined ) {
                        window.location.href = response.location;
					}
                },
                error: function() {
                    alert('There was an error when processing data, please try again !');
                }
            })
		},
		
		show_profiles_menu: function(event) {
			event.preventDefault();
			$('.admin-submenu').hide();


			var $this = $(this).closest('li');
			if( $(this).hasClass('active') ) {
				$(this).removeClass('active');
				$this.find('.admin-submenu').hide();
			}else {
				$(this).addClass('active')
				$this.find('.admin-submenu').show();
			}
		},
		
		show_notifications_menu: function(event) {
			event.preventDefault();
			$('.pc-notifications-submenu').hide();

			var $this = $(this).closest('li');
			if( $('.pc-notifications').hasClass('nbd-active') ) {
				$('.pc-notifications').removeClass('nbd-active');
				$this.find('.pc-notifications-submenu').hide();
				console.log(2222);
			}else {
				$('.pc-notifications').addClass('nbd-active');
				$this.find('.pc-notifications-submenu').show();
				if( $( ".pc-notifications-submenu ul li" ).length > 5 ) {
					$('.pc-notifications-submenu ul').slimScroll({
						height: 450
					});
				}
			}
		},
		
		authorize: function (e, url) {
            console.log(nbdashboard.authorize);
            e.preventDefault();
            const p_width = Math.round(screen.width / 2);
            const p_height = Math.round(screen.height / 2);
            const p_left = Math.round(p_width / 2);
            const p_top = 200;
            window.open(nbdashboard.authorize, 'ga_auth_popup', 'width=' + p_width + ',height='
                + p_height + ',top=' + p_top + ',left=' + p_left);
        },
		
		upload_image: function(e){
			e.preventDefault();
			var $button = $( this ).closest('.nb-wrap-image');

			// If the media frame already exists, reopen it.
			if ( frame ) {
				frame.open();
				return;
			}
			
			// Create the media frame.
			var frame = wp.media.frames.downloadable_file = wp.media({
				title   : 'NB Dashboard Logo',
				button  : {
					text: 'Use image'
				},
				multiple: false
			});
			
			console.log(frame);


			// When an image is selected, run a callback.
			frame.on( 'select', function () {
				var attachment = frame.state().get( 'selection' ).first().toJSON();
				$button.find( 'input.nb-image' ).val( attachment.id );
				$button.find( 'input.nb-image-url' ).val( attachment.sizes.full.url );
				$button.find( '.nb-remove-image-button' ).show();
				$button.find( 'img' ).attr( 'src', attachment.sizes.full.url );
			} );

			// Finally, open the modal.
			frame.open();
		},
		
		remove_upload_image: function(){
			var $button = $( this );

			$button.siblings( 'input.nb-image' ).val( '' );
			$button.siblings( '.nb-remove-image-button' ).show();
			$button.parent().prev( '.nb-image-thumbnail' ).find( 'img' ).attr( 'src', $( this ).closest('tr').attr('data-src') );

			return false;
		},
		
		heading: function() {
			if( $('#nb-dashboard-wrap').length <= 0 ) {
				$('.wp-heading-inline, .page-title-action, .wrap > h1').addClass('page-section');
				$( ".page-section" ).wrapAll( "<div class='admin-heading xxxxxxx' />");	
			}
			
			if( $('.wrap h1.page-section').length > 0 ) {
				$('.wrap').addClass('wrap-top');
			}
		},
		
		
		
		render_menubar: function() {
			var $tpl = $('#tpl-nb-dashboard-menubar').html();
			$('#wpadminbar').html($tpl);
		},
		
		
		render_menubar_scroll: function() {
			if(jQuery().slimScroll) {
				var $width = $(window).width();
				var $height = $(window).height() - $('#wpadminbar').outerHeight();
				

				
 				//if( $width > 960 ) {
                    $('#adminmenu').slimScroll({
                        height: $height
                    });
				//}

			}
		},
		
		render_menumain: function() {
			$('.wp-menu-separator').remove();
			$('#adminmenu .wp-has-submenu .wp-menu-name').append('<i class="adminpanel-icon-arrow-right"></i>');
		},
		
		click_menu_left: function() {
			var $ul = $(this).next();
			var $li = $(this).closest('li');

			if( $li.hasClass('menu-current') ) {
				if( $li.hasClass('menu-current') ) {
					$ul.slideUp();
					$li.removeClass('menu-current');
				}else {
					$ul.slideDown();
					$li.addClass('menu-current');
				}
			}else {
				if( $li.hasClass('wp-menu-open') ) {
					console.log(22222222);
					$ul.slideUp();
					$li.removeClass('wp-menu-open');
				}else {
					var $other = $('#adminmenu > li:not(.wp-has-current-submenu)');
					$other.removeClass('wp-menu-open');
					$other.find('.wp-submenu').slideUp();

					$ul.slideDown();
					$li.addClass('wp-menu-open');
				}
				
				NBD_Admin.render_menubar_scroll();
			}

			return false;
		}
		
	}
	
	NBD_Admin.init();
	
});