<?php
if ( ! class_exists( 'Merlin' ) ) {
	return;
}

/**
 * Set directory locations, text strings, and other settings for Merlin WP.
 */
$wizard = new Merlin(
	// Configure Merlin with custom settings.
	$config = array(
		'directory'                => '', // Location where the 'merlin' directory is placed.
		'merlin_url'               => 'merlin', // Customize the page URL where Merlin WP loads.
		'child_action_btn_url'     => 'https://codex.wordpress.org/Child_Themes',  // The URL for the 'child-action-link'.
		'help_mode'                => false, // Set to true to turn on the little wizard helper.
		'dev_mode'                 => true, // Set to true if you're testing or developing.
		'branding'                 => true, // Set to false to remove Merlin WP's branding.
	),
	// Text strings.
	$strings = array(
		'admin-menu'               => esc_html__( 'Theme Setup' , 'printcart' ),
		'title%s%s%s%s' 		       => esc_html__( '%s%s Themes &lsaquo; Theme Setup: %s%s' , 'printcart' ),

		'return-to-dashboard'      => esc_html__( 'Return to the dashboard' , 'printcart' ),

		'btn-skip'                 => esc_html__( 'Skip' , 'printcart' ),
		'btn-next'                 => esc_html__( 'Next' , 'printcart' ),
		'btn-start'                => esc_html__( 'Start' , 'printcart' ),
		'btn-no'                   => esc_html__( 'Cancel' , 'printcart' ),
		'btn-plugins-install'      => esc_html__( 'Install' , 'printcart' ),
		'btn-child-install'        => esc_html__( 'Install' , 'printcart' ),
		'btn-content-install'      => esc_html__( 'Install' , 'printcart' ),
		'btn-import'               => esc_html__( 'Import' , 'printcart' ),

		'welcome-header%s'         => esc_html__( 'Welcome to %s' , 'printcart' ),
		'welcome-header-success%s' => esc_html__( 'Hi. Welcome back' , 'printcart' ),
		'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.' , 'printcart' ),
		'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.' , 'printcart' ),

		'child-header'             => esc_html__( 'Install Child Theme' , 'printcart' ),
		'child-header-success'     => esc_html__( 'You\'re good to go!' , 'printcart' ),
		'child'                    => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.' , 'printcart' ),
		'child-success%s'          => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.' , 'printcart' ),
		'child-action-link'        => esc_html__( 'Learn about child themes' , 'printcart' ),
		'child-json-success%s'     => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.' , 'printcart' ),
		'child-json-already%s'     => esc_html__( 'Awesome. Your child theme has been created and is now activated.' , 'printcart' ),

		'plugins-header'           => esc_html__( 'Install %d plugins' , 'printcart' ),
		'plugins-header-success'   => esc_html__( 'You\'re up to speed!' , 'printcart' ),
		'plugins'                  => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.' , 'printcart' ),
		'plugins-success%s'        => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.' , 'printcart' ),
		'plugins-action-link'      => esc_html__( 'Advanced' , 'printcart' ),

		'import-header-1'            => esc_html__( 'Choose your own theme' , 'printcart' ),
		'import-1'                   => esc_html__( 'See %d+ home layouts' , 'printcart' ),
		'import-header-2'            => esc_html__( 'Choose Your Theme' , 'printcart' ),
		'import-2'                   => esc_html__( 'There are many unique and sophisticated theme are available on Printcart.com that you can choose the one is suitable for your printing business' , 'printcart' ),
		'import-header-3'            => esc_html__( 'Import data' , 'printcart' ),
		'import-3'                   => esc_html__( 'You will get the demo data of the theme which you chose and you can customize it if you want' , 'printcart' ),
		'import-header-4'            => esc_html__( 'Importing...' , 'printcart' ),
		'import-4'                   => esc_html__( 'Please be patient. It will be ended soon.
			Do not quit or shut down your browser' , 'printcart' ),
		'process-4'                => esc_html__( 'Importing Printcart data' , 'printcart' ),

		'import-header'            => esc_html__( 'Import Content' , 'printcart' ),
		'import'                   => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.' , 'printcart' ),
		'import-action-link'       => esc_html__( 'Advanced' , 'printcart' ),

		'ready-header'             => esc_html__( 'Import Successfully!!!' , 'printcart' ),
		'ready%s'                  => esc_html__( 'Your site has been set up successfully. Enjoy your new site by %s' , 'printcart' ),
		'ready-action-link'        => esc_html__( 'Extras' , 'printcart' ),
		'ready-big-button'         => esc_html__( 'View your site' , 'printcart' ),

		'ready-link-1'             => wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__( 'Explore WordPress', 'printcart' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'ready-link-2'             => wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'http://cmsmart.net', esc_html__( 'Get Theme Support', 'printcart' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
		'ready-link-3'             => wp_kses( sprintf( '<a href="'.admin_url( 'customize.php' ).'" target="_blank">%s</a>', esc_html__( 'Start Customizing', 'printcart' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
	),
$plugins = array(
	array(
		'name' => 'Woocommerce',
		'slug' => 'woocommerce',
		'thumb' => get_template_directory_uri() . '/assets/netbase/images/plugins/woocommerce.png',
		'required' => true,
		'version' => '3.4.4',
	),
	array(
		'name' => 'Contact Form 7',
		'slug' => 'contact-form-7',
		'required' => false,
		'version' => '5.0.3',
	),
	array(
		'name' => 'MailChimp for WordPress',
		'slug' => 'mailchimp-for-wp',
		'required' => false,
		'version' => '4.2.4',
	),
	array(
		'name' => 'Slider Revolution',
		'slug' => 'revslider',
		'required' => false,
		'version' => '5.4.8',
		'source' => get_template_directory() . '/plugins/revslider.zip',
	),
	array(
		'name' => 'WPBakery Visual Composer',
		'slug' => 'js_composer',
		'required' => true,
		'version' => '5.5.2',
		'source' => get_template_directory() . '/plugins/js_composer.zip',
	),
	array(
		'name' => 'Ultimate Addons for Visual Composer',
		'slug' => 'Ultimate_VC_Addons',
		'required' => true,
		'version' => '3.6.12',
		'source' => get_template_directory() . '/plugins/Ultimate_VC_Addons.zip',
	),
	array(
		'name' => 'Netbase Framework',
		'slug' => 'nb-fw',
		'required' => true,
		'version' => '1.3.1',
		'source' => get_template_directory() . '/plugins/nb-fw.zip',
	),
	array(
		'name' => 'Netbase Elements',
		'slug' => 'nb-elements',
		'required' => true,
		'version' => '1.0.0',
		'source' => get_template_directory() . '/plugins/nb-elements.zip',
	),
	array(
		'name' => 'Netbase Solutions',
		'slug' => 'netbase_solutions',
		'required' => true,
		'version' => '1.2.4',
		'source' => get_template_directory() . '/plugins/netbase_solutions.zip',
	),
	array(
		'name' => 'Max Mega Menu',
		'slug' => 'megamenu',
		'required' => true,
		'version' => '2.5',
	),
	array(
		'name' => 'Nbdesigner',
		'slug' => 'web-to-print-online-designer',
		'required' => true,
		'version' => '1.8.0',
		'source' => get_template_directory() . '/plugins/web-to-print-online-designer.zip',
	),
	array(
		'name' => 'YITH WooCommerce Compare',
		'slug' => 'yith-woocommerce-compare',
		'required' => true,
		'version' => '2.3.1',
	),
	array(
		'name' => 'YITH WooCommerce Wishlist',
		'slug' => 'yith-woocommerce-wishlist',
		'required' => true,
		'version' => '2.2.3',
	),
	array(
		'name' => 'YITH WooCommerce Quick View',
		'slug' => 'yith-woocommerce-quick-view',
		'required' => true,
		'version' => '1.3.1',
	)
)
);

function princart_local_import_files() {
	return array(
		array(
			'import_file_name'             => 'Theme 01 Business',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-business/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/revslider/parallax_scroll_slider.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-business/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-business/',
			'title_home_page'                  => 'Home',
			'menu_settings'                  => array(
				'primary' => 'Main Menu'
			),
			'term_meta_key'                     => '',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-01/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'agency-books',
				'color_swatches' => 'pro-card-visit-a1'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 02 Parallax',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-parallax/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/revslider/home.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-parallax/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-parallax/',
			'title_home_page'                  => 'Home',
			'menu_settings'                  => array(
				'primary' => 'Main menu'
			),
			'term_meta_key'                     => '',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-02/data/widget/widget_nav_menu.txt',
				'no_title' => true,
			),
			'product_variation' => array(
				'price_matrix' => 'marketing-postcards-2018a-lorem-ipsum-2',
				'color_swatches' => 'marketing-postcards-2018a-relinquet-2'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 03 Mug',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-mug/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => '',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/revslider/home-3.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-mug/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-mug/',
			'title_home_page'                  => 'Home 3',
			'menu_settings'                  => array(
				'primary' => 'Main Menu'
			),
			'term_meta_key'                     => '',
			'local_import_icon_font_file' => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/our-services.zip',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-03/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'solid-color-layer',
				'color_swatches' => 'mama-mug'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 04 Wedding Card',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-wedding-card/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/revslider/sliderhome4.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-wedding-card/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-wedding-card/',
			'title_home_page'                  => 'Home 4',
			'menu_settings'                  => array(
				'primary' => 'support'
			),
			'term_meta_key'                     => 'brands_thumbnail',
			'local_import_icon_font_file' => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/icomoon.zip',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-04/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'wedding-invitation-template-a3',
				'color_swatches' => 'wedding-invitation-template-a2'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 05 e-Gift Card',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-e-gift-cart/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/customize.dat',
			'local_import_rev_slider_file' => '',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-e-gift-cart/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-e-gift-cart/',
			'title_home_page'                  => 'home5',
			'menu_settings'                  => array(
				'primary' => 'primary'
			),
			'term_meta_key'                     => 'brands_thumbnail',
			'local_import_icon_font_file' => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/icomoon.zip',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-05/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'wedding-invitation-template-b2',
				'color_swatches' => 'wedding-invitation-template-a5'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 06 Noel',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-noel/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/revslider/Slider-6.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-noel/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-noel/',
			'title_home_page'                  => 'home6',
			'menu_settings'                  => array(
				'primary' => 'primary'
			),
			'term_meta_key'                     => 'brands_thumbnail',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-06/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'wise-men-18-christmas-boxed-cards-4',
				'color_swatches' => 'wise-men-18-christmas-boxed-cards-2'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 07 Young',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-young/wp-content/themes/printcart-child.zip',
			
			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => '',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/revslider/Slider-7.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-young/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-young/',
			'title_home_page'                  => 'home7',
			'menu_settings'                  => array(
				'primary' => 'primary'
			),
			'term_meta_key'                     => '',
			'local_import_icon_font_file' => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/icomoon.zip',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-07/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'wise-men-18-christmas-boxed-cards-3',
				'color_swatches' => 'wise-men-18-christmas-boxed-cards'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 08 Phone Case',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-phone-case/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/revslider/slider_home6.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-phone-case/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-phone-case/',
			'title_home_page'                  => 'Printcart Homepage 8',
			'menu_settings'                  => array(
				'primary' => 'main'
			),
			'term_meta_key'                     => 'brands_thumbnail',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-08/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'aloha-from-hawaii-slim',
				'color_swatches' => 'colorful-flowers-slim'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 09 Tote Bags',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-tote-bags/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/revslider/slider_home9.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-tote-bags/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-tote-bags/',
			'title_home_page'                  => 'Home 9',
			'menu_settings'                  => array(
				'primary' => 'primary'
			),
			'term_meta_key'                     => 'brands_thumbnail',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-09/data/widget/widget_nav_menu.txt',
			),
			'product_variation' => array(
				'price_matrix' => 'army-longline-coat-4',
				'color_swatches' => 'army-longline-coat-2'
			),
			'nbdesigner' => 'yes',
		),
		array(
			'import_file_name'             => 'Theme 10 Teepro',
			'url_path_child_theme'            => 'http://demo2.cmsmart.net/printcart_tf/printcart-teepro/wp-content/themes/printcart-child.zip',

			'local_import_file_data'            => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/demodata.xml',
			'local_import_megamenu_themes'            => array(
				'megamenu_themes' => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/maxmegamenu/themes.txt',
				'megamenu_settings' => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/maxmegamenu/settings.txt',
			),
			'local_import_product_cat'            => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/product_cat_reading.txt',
			'local_import_solutions_core'            => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/solutions_core_settings.txt',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/widget/widget_data.wie',
			'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/customize.dat',
			'local_import_rev_slider_file' => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/revslider/slider_home4.zip',
			'local_import_rev_slider_file2' => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/revslider/slide.zip',
			'import_preview_image_url'     => 'http://demo2.cmsmart.net/printcart_tf/printcart-teepro/wp-content/themes/printcart-child/screenshot.jpg',
			'import_notice'                => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'printcart' ),
			'preview_url'                  => 'http://demo2.cmsmart.net/printcart_tf/printcart-teepro/',
			'title_home_page'                  => 'Home',
			'menu_settings'                  => array(
				'primary' => 'MAIN'
			),
			'term_meta_key'                     => 'brands_thumbnail',
			'local_import_widget_nav_menu_file' => array(
				'widget_nav_menu' => trailingslashit( get_template_directory() ) . 'demo/demo-10/data/widget/widget_nav_menu.txt',
				'no_title' => true,
			),
			'product_variation' => array(
				'price_matrix' => 'army-longline-coat-5',
				'color_swatches' => 'army-longline-coat-7'
			),
			'nbdesigner' => 'yes',
		)
	);
}
add_filter( 'merlin_import_files', 'princart_local_import_files' );