jQuery( function( $ ) {
	var nb_tour = {
		init: function() {
			$(window).load(function() {
				setTimeout(function(){
					nb_tour.tour_dialog();
				}, 1000);
			});
			
			/* For only tooltip orderupload */
			$('.nbt-oupload-body').bind('DOMSubtreeModified', function(){
				$('.nbtour-step-backdrop').addClass('nbTour-active');
			});
			
			/* For only Price Matrix */
			$(document).on('click', '.price-matrix-table .price', function() {
				if( $('.nbtour-step-backdrop').length > 0 ) {
					$('.nbtour-step-backdrop').css("margin-top", "-94px");
				}
				
			});
			
			/* Color Swatches */
			$( document ).ajaxComplete(function( event, request, settings ) {
				if( $('.nbtour-step-backdrop').length > 0 ) {
					var _url = settings.url;
					
					if( _url.search("get_variation") >= 0 && $('.nbt-variations .variations.nbtour-step-backdrop').length > 0 ) {
						console.log('%c--- NBTOUR: FAKE AJAX ---', 'background: #222; color: #bada55; padding: 5px 15px;' );
						$('.nbtour-step-backdrop').css("margin-top", "-29px");
					}
					//
					
				}
			});
		},
		
		// is_visible: function (element) {
			// var element = $(element);
			// return (element.css('display') !== 'none' && element.css('visibility') !== 'hidden' && element.css('opacity') !== 0);
		// },
		
		tour_dialog: function() {
			console.log('%c--- NBTOUR: START ---', 'background: #0066cc; color: #fff; padding: 5px 15px;' );

			$.each(nbtour_params.data, function(element, array) {
				
				/* Action Next */
				var nbtour_element = Cookies.get( 'nbtour_element');
				var nbtour_tour = Cookies.get( 'nbtour_tour');
				var data = nbtour_params.data[element];
				
				var nbtour_key = parseInt( Cookies.get( 'nbtour_key') );
				var nbtour_data = Cookies.get( 'nbtour_data');
				var nbtour_step = parseInt( Cookies.get( 'nbtour_step') );

				if( nbtour_tour ) {
					if( nbtour_tour == element ) {
						var skip_data = array[nbtour_step];

						if( skip_data && $(skip_data.element).length ) {
							console.log('%c--- NBTOUR: NEXT TOUR ---', 'background: #222; color: #bada55; padding: 5px 15px;' );
							console.log(skip_data.element);
							console.log(nbtour_key);
							console.log(nbtour_tour);
							
							$( skip_data.element ).nbTour({
								backdrop: true,
								data: array,
								step: nbtour_step,
								key: nbtour_tour,
								cookie: true
							});
						}

					}
					return;
				}
				
				if( nbtour_element ) {
					if( nbtour_key == element ) {
						console.log(nbtour_params.data[nbtour_key][nbtour_step]);
						console.log(nbtour_key);
						console.log(nbtour_step);
						console.log(element);
						
						var skip_data = array[nbtour_step];

						if( skip_data && skip_data.element == nbtour_element && $(nbtour_element).length ) {
							console.log('%c--- NBTOUR: CALL COOKIE ---', 'background: #222; color: #bada55; padding: 5px 15px;' );
							
							$( nbtour_element ).nbTour({
								backdrop: true,
								data: array,
								step: nbtour_step,
								cookie: true
							});
							
							return;
						}
					}
				}

				
				/* Init Action */
				if( $( data[0].element ).length && element == 0 ) {
					console.log('%c--- NBTOUR: CALL INIT ---', 'background: #222; color: #bada55; padding: 5px 15px;' );
					console.log(data[0].element);
					$( data[0].element ).nbTour({
						backdrop: true,
						data: array,
						step: 0,
						key: 0
					});
				}

			});
		}
	}

	nb_tour.init();
});