<?php
class nbTour_Backend {
    /**
     * @var null
     *
     * @since 0.0.1
     */
    private static $instance = null;
	
    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NBT_Envato_API
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }
	
    /**
     * nbTour constructor.
     *
     * @since 0.0.1
     */
    private function __construct() {
		add_filter( 'nbtour_backend', array( __CLASS__, 'nbtour_backend' ) );
	}
	
	public static function nbtour_backend() {
		return array(
			'#post-911 .column-name' => array(
				array(
					'element' => '#post-911 .column-name',
					'position' => 'right',
					'type' => 'click',
					'title' => 'Element Position Window 1/3',
					'content' => 'Đây là bước thứ 1. You can choose between 9 "window positions" to position your slide on window borders.',
					'offset_background' => array(
						'top' => 20
					),
					'offset_popup' => array(
						'top' => 10
					)
				),
				array(
					'element' => '#publish',
					'position' => 'left',
					'type' => 'click',
					'title' => 'Element Position Window 2/3',
					'content' => 'Đây là bước thứ 2. You can choose between 9 "window positions" to position your slide on window borders.',
					'offset_background' => array(
						'top' => 17
					),
					'offset_popup' => array(
						'top' => -2
					)
				),
				array(
					'element' => '#add-new-comment a',
					'position' => 'right',
					'type' => 'text',
					'title' => 'Element Position Window 3/3',
					'content' => 'Đây là bước thứ 3. You can choose between 9 "window positions" to position your slide on window borders.',
					'offset_background' => array(
						'top' => 17
					),
					'offset_popup' => array(
						'top' => 20
					)
				),
				array(
					'element' => '#product_cat-add-toggle',
					'position' => 'left',
					'type' => 'text',
					'title' => 'Element Position Window 4/4',
					'content' => 'Đây là bước thứ 4. You can choose between 9 "window positions" to position your slide on window borders.',
					'offset_background' => array(
						'top' => 19
					)
				)
			),
			// '#delete-action .submitdelete' => array(
				// array(
					// 'element' => '#delete-action .submitdelete',
					// 'position' => 'left',
					// 'type' => 'text',
					// 'toggle' => true,
					// 'title' => 'Element Position Window 5/5',
					// 'content' => 'Đây là bước thứ 5. You can choose between 9 "window positions" to position your slide on window borders.',
					// 'offset_background' => array(
						// 'top' => 19
					// )
				// ),
				// array(
					// 'element' => '#set-post-thumbnail',
					// 'position' => 'left',
					// 'type' => 'text',
					// 'toggle' => true,
					// 'title' => 'Element Position Window 6/6',
					// 'content' => 'Đây là bước thứ 6. You can choose between 9 "window positions" to position your slide on window borders.',
					// 'offset_background' => array(
						// 'top' => 19
					// )
				// )
			// )
		);
	}
}